/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.services.shortview;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.services.shortview.FakeApplicationOntologyService;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShortViewLogger {
    private static final Log log = LogFactory.getLog(ShortViewLogger.class);

    public static void log(String contextName, Individual individual, String classUri, FakeApplicationOntologyService.TemplateAndDataGetters tdg) {
        if (ShortViewLogger.isLogging()) {
            log.info((Object)("Using custom short view in " + contextName + " because '" + individual.getURI() + "' (" + individual.getLabel() + ") has type '" + classUri + "': " + tdg));
        }
    }

    public static void log(String contextName, Individual individual) {
        if (ShortViewLogger.isLogging()) {
            log.info((Object)("Using default short view in " + contextName + " for '" + individual.getURI() + "' (" + individual.getLabel() + ")"));
        }
    }

    private static boolean isLogging() {
        return log.isInfoEnabled() && DeveloperSettings.getInstance().getBoolean(Key.PAGE_CONTENTS_LOG_CUSTOM_SHORT_VIEW);
    }
}

