/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.services.shortview;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.services.freemarker.FreemarkerProcessingService;
import edu.cornell.mannlib.vitro.webapp.services.freemarker.FreemarkerProcessingServiceSetup;
import edu.cornell.mannlib.vitro.webapp.services.shortview.FakeApplicationOntologyService;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewLogger;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewService;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShortViewServiceImpl
implements ShortViewService {
    private static final Log log = LogFactory.getLog(ShortViewServiceImpl.class);
    private final FakeApplicationOntologyService faker;

    public ShortViewServiceImpl(FakeApplicationOntologyService faker) {
        this.faker = faker;
    }

    @Override
    public String renderShortView(Individual individual, ShortViewService.ShortViewContext context, Map<String, Object> modelMap, VitroRequest vreq) {
        ShortViewService.TemplateAndSupplementalData tsd = this.getShortViewInfo(individual, context, vreq);
        String templateName = tsd.getTemplateName();
        Map<String, Object> supplementalData = tsd.getSupplementalData();
        try {
            HashMap<String, Object> fullModelMap = new HashMap<String, Object>(modelMap);
            fullModelMap.putAll(supplementalData);
            FreemarkerProcessingService fps = FreemarkerProcessingServiceSetup.getService(vreq.getSession().getServletContext());
            if (!fps.isTemplateAvailable(templateName, (HttpServletRequest)vreq)) {
                return "<p>Can't find the short view template '" + templateName + "' for " + individual.getName() + "</p>";
            }
            return fps.renderTemplate(templateName, fullModelMap, (HttpServletRequest)vreq);
        }
        catch (FreemarkerProcessingService.TemplateParsingException e) {
            log.error((Object)e, (Throwable)e);
            return "<p>Can't parse the short view template '" + templateName + "' for " + individual.getName() + "</p>";
        }
        catch (FreemarkerProcessingService.TemplateProcessingException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                log.error((Object)e);
                return "<p>Can't find the short view template '" + templateName + "' for " + individual.getName() + "</p>";
            }
            log.error((Object)e, (Throwable)e);
            return "<p>Can't process the short view template '" + templateName + "' for " + individual.getName() + "</p>";
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return "<p>Failed to render the short view for " + individual.getName() + "</p>";
        }
    }

    @Override
    public ShortViewService.TemplateAndSupplementalData getShortViewInfo(Individual individual, ShortViewService.ShortViewContext svContext, VitroRequest vreq) {
        FakeApplicationOntologyService.TemplateAndDataGetters tdg = this.fetchTemplateAndDataGetters(individual, svContext, vreq);
        Map<String, Object> gotData = this.runDataGetters(tdg.getDataGetters(), individual);
        return new TemplateAndSupplementalDataImpl(tdg.getTemplateName(), gotData);
    }

    private SortedSet<String> figureMostSpecificClassUris(Individual individual) {
        TreeSet<String> classUris = new TreeSet<String>();
        classUris.addAll(individual.getMostSpecificTypeURIs());
        return classUris;
    }

    private FakeApplicationOntologyService.TemplateAndDataGetters fetchTemplateAndDataGetters(Individual individual, ShortViewService.ShortViewContext svContext, VitroRequest vreq) {
        ArrayList<String> classUris = new ArrayList<String>();
        classUris.addAll(this.figureMostSpecificClassUris(individual));
        for (String classUri : classUris) {
            FakeApplicationOntologyService.TemplateAndDataGetters tdg = this.faker.getShortViewProperties(vreq, individual, classUri, svContext.name());
            if (tdg == null) continue;
            ShortViewLogger.log(svContext.name(), individual, classUri, tdg);
            return tdg;
        }
        ShortViewLogger.log(svContext.name(), individual);
        return new FakeApplicationOntologyService.TemplateAndDataGetters(svContext.getDefaultTemplateName(), new DataGetter[0]);
    }

    private Map<String, Object> runDataGetters(Set<DataGetter> dataGetters, Individual individual) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("individualUri", individual.getURI());
        HashMap<String, Object> gotData = new HashMap<String, Object>();
        for (DataGetter dg : dataGetters) {
            gotData.putAll(dg.getData(valueMap));
        }
        return gotData;
    }

    private static class TemplateAndSupplementalDataImpl
    implements ShortViewService.TemplateAndSupplementalData {
        private final String templateName;
        private final Map<String, Object> customData;

        public TemplateAndSupplementalDataImpl(String templateName, Map<String, Object> customData) {
            this.templateName = templateName;
            this.customData = customData;
        }

        @Override
        public String getTemplateName() {
            return this.templateName;
        }

        @Override
        public Map<String, Object> getSupplementalData() {
            return this.customData;
        }
    }
}

