/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner;

import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ConfiguredReasonerListener;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerStatementPattern;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxReasoner;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockedModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockedOntModel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;

public class InferenceModelUpdater {
    private static final Log log = LogFactory.getLog(InferenceModelUpdater.class);
    private final TBoxReasoner reasoner;
    private final LockableModel lockableInferencesModel;
    private final LockableOntModel lockableFullModel;
    private final ConfiguredReasonerListener listener;
    private int addCount;
    private int retractCount;

    public int getAddCount() {
        return this.addCount;
    }

    public int getRetractCount() {
        return this.retractCount;
    }

    public InferenceModelUpdater(TBoxReasoner reasoner, LockableModel lockableInferencesModel, LockableOntModel lockableFullModel, ConfiguredReasonerListener listener) {
        this.reasoner = reasoner;
        this.lockableInferencesModel = lockableInferencesModel;
        this.lockableFullModel = lockableFullModel;
        this.listener = listener;
    }

    public void update(List<ReasonerStatementPattern> patternList) {
        List<Statement> filteredReasonerStatements = this.reasoner.filterResults(patternList);
        this.addNewInferences(filteredReasonerStatements);
        this.removeOldInferences(this.filterInferencesModel(patternList), filteredReasonerStatements);
        log.debug((Object)("Added: " + this.addCount + ", Retracted: " + this.retractCount));
    }

    private void addNewInferences(List<Statement> filteredReasonerModel) {
        for (Statement stmt : filteredReasonerModel) {
            if (this.fullModelContainsStatement(stmt)) continue;
            LockedModel inferenceModel = this.lockableInferencesModel.write();
            Throwable throwable = null;
            try {
                ConfiguredReasonerListener.Suspension susp = this.listener.suspend();
                Throwable throwable2 = null;
                try {
                    inferenceModel.add(stmt);
                    ++this.addCount;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (susp == null) continue;
                    InferenceModelUpdater.$closeResource(throwable2, susp);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (inferenceModel == null) continue;
                InferenceModelUpdater.$closeResource(throwable, inferenceModel);
            }
        }
    }

    private boolean fullModelContainsStatement(Statement stmt) {
        try (LockedOntModel fullModel = this.lockableFullModel.read();){
            boolean bl = fullModel.contains(stmt);
            return bl;
        }
    }

    private Model filterInferencesModel(List<ReasonerStatementPattern> patternList) {
        Model filtered = ModelFactory.createDefaultModel();
        try (LockedModel inferencesModel = this.lockableInferencesModel.read();){
            for (ReasonerStatementPattern pattern : patternList) {
                filtered.add(pattern.matchStatementsFromModel(inferencesModel));
            }
        }
        log.debug((Object)("Filtered inferences model: " + filtered.size()));
        return filtered;
    }

    private void removeOldInferences(Model filteredInferencesModel, List<Statement> filteredReasonerStatements) {
        Model filteredReasonerModel = ModelFactory.createDefaultModel();
        filteredReasonerModel.add(filteredReasonerStatements);
        for (Statement stmt : filteredInferencesModel.listStatements().toList()) {
            if (filteredReasonerModel.contains(stmt)) continue;
            LockedModel inferenceModel = this.lockableInferencesModel.write();
            Throwable throwable = null;
            try {
                ConfiguredReasonerListener.Suspension susp = this.listener.suspend();
                Throwable throwable2 = null;
                try {
                    ++this.retractCount;
                    inferenceModel.remove(stmt);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (susp == null) continue;
                    InferenceModelUpdater.$closeResource(throwable2, susp);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (inferenceModel == null) continue;
                InferenceModelUpdater.$closeResource(throwable, inferenceModel);
            }
        }
    }
}

