/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import java.util.Objects;
import java.util.regex.Pattern;

public class QueryHolder {
    private final String queryString;

    public QueryHolder(String queryString) {
        this.queryString = Objects.requireNonNull(queryString);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean hasVariable(String name) {
        String regex = "\\?" + name + "\\b";
        return Pattern.compile(regex).matcher(this.queryString).find();
    }

    public QueryHolder bindToUri(String name, String uri) {
        String regex = "\\?" + name + "\\b";
        String replacement = "<" + uri + ">";
        String bound = this.replaceWithinBraces(regex, replacement);
        return new QueryHolder(bound);
    }

    public QueryHolder bindToPlainLiteral(String name, String value) {
        String regex = "\\?" + name + "\\b";
        String replacement = '\"' + value + '\"';
        String bound = this.replaceWithinBraces(regex, replacement);
        return new QueryHolder(bound);
    }

    private String replaceWithinBraces(String regex, String replacement) {
        int openBrace = this.queryString.indexOf(123);
        int closeBrace = this.queryString.lastIndexOf(125);
        if (openBrace == -1 || closeBrace == -1) {
            return this.queryString;
        }
        String prefix = this.queryString.substring(0, openBrace);
        String suffix = this.queryString.substring(closeBrace);
        String patterns = this.queryString.substring(openBrace, closeBrace);
        return prefix + patterns.replaceAll(regex, replacement) + suffix;
    }

    public int hashCode() {
        return this.queryString.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryHolder that = (QueryHolder)obj;
        return Objects.equals(this.queryString, that.queryString);
    }

    public String toString() {
        return "QueryHolder[" + this.queryString + "]";
    }
}

