/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyStatementTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UncollatedObjectPropertyTemplateModel
extends ObjectPropertyTemplateModel {
    private static final Log log = LogFactory.getLog(UncollatedObjectPropertyTemplateModel.class);
    private final List<ObjectPropertyStatementTemplateModel> statements = new ArrayList<ObjectPropertyStatementTemplateModel>();

    UncollatedObjectPropertyTemplateModel(ObjectProperty op, Individual subject, VitroRequest vreq, boolean editing, List<ObjectProperty> populatedObjectPropertyList) throws InvalidConfigurationException {
        super(op, subject, vreq, editing);
        if (populatedObjectPropertyList.contains(op)) {
            log.debug((Object)("Getting data for populated object property " + op.getURI()));
            List<Map<String, String>> statementData = this.getStatementData();
            this.postprocess(statementData);
            String objectKey = this.getObjectKey();
            for (Map<String, String> map : statementData) {
                this.statements.add(new ObjectPropertyStatementTemplateModel(this.subjectUri, op, objectKey, map, this.getTemplateName(), vreq));
            }
            this.postprocessStatementList(this.statements);
        } else {
            log.debug((Object)("Object property " + this.getUri() + " is unpopulated."));
        }
    }

    @Override
    protected boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public List<ObjectPropertyStatementTemplateModel> getStatements() {
        return this.statements;
    }

    @Override
    public boolean isCollatedBySubclass() {
        return false;
    }

    public ObjectPropertyStatementTemplateModel first() {
        return this.statements == null || this.statements.isEmpty() ? null : this.statements.get(0);
    }
}

