/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.vitro.opensocial;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.ucsf.vitro.opensocial.GadgetSpec;
import edu.ucsf.vitro.opensocial.OpenSocialManager;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="GadgetController", urlPatterns={"/orng/*"})
public class GadgetController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GadgetController.class);

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        if ("/clearcache".equalsIgnoreCase(vreq.getPathInfo())) {
            OpenSocialManager.clearCache();
            return new RedirectResponseValues("/");
        }
        if ("/sandbox".equalsIgnoreCase(vreq.getPathInfo())) {
            boolean sandbox = "True".equalsIgnoreCase(ConfigurationProperties.getBean(vreq.getSession().getServletContext()).getProperty("OpenSocial.sandbox"));
            if (!sandbox) {
                return new ExceptionResponseValues(new Exception("Sandbox not available"));
            }
            return this.processGadgetSandbox(vreq);
        }
        return this.processGadgetDetails(vreq);
    }

    protected ResponseValues processGadgetDetails(VitroRequest vreq) {
        try {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("title", "Gadget Details");
            try {
                OpenSocialManager openSocialManager = new OpenSocialManager(vreq, "gadgetDetails");
                body.put("openSocial", openSocialManager);
                if (openSocialManager.isVisible()) {
                    body.put("bodyOnload", "my.init();");
                }
            }
            catch (IOException e) {
                log.error((Object)"IOException in doTemplate()", (Throwable)e);
            }
            catch (SQLException e) {
                log.error((Object)"SQLException in doTemplate()", (Throwable)e);
            }
            return new TemplateResponseValues("gadgetDetails.ftl", body);
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            return new ExceptionResponseValues(e);
        }
    }

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        return "Gadget Details";
    }

    protected ResponseValues processGadgetSandbox(VitroRequest vreq) {
        if ("POST".equalsIgnoreCase(vreq.getMethod())) {
            vreq.getSession().setAttribute("OPENSOCIAL_GADGETS", (Object)vreq.getParameter("gadgetURLS"));
            vreq.getSession().setAttribute("OPENSOCIAL_DEBUG", (Object)(vreq.getParameter("debug") != null ? 1 : 0));
            vreq.getSession().setAttribute("OPENSOCIAL_NOCACHE", (Object)(vreq.getParameter("useCache") == null ? 1 : 0));
            return new RedirectResponseValues("/");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", "Gadget Sandbox");
        try {
            OpenSocialManager openSocialManager = new OpenSocialManager(vreq, "gadgetSandbox");
            StringBuilder gadgetURLS = new StringBuilder();
            for (GadgetSpec gadget : openSocialManager.getAllDBGadgets(false).values()) {
                gadgetURLS.append(gadget.getGadgetURL()).append(System.getProperty("line.separator"));
            }
            body.put("gadgetURLS", gadgetURLS.toString());
            body.put("openSocial", openSocialManager);
        }
        catch (IOException e) {
            log.error((Object)"IOException in doTemplate()", (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"SQLException in doTemplate()", (Throwable)e);
        }
        return new TemplateResponseValues("gadgetLogin.ftl", body);
    }
}

