/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.linkeddatafragments.servlet;

import com.fasterxml.jackson.databind.JsonNode;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.riot.Lang;
import org.linkeddatafragments.config.ConfigReader;
import org.linkeddatafragments.datasource.DataSourceFactory;
import org.linkeddatafragments.datasource.DataSourceTypesRegistry;
import org.linkeddatafragments.datasource.IDataSource;
import org.linkeddatafragments.datasource.IDataSourceType;
import org.linkeddatafragments.datasource.index.IndexDataSource;
import org.linkeddatafragments.exceptions.DataSourceNotFoundException;
import org.linkeddatafragments.fragments.FragmentRequestParserBase;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.fragments.ILinkedDataFragmentRequest;
import org.linkeddatafragments.util.MIMEParse;
import org.linkeddatafragments.views.ILinkedDataFragmentWriter;
import org.vivoweb.linkeddatafragments.datasource.rdfservice.RDFServiceBasedRequestProcessorForTPFs;
import org.vivoweb.linkeddatafragments.datasource.rdfservice.RDFServiceDataSourceType;
import org.vivoweb.linkeddatafragments.views.HtmlTriplePatternFragmentWriterImpl;
import org.vivoweb.linkeddatafragments.views.LinkedDataFragmentWriterFactory;

@WebServlet(name="TpfServlet", urlPatterns={"/tpf/*"})
public class VitroLinkedDataFragmentServlet
extends VitroHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_TPF_ACTIVE_FLAG = "tpf.activeFlag";
    private ConfigReader config;
    private final HashMap<String, IDataSource> dataSources = new HashMap();
    private final Collection<String> mimeTypes = new ArrayList<String>();
    private ConfigurationProperties configProps;
    private String tpfActiveFlag;

    private File getConfigFile(ServletConfig config) throws IOException {
        File cfg;
        String path = config.getServletContext().getRealPath("/");
        if (path == null) {
            path = System.getProperty("user.dir");
        }
        if (!(cfg = new File(path, "config-example.json")).exists()) {
            throw new IOException("Configuration file " + cfg + " not found.");
        }
        if (!cfg.isFile()) {
            throw new IOException("Configuration file " + cfg + " is not a file.");
        }
        return cfg;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            ServletContext ctx = servletConfig.getServletContext();
            this.configProps = ConfigurationProperties.getBean(ctx);
            if (!this.configurationPresent()) {
                throw new ServletException("TPF is currently disabled. To enable, add 'tpfActive.flag=true' to the runtime.properties.");
            }
            if (!this.tpfActiveFlag.equalsIgnoreCase("true")) {
                throw new ServletException("TPF is currently disabled. To enable, set 'tpfActive.flag=true' in runtime.properties.");
            }
            RDFService rdfService = ModelAccess.on(ctx).getRDFService();
            RDFServiceBasedRequestProcessorForTPFs.setRDFService(rdfService);
            OntologyDao dao = ModelAccess.on(ctx).getWebappDaoFactory().getOntologyDao();
            this.config = new ConfigReader(new StringReader(this.getConfigJson(dao)));
            for (Map.Entry<String, IDataSourceType> entry : this.config.getDataSourceTypes().entrySet()) {
                if (DataSourceTypesRegistry.isRegistered(entry.getKey())) continue;
                DataSourceTypesRegistry.register(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, IDataSourceType> entry : this.config.getDataSources().entrySet()) {
                this.dataSources.put(entry.getKey(), DataSourceFactory.create((JsonNode)entry.getValue()));
            }
            MIMEParse.register("text/html");
            MIMEParse.register(Lang.TTL.getHeaderString());
            MIMEParse.register(Lang.JSONLD.getHeaderString());
            MIMEParse.register(Lang.NTRIPLES.getHeaderString());
            MIMEParse.register(Lang.RDFXML.getHeaderString());
            HtmlTriplePatternFragmentWriterImpl.setContextPath(servletConfig.getServletContext().getContextPath());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        for (IDataSource dataSource : this.dataSources.values()) {
            try {
                dataSource.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean configurationPresent() {
        String activeFlag = this.configProps.getProperty(PROPERTY_TPF_ACTIVE_FLAG);
        if (StringUtils.isNotEmpty((CharSequence)activeFlag)) {
            this.tpfActiveFlag = activeFlag;
            return true;
        }
        return false;
    }

    private IDataSource getDataSource(HttpServletRequest request) throws DataSourceNotFoundException {
        String path;
        String contextPath = request.getContextPath();
        String requestURI = request.getRequestURI();
        String string = path = contextPath == null ? requestURI : requestURI.substring(contextPath.length());
        if (path.startsWith("/tpf")) {
            path = path.substring(4);
        }
        if (path.equals("/") || path.isEmpty()) {
            String baseURL = FragmentRequestParserBase.extractBaseURL(request, this.config);
            return new IndexDataSource(baseURL, this.dataSources);
        }
        String dataSourceName = path.substring(1);
        IDataSource dataSource = this.dataSources.get(dataSourceName);
        if (dataSource == null) {
            throw new DataSourceNotFoundException(dataSourceName);
        }
        return dataSource;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        int fileNamePos = request.getRequestURI().toLowerCase().lastIndexOf("tpf/assets/");
        if (fileNamePos > 0) {
            try {
                String fileName = request.getRequestURI().substring(fileNamePos + 11);
                InputStream in = VitroLinkedDataFragmentServlet.class.getResourceAsStream(fileName);
                if (in != null) {
                    IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
                }
                return;
            }
            catch (IOException fileName) {
                // empty catch block
            }
        }
        Closeable fragment = null;
        try {
            String bestMatch = MIMEParse.bestMatch(request.getHeader("Accept"));
            response.setHeader("Server", "Linked Data Fragments Server");
            response.setContentType(bestMatch);
            response.setCharacterEncoding("utf-8");
            ILinkedDataFragmentWriter writer = LinkedDataFragmentWriterFactory.create(this.config.getPrefixes(), this.dataSources, bestMatch);
            try {
                IDataSource dataSource = this.getDataSource(request);
                ILinkedDataFragmentRequest ldfRequest = dataSource.getRequestParser().parseIntoFragmentRequest(request, this.config);
                fragment = dataSource.getRequestProcessor().createRequestedFragment(ldfRequest);
                response.setHeader("Access-Control-Allow-Origin", "*");
                writer.writeFragment(response.getOutputStream(), dataSource, (ILinkedDataFragment)fragment, ldfRequest);
            }
            catch (DataSourceNotFoundException ex) {
                try {
                    response.setStatus(404);
                    writer.writeNotFound(response.getOutputStream(), request);
                }
                catch (Exception ex1) {
                    throw new ServletException((Throwable)ex1);
                }
            }
            catch (Exception e) {
                response.setStatus(500);
                writer.writeError(response.getOutputStream(), e);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (fragment != null) {
                try {
                    fragment.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getConfigJson(OntologyDao dao) {
        StringBuilder configJson = new StringBuilder();
        configJson.append("{\n");
        configJson.append("  \"title\": \"Linked Data Fragments server\",\n");
        configJson.append("\n");
        configJson.append("  \"datasourcetypes\": {\n");
        configJson.append("    \"RDFServiceDatasource\": \"").append(RDFServiceDataSourceType.class.getCanonicalName()).append("\"\n");
        configJson.append("  },\n");
        configJson.append("\n");
        configJson.append("  \"datasources\": {\n");
        configJson.append("    \"core\": {\n");
        configJson.append("      \"title\": \"core\",\n");
        configJson.append("      \"type\": \"RDFServiceDatasource\",\n");
        configJson.append("      \"description\": \"All data\"\n");
        configJson.append("    }\n");
        configJson.append("  },\n");
        configJson.append("\n");
        configJson.append("  \"prefixes\": {\n");
        configJson.append("    \"rdf\":         \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\",\n");
        configJson.append("    \"rdfs\":        \"http://www.w3.org/2000/01/rdf-schema#\",\n");
        configJson.append("    \"hydra\": \"http://www.w3.org/ns/hydra/core#\",\n");
        configJson.append("    \"void\":        \"http://rdfs.org/ns/void#\"");
        List<Ontology> onts = dao.getAllOntologies();
        if (onts != null) {
            block9: for (Ontology ont : onts) {
                if (ont == null || ont.getPrefix() == null) continue;
                switch (ont.getPrefix()) {
                    case "rdf": 
                    case "rdfs": 
                    case "hydra": 
                    case "void": {
                        continue block9;
                    }
                }
                configJson.append(",\n");
                configJson.append("    \"");
                configJson.append(ont.getPrefix());
                configJson.append("\":         \"");
                configJson.append(ont.getURI());
                configJson.append("\"");
            }
        }
        configJson.append("  }\n");
        configJson.append("}\n");
        return configJson.toString();
    }
}

