/* $This file is distributed under the terms of the license in LICENSE$ */

package edu.cornell.mannlib.vitro.webapp.web.jsptags;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.JspException;

/**
 * User: bdc34
 * Date: Jan 22, 2008
 * Time: 2:15:16 PM
 */
public class JsonSet extends BodyTagSupport {

    private String var = null;

    public String getVar() {
        return var;
    }
    public void setVar(String var) {
        this.var = var;
    }

    public int doEndTag() throws JspException {
        String escaped = escape( getBodyContent().getString() );
        pageContext.getRequest().setAttribute(getVar(),escaped);
        return super.doEndTag();
    }

    /**
        This isfrom org.json.simple.JSONObject
     */
	private String escape(String s){
		if(s==null)
			return null;
		StringBuilder sb=new StringBuilder();
		for(int i=0;i<s.length();i++){
			char ch=s.charAt(i);
			switch(ch){
			case '"':
				sb.append("\\\"");
				break;
			case '\\':
				sb.append("\\\\");
				break;
			case '\b':
				sb.append("\\b");
				break;
			case '\f':
				sb.append("\\f");
				break;
			case '\n':
				sb.append("\\n");
				break;
			case '\r':
				sb.append("\\r");
				break;
			case '\t':
				sb.append("\\t");
				break;
			case '/':
				sb.append("\\/");
				break;
			default:
				if(ch>='\u0000' && ch<='\u001F'){
					String ss=Integer.toHexString(ch);
					sb.append("\\u");
					for(int k=0;k<4-ss.length();k++){
						sb.append('0');
					}
					sb.append(ss.toUpperCase());
				}
				else{
					sb.append(ch);
				}
			}
		}//for
		return sb.toString();
	}
}
