/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class PolicyHelper_AuthorizationRequestTest {
    private ServletContextStub ctx;
    private HttpServletRequestStub req;
    private AuthorizationRequest nullAr = null;

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
        HttpSessionStub session = new HttpSessionStub();
        session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(session);
    }

    private void createPolicy(RequestedAction ... authorizedActions) {
        ServletPolicyList.addPolicy((ServletContext)this.ctx, (PolicyIface)new MySimplePolicy(authorizedActions));
    }

    @Test
    public void authorizedForActionsNull() {
        this.createPolicy(new RequestedAction[0]);
        Assert.assertTrue((String)"null actions", (boolean)PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.req, (AuthorizationRequest[])new AuthorizationRequest[]{this.nullAr}));
    }

    @Test
    public void authorizedForActionsEmpty() {
        this.createPolicy(new RequestedAction[0]);
        Assert.assertTrue((String)"empty actions", (boolean)PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.req, (AuthorizationRequest[])new AuthorizationRequest[0]));
    }

    @Test
    public void authorizedForActionsAndPass() {
        this.createPolicy(new Action1(), new Action2());
        Assert.assertTrue((String)"and pass", (boolean)PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.req, (AuthorizationRequest[])new AuthorizationRequest[]{new Action1(), new Action2()}));
    }

    @Test
    public void authorizedForActionsAndFail() {
        this.createPolicy(new Action2());
        Assert.assertFalse((String)"and fail", (boolean)PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.req, (AuthorizationRequest[])new AuthorizationRequest[]{new Action1(), new Action2()}));
    }

    @Test
    public void authorizedForActionsAndOrPass() {
        this.createPolicy(new Action3());
        Assert.assertTrue((String)"and-or pass", (boolean)PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.req, (AuthorizationRequest[])new AuthorizationRequest[]{new Action1().and((AuthorizationRequest)new Action2()).or((AuthorizationRequest)new Action3())}));
    }

    @Test
    public void authorizedForActionsAndOrFail() {
        this.createPolicy(new Action1());
        Assert.assertFalse((String)"and-or fail", (boolean)PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.req, (AuthorizationRequest[])new AuthorizationRequest[]{new Action1().and((AuthorizationRequest)new Action2()).or((AuthorizationRequest)new Action3())}));
    }

    @Test
    public void authorizedByACombinationOfPolicies() {
        ServletPolicyList.addPolicy((ServletContext)this.ctx, (PolicyIface)new MySimplePolicy(new Action1()));
        ServletPolicyList.addPolicy((ServletContext)this.ctx, (PolicyIface)new MySimplePolicy(new Action2()));
        Assert.assertTrue((String)"combination of policies", (boolean)PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.req, (AuthorizationRequest[])new AuthorizationRequest[]{new Action2(), new Action1()}));
    }

    private static class MySimplePolicy
    implements PolicyIface {
        private final Set<RequestedAction> authorizedActions;

        public MySimplePolicy(RequestedAction ... authorizedActions) {
            this.authorizedActions = new HashSet<RequestedAction>(Arrays.asList(authorizedActions));
        }

        public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
            for (RequestedAction authorized : this.authorizedActions) {
                if (!authorized.getClass().equals(whatToAuth.getClass())) continue;
                return new BasicPolicyDecision(Authorization.AUTHORIZED, "matched " + authorized.getClass().getSimpleName());
            }
            return new BasicPolicyDecision(Authorization.INCONCLUSIVE, "nope");
        }
    }

    public static class Action3
    extends RequestedAction {
    }

    public static class Action2
    extends RequestedAction {
    }

    public static class Action1
    extends RequestedAction {
    }
}

