/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class OntModelSegementationTest
extends AbstractTestClass {
    private WebappDaoFactoryJena wadf;

    @Before
    public void setUpWebappDaoFactoryJena() {
        super.setUp();
        this.wadf = new WebappDaoFactoryJena((OntModelSelector)new SimpleOntModelSelector());
    }

    @Test
    public void testUserAccountModel() {
        UserAccountsDao uadao = this.wadf.getUserAccountsDao();
        OntModelSelector oms = this.wadf.getOntModelSelector();
        UserAccount user = new UserAccount();
        user.setFirstName("Chuck");
        user.setLastName("Roast");
        user.setExternalAuthId("chuckroast");
        uadao.insertUserAccount(user);
        Assert.assertTrue((oms.getUserAccountsModel().size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getFullModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getABoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getTBoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getApplicationMetadataModel().size() == 0L ? 1 : 0) != 0);
        user.setEmailAddress("todd@somewhere");
        uadao.updateUserAccount(user);
        Assert.assertTrue((oms.getUserAccountsModel().size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getFullModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getABoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getTBoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getApplicationMetadataModel().size() == 0L ? 1 : 0) != 0);
        uadao.deleteUserAccount(user.getUri());
        Assert.assertTrue((oms.getUserAccountsModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getFullModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getABoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getTBoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getApplicationMetadataModel().size() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTBoxModel() throws InsertException {
        OntModelSelector oms = this.wadf.getOntModelSelector();
        VClassDao vcDao = this.wadf.getVClassDao();
        ObjectPropertyDao opDao = this.wadf.getObjectPropertyDao();
        DataPropertyDao dpDao = this.wadf.getDataPropertyDao();
        OntologyDao oDao = this.wadf.getOntologyDao();
        VClass vclass = new VClass();
        vclass.setURI("http://example.org/vclass");
        vcDao.insertNewVClass(vclass);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        ObjectProperty op = new ObjectProperty();
        op.setURI("http://example.org/objectProperty");
        opDao.insertObjectProperty(op);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        DataProperty dp = new DataProperty();
        dp.setURI("http://example.org/dataProperty");
        dpDao.insertDataProperty(dp);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        Ontology o = new Ontology();
        o.setURI("http://example.org/");
        oDao.insertNewOntology(o);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        vclass.setName("vclass");
        op.setDomainPublic("objectProperty");
        dp.setPublicName("dataProperty");
        o.setName("ontology");
        vcDao.updateVClass(vclass);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        opDao.updateObjectProperty(op);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        dpDao.updateDataProperty(dp);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        oDao.updateOntology(o);
        this.assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        vcDao.deleteVClass(vclass);
        opDao.deleteObjectProperty(op);
        dpDao.deleteDataProperty(dp);
        oDao.deleteOntology(o);
        this.assertAllModelsExceptAppMetadataAreEmpty(oms);
    }

    @Test
    public void testAboxModel() throws InsertException {
        OntModelSelector oms = this.wadf.getOntModelSelector();
        IndividualDao iDao = this.wadf.getIndividualDao();
        IndividualImpl ind = new IndividualImpl("http://example.org/individual");
        iDao.insertNewIndividual((Individual)ind);
        this.assertABoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        ind.setName("ind");
        iDao.updateIndividual((Individual)ind);
        this.assertABoxModelNonemptyAndAllOtherModelsAreEmpty(oms);
        iDao.deleteIndividual((Individual)ind);
        this.assertAllModelsExceptAppMetadataAreEmpty(oms);
    }

    private void assertAllModelsExceptAppMetadataAreEmpty(OntModelSelector oms) {
        Assert.assertTrue((oms.getFullModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getABoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getTBoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getUserAccountsModel().size() == 0L ? 1 : 0) != 0);
    }

    private void assertTBoxModelNonemptyAndAllOtherModelsAreEmpty(OntModelSelector oms) {
        Assert.assertTrue((oms.getTBoxModel().size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getFullModel().size() == oms.getTBoxModel().size() ? 1 : 0) != 0);
        Assert.assertTrue((oms.getABoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getApplicationMetadataModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getUserAccountsModel().size() == 0L ? 1 : 0) != 0);
    }

    private void assertABoxModelNonemptyAndAllOtherModelsAreEmpty(OntModelSelector oms) {
        Assert.assertTrue((oms.getABoxModel().size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getFullModel().size() == oms.getABoxModel().size() ? 1 : 0) != 0);
        Assert.assertTrue((oms.getTBoxModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getApplicationMetadataModel().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((oms.getUserAccountsModel().size() == 0L ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testConcurrency() throws InsertException {
        int i;
        new Thread(new ClassLister((WebappDaoFactory)this.wadf)).start();
        new Thread(new ClassLister((WebappDaoFactory)this.wadf)).start();
        VClass v = null;
        for (i = 0; i < 50; ++i) {
            v = new VClass();
            v.setURI("http://example.org/vclass" + i);
            this.wadf.getVClassDao().insertNewVClass(v);
        }
        for (i = 0; i < 500; ++i) {
            v.setName("blah " + i);
            this.wadf.getVClassDao().updateVClass(v);
        }
    }

    private class ClassLister
    implements Runnable {
        private WebappDaoFactory wadf;

        public ClassLister(WebappDaoFactory wadf) {
            this.wadf = wadf;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1500; ++i) {
                this.wadf.getVClassDao().getAllVclasses().size();
            }
        }
    }
}

