/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.junit.Assert;
import org.junit.Test;

public class VClassDaoTest
extends AbstractTestClass {
    @Test
    public void modelIsolation() {
        String class1URI = "http://test.vivo/AcademicDegree";
        OntModel superModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel subModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        superModel.addSubModel((Model)subModel);
        String rdfsLabel = "this is the rdfs label";
        String lang = "en-US";
        OntClass class1 = subModel.createClass(class1URI);
        class1.setLabel(rdfsLabel, lang);
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup"), (RDFNode)subModel.createResource("http://thisIsTheClassGroupURI"));
        class1.setPropertyValue(subModel.createProperty("http://purl.obolibrary.org/obo/IAO_0000115"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the short definition", (String)lang));
        class1.setPropertyValue(subModel.createProperty("http://purl.obolibrary.org/obo/IAO_0000112"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the example - why is this a string?", (String)lang));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#descriptionAnnot"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the description", (String)lang));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayLimitAnnot"), (RDFNode)subModel.createTypedLiteral(-1));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayRankAnnot"), (RDFNode)subModel.createTypedLiteral(-11));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#searchBoostAnnot"), (RDFNode)subModel.createTypedLiteral(2.4f));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromDisplayBelowRoleLevelAnnot"), (RDFNode)subModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#curator"));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#prohibitedFromUpdateBelowRoleLevelAnnot"), (RDFNode)subModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#selfEditor"));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromPublishBelowRoleLevelAnnot"), (RDFNode)subModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#editor"));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customEntryFormAnnot"), (RDFNode)subModel.createTypedLiteral("this is the custom entry form annotation"));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customDisplayViewAnnot"), (RDFNode)subModel.createTypedLiteral("this is the custom display view annotation"));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customShortViewAnnot"), (RDFNode)subModel.createTypedLiteral("this is the custom short view annotation"));
        class1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customSearchViewAnnot"), (RDFNode)subModel.createTypedLiteral("this is the custom search view annotation"));
        superModel.removeSubModel((Model)subModel);
        OntModel origSubModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        origSubModel.add((Model)subModel);
        OntModel origSuperModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        origSuperModel.add((Model)superModel);
        superModel.addSubModel((Model)subModel);
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(superModel);
        VClassDaoJena vcdj = (VClassDaoJena)wdfj.getVClassDao();
        VClass vClass = vcdj.getVClassByURI(class1URI);
        Assert.assertEquals((Object)vClass.getName(), (Object)class1.getLabel(lang));
        vcdj.updateVClass(vClass);
        superModel.removeSubModel((Model)subModel);
        this.wipeOutModTime((Model)origSubModel);
        this.wipeOutModTime((Model)origSuperModel);
        this.wipeOutModTime((Model)subModel);
        this.wipeOutModTime((Model)superModel);
        Assert.assertTrue((boolean)subModel.isIsomorphicWith((Model)origSubModel));
        Assert.assertTrue((boolean)superModel.isIsomorphicWith((Model)origSuperModel));
    }

    void printModels(OntModel superModel, OntModel subModel) {
        superModel.removeSubModel((Model)subModel);
        System.out.println("\nThe sub-model has " + subModel.size() + " statements:");
        System.out.println("---------------------------------------------------");
        subModel.writeAll((OutputStream)System.out, "N3", null);
        System.out.println("\nThe super-model has " + superModel.size() + " statements:");
        System.out.println("---------------------------------------------------");
        superModel.write((OutputStream)System.out, "N3", null);
        superModel.addSubModel((Model)subModel);
    }

    void wipeOutModTime(Model model) {
        model.removeAll(null, model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#modTime"), null);
    }

    @Test
    public void getVClassesForPropertyTest() {
        String lang = "en-US";
        String superClassURI = "http://example.com/SUPER_class";
        String subClassAURI = "http://example.com/SUB_class_A";
        String subClassBURI = "http://example.com/SUB_class_B";
        String propURI = "http://example.com/PROP";
        String propNoRangeURI = "http://example.com/PROP_NO_RANGE";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass superClass = model.createClass(superClassURI);
        superClass.addLabel("SUPER", lang);
        superClass.setPropertyValue(model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup"), (RDFNode)model.createResource("http://thisIsTheClassGroupURI"));
        superClass.addSuperClass(OWL.Thing);
        OntClass subA = model.createClass(subClassAURI);
        subA.addLabel("subA", lang);
        subA.setPropertyValue(model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup"), (RDFNode)model.createResource("http://thisIsTheClassGroupURI"));
        superClass.addSubClass((Resource)subA);
        OntClass subB = model.createClass(subClassBURI);
        subB.addLabel("subB", lang);
        subB.setPropertyValue(model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup"), (RDFNode)model.createResource("http://thisIsTheClassGroupURI"));
        superClass.addSubClass((Resource)subB);
        ObjectProperty prop = model.createObjectProperty(propURI);
        prop.setLabel("PROP", lang);
        prop.setRange((Resource)superClass);
        ObjectProperty propNoRange = model.createObjectProperty(propNoRangeURI);
        propNoRange.setLabel("PROP_NO_RANGE", lang);
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(model);
        List classesForProp = wdfj.getVClassDao().getVClassesForProperty(propURI, true);
        Assert.assertNotNull((Object)classesForProp);
        Assert.assertEquals((long)3L, (long)classesForProp.size());
        List classesForPropNoRange = wdfj.getVClassDao().getVClassesForProperty(propNoRangeURI, true);
        Assert.assertNotNull((Object)classesForPropNoRange);
        Assert.assertEquals((long)0L, (long)classesForPropNoRange.size());
    }
}

