/*
 * Decompiled with CFR 0.152.
 */
package stubs.javax.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class HttpServletResponseStub
implements HttpServletResponse {
    private String redirectLocation;
    private int status = 200;
    private String errorMessage;
    private Map<String, String> headers = new HashMap<String, String>();
    private String contentType;
    private String charset = "";
    private ByteArrayOutputStream outputStream;
    private StringWriter outputWriter;

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getOutput() {
        if (this.outputStream != null) {
            return this.outputStream.toString();
        }
        if (this.outputWriter != null) {
            return this.outputWriter.toString();
        }
        return "";
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String s) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    public void sendRedirect(String location) throws IOException {
        this.redirectLocation = location;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void sendError(int status) throws IOException {
        this.status = status;
    }

    public void sendError(int status, String message) throws IOException {
        this.status = status;
        this.errorMessage = message;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("Can't get a Writer after getting an OutputStream.");
        }
        if (this.outputWriter == null) {
            this.outputWriter = new StringWriter();
        }
        return new PrintWriter((Writer)this.outputWriter, true);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputWriter != null) {
            throw new IllegalStateException("Can't get an OutputStream after getting a Writer.");
        }
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return new ServletOutputStream(){

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int thisChar) throws IOException {
                HttpServletResponseStub.this.outputStream.write(thisChar);
            }
        };
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        Pattern p = Pattern.compile(";\\scharset=([^;]+)");
        Matcher m = p.matcher(contentType);
        if (m.find()) {
            this.charset = m.group(1);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public void flushBuffer() throws IOException {
        throw new RuntimeException("HttpServletResponseStub.flushBuffer() not implemented.");
    }

    public int getBufferSize() {
        throw new RuntimeException("HttpServletResponseStub.getBufferSize() not implemented.");
    }

    public Locale getLocale() {
        throw new RuntimeException("HttpServletResponseStub.getLocale() not implemented.");
    }

    public boolean isCommitted() {
        throw new RuntimeException("HttpServletResponseStub.isCommitted() not implemented.");
    }

    public void reset() {
        throw new RuntimeException("HttpServletResponseStub.reset() not implemented.");
    }

    public void resetBuffer() {
        throw new RuntimeException("HttpServletResponseStub.resetBuffer() not implemented.");
    }

    public void setBufferSize(int arg0) {
        throw new RuntimeException("HttpServletResponseStub.setBufferSize() not implemented.");
    }

    public void setContentLength(int arg0) {
        throw new RuntimeException("HttpServletResponseStub.setContentLength() not implemented.");
    }

    public void setContentLengthLong(long l) {
    }

    public void setLocale(Locale arg0) {
        throw new RuntimeException("HttpServletResponseStub.setLocale() not implemented.");
    }

    public void addCookie(Cookie arg0) {
        throw new RuntimeException("HttpServletResponseStub.addCookie() not implemented.");
    }

    public void addDateHeader(String arg0, long arg1) {
        throw new RuntimeException("HttpServletResponseStub.addDateHeader() not implemented.");
    }

    public void addHeader(String arg0, String arg1) {
        throw new RuntimeException("HttpServletResponseStub.addHeader() not implemented.");
    }

    public void addIntHeader(String arg0, int arg1) {
        throw new RuntimeException("HttpServletResponseStub.addIntHeader() not implemented.");
    }

    public String encodeRedirectURL(String arg0) {
        throw new RuntimeException("HttpServletResponseStub.encodeRedirectURL() not implemented.");
    }

    public String encodeRedirectUrl(String arg0) {
        throw new RuntimeException("HttpServletResponseStub.encodeRedirectUrl() not implemented.");
    }

    public String encodeURL(String arg0) {
        throw new RuntimeException("HttpServletResponseStub.encodeURL() not implemented.");
    }

    public String encodeUrl(String arg0) {
        throw new RuntimeException("HttpServletResponseStub.encodeUrl() not implemented.");
    }

    public void setDateHeader(String arg0, long arg1) {
        throw new RuntimeException("HttpServletResponseStub.setDateHeader() not implemented.");
    }

    public void setIntHeader(String arg0, int arg1) {
        throw new RuntimeException("HttpServletResponseStub.setIntHeader() not implemented.");
    }

    public void setStatus(int arg0, String arg1) {
        throw new RuntimeException("HttpServletResponseStub.setStatus() not implemented.");
    }
}

