/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import javax.servlet.ServletContext;

public abstract class BaseSelfEditingPolicy {
    protected final ServletContext ctx;
    protected final BaseResourceBean.RoleLevel roleLevel;

    public BaseSelfEditingPolicy(ServletContext ctx, BaseResourceBean.RoleLevel roleLevel) {
        this.ctx = ctx;
        this.roleLevel = roleLevel;
    }

    protected boolean canModifyResource(String uri) {
        return PropertyRestrictionBean.getBean().canModifyResource(uri, this.roleLevel);
    }

    protected boolean canModifyPredicate(Property predicate) {
        return PropertyRestrictionBean.getBean().canModifyPredicate(predicate, this.roleLevel);
    }

    protected PolicyDecision cantModifyResource(String uri) {
        return this.inconclusiveDecision("No access to admin resources; cannot modify " + uri);
    }

    protected PolicyDecision cantModifyPredicate(Property predicate) {
        return this.inconclusiveDecision("No access to admin predicates; cannot modify " + predicate.getURI());
    }

    protected PolicyDecision userNotAuthorizedToStatement() {
        return this.inconclusiveDecision("User has no access to this statement.");
    }

    protected PolicyDecision inconclusiveDecision(String message) {
        return new BasicPolicyDecision(Authorization.INCONCLUSIVE, this.getClass().getSimpleName() + ": " + message);
    }

    protected PolicyDecision authorizedDecision(String message) {
        return new BasicPolicyDecision(Authorization.AUTHORIZED, this.getClass().getSimpleName() + ": " + message);
    }
}

