/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    private static final Log log = LogFactory.getLog(MultipartRequestWrapper.class);
    private static final String CLASS_NAME = MultipartRequestWrapper.class.getSimpleName();
    public static final String ATTRIBUTE_IS_MULTIPART = CLASS_NAME + "_isMultipart";
    public static final String ATTRIBUTE_FILE_ITEM_MAP = CLASS_NAME + "_fileItemMap";
    public static final String ATTRIBUTE_FILE_SIZE_EXCEPTION = CLASS_NAME + "_fileSizeException";
    private static final String[] EMPTY_ARRAY = new String[0];
    private final ListsMap<String> parameters;

    public static HttpServletRequest parse(HttpServletRequest req, ParsingStrategy strategy) throws IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            return req;
        }
        ListsMap<String> parameters = new ListsMap<String>();
        ListsMap<FileItem> files = new ListsMap<FileItem>();
        MultipartRequestWrapper.parseQueryString(req.getQueryString(), parameters);
        MultipartRequestWrapper.parseFileParts(req, parameters, files, strategy);
        return new MultipartRequestWrapper(req, parameters, files);
    }

    private static void parseQueryString(String queryString, ListsMap<String> parameters) {
        log.debug((Object)("Query string is : '" + queryString + "'"));
        if (queryString != null) {
            String[] pieces;
            for (String piece : pieces = queryString.split("&")) {
                int equalsHere = piece.indexOf(61);
                if (piece.trim().isEmpty()) continue;
                if (equalsHere <= 0) {
                    parameters.add(MultipartRequestWrapper.decode(piece), "");
                    continue;
                }
                String key = piece.substring(0, equalsHere);
                String value = piece.substring(equalsHere + 1);
                parameters.add(MultipartRequestWrapper.decode(key), MultipartRequestWrapper.decode(value));
            }
        }
        log.debug((Object)("Parameters from query string are: " + parameters));
    }

    private static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e, (Throwable)e);
            return encoded;
        }
    }

    private static void parseFileParts(HttpServletRequest req, ListsMap<String> parameters, ListsMap<FileItem> files, ParsingStrategy strategy) throws IOException {
        ServletFileUpload upload = MultipartRequestWrapper.createUploadHandler(req, strategy.maximumMultipartFileSize());
        List<FileItem> items = MultipartRequestWrapper.parseRequestIntoFileItems(req, upload, strategy);
        for (FileItem item : items) {
            String name = item.getFieldName();
            if (item.isFormField()) {
                String value;
                try {
                    value = item.getString("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = item.getString();
                }
                parameters.add(name, value);
                log.debug((Object)("Form field (parameter) " + name + "=" + value));
                continue;
            }
            files.add(name, item);
            log.debug((Object)("File " + name + ": " + item.getSize() + " bytes."));
        }
    }

    private static ServletFileUpload createUploadHandler(HttpServletRequest req, long maxFileSize) {
        File tempDir = MultipartRequestWrapper.figureTemporaryDirectory(req);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(10240);
        factory.setRepository(tempDir);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(maxFileSize);
        return upload;
    }

    private static File figureTemporaryDirectory(HttpServletRequest request) {
        return (File)request.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    private static List<FileItem> parseRequestIntoFileItems(HttpServletRequest req, ServletFileUpload upload, ParsingStrategy strategy) throws IOException {
        try {
            return upload.parseRequest(req);
        }
        catch (FileUploadBase.FileSizeLimitExceededException | FileUploadBase.SizeLimitExceededException e) {
            try {
                ServletInputStream in = req.getInputStream();
                byte[] buffer = new byte[4096];
                while (in.read(buffer) != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (strategy.stashFileSizeException()) {
                req.setAttribute(ATTRIBUTE_FILE_SIZE_EXCEPTION, (Object)e);
                return Collections.emptyList();
            }
            throw new IOException(e);
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
    }

    public MultipartRequestWrapper(HttpServletRequest req, ListsMap<String> parameters, ListsMap<FileItem> files) {
        super(req);
        this.parameters = parameters;
        req.setAttribute(ATTRIBUTE_IS_MULTIPART, (Object)Boolean.TRUE);
        req.setAttribute(ATTRIBUTE_FILE_ITEM_MAP, files);
    }

    public String getParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return (String)((List)this.parameters.get(name)).get(0);
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(new HashSet(this.parameters.keySet()));
    }

    public String[] getParameterValues(String name) {
        if (this.parameters.containsKey(name)) {
            return ((List)this.parameters.get(name)).toArray(EMPTY_ARRAY);
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String key : this.parameters.keySet()) {
            result.put(key, ((List)this.parameters.get(key)).toArray(EMPTY_ARRAY));
        }
        return result;
    }

    public static interface ParsingStrategy {
        public long maximumMultipartFileSize();

        public boolean stashFileSizeException();
    }

    private static class ListsMap<T>
    extends HashMap<String, List<T>> {
        private ListsMap() {
        }

        void add(String key, T value) {
            if (!this.containsKey(key)) {
                this.put(key, new ArrayList());
            }
            ((List)this.get(key)).add(value);
        }
    }
}

