/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.EditLiteral;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BasicValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class MultiValueEditSubmission {
    String editKey;
    private Map<String, List<Literal>> literalsFromForm;
    private Map<String, List<String>> urisFromForm;
    private Map<String, String> validationErrors;
    private BasicValidationVTwo basicValidation;
    private static Model literalCreationModel;
    private String entityToReturnTo;
    private VitroRequest _vreq;
    private static final String TIME_URI;
    private Log log = LogFactory.getLog(MultiValueEditSubmission.class);

    public MultiValueEditSubmission(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        this._vreq = vreq;
        Map<String, String[]> queryParameters = vreq.getParameterMap();
        if (editConfig == null) {
            throw new Error("EditSubmission needs an EditConfiguration");
        }
        this.editKey = editConfig.getEditKey();
        if (this.editKey == null || this.editKey.trim().length() == 0) {
            throw new Error("EditSubmission needs an 'editKey' parameter from the EditConfiguration");
        }
        this.entityToReturnTo = editConfig.getEntityToReturnTo();
        this.validationErrors = new HashMap<String, String>();
        this.urisFromForm = new HashMap<String, List<String>>();
        for (String var : editConfig.getUrisOnform()) {
            String[] valuesArray = queryParameters.get(var);
            this.addUriToForm(editConfig, var, valuesArray);
        }
        this.literalsFromForm = new HashMap<String, List<Literal>>();
        for (String var : editConfig.getLiteralsOnForm()) {
            FieldVTwo field = editConfig.getField(var);
            if (field == null) {
                this.log.error((Object)("could not find field " + var + " in EditConfiguration"));
                continue;
            }
            if (field.getEditElement() != null) {
                this.log.debug((Object)"skipping field with edit element, it should not be in literals on form list");
                continue;
            }
            String[] valuesArray = queryParameters.get(var);
            this.addLiteralToForm(editConfig, field, var, valuesArray);
        }
        if (this.log.isDebugEnabled()) {
            for (String key : this.literalsFromForm.keySet()) {
                this.log.debug((Object)(key + " literal " + this.literalsFromForm.get(key)));
            }
            for (String key : this.urisFromForm.keySet()) {
                this.log.debug((Object)(key + " uri " + this.urisFromForm.get(key)));
            }
        }
        this.processEditElementFields(editConfig, queryParameters);
        this.basicValidation = new BasicValidationVTwo(editConfig, I18n.bundle((HttpServletRequest)vreq));
        Map<String, String> errors = this.basicValidation.validateUris(this.urisFromForm);
        errors.putAll(this.basicValidation.validateLiterals(this.literalsFromForm));
        if (errors != null && !errors.isEmpty()) {
            this.validationErrors.putAll(errors);
        }
        if (editConfig.getValidators() != null) {
            for (N3ValidatorVTwo validator : editConfig.getValidators()) {
                if (validator == null || (errors = validator.validate(editConfig, this)) == null) continue;
                this.validationErrors.putAll(errors);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.toString());
        }
    }

    protected void processEditElementFields(EditConfigurationVTwo editConfig, Map<String, String[]> queryParameters) {
        for (String fieldName : editConfig.getFields().keySet()) {
            FieldVTwo field = editConfig.getFields().get(fieldName);
            if (field == null || field.getEditElement() == null) continue;
            EditElementVTwo element = field.getEditElement();
            this.log.debug((Object)("Checking EditElement for field " + fieldName + " type: " + element.getClass().getName()));
            Map<String, String> errMsgs = element.getValidationMessages(fieldName, editConfig, queryParameters);
            this.validationErrors.putAll(errMsgs);
            if (errMsgs == null || errMsgs.isEmpty()) {
                Map<String, List<Literal>> literalsFromElement;
                Map<String, List<String>> urisFromElement = element.getURIs(fieldName, editConfig, queryParameters);
                if (urisFromElement != null) {
                    this.urisFromForm.putAll(urisFromElement);
                }
                if ((literalsFromElement = element.getLiterals(fieldName, editConfig, queryParameters)) == null) continue;
                this.literalsFromForm.putAll(literalsFromElement);
                continue;
            }
            this.log.debug((Object)("got validation errors for field " + fieldName + " not processing field for literals or URIs"));
        }
    }

    public Literal createLiteral_ORIG(String value, String datatypeUri, String lang) {
        if (datatypeUri != null) {
            if ("http://www.w3.org/2001/XMLSchema:anyURI".equals(datatypeUri)) {
                try {
                    return literalCreationModel.createTypedLiteral(URLEncoder.encode(value, "UTF8"), datatypeUri);
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
            return literalCreationModel.createTypedLiteral(value, datatypeUri);
        }
        if (lang != null && lang.length() > 0) {
            return literalCreationModel.createLiteral(value, lang);
        }
        return ResourceFactory.createPlainLiteral((String)value);
    }

    public Literal createLiteral(String value, String datatypeUri, String lang) {
        if (datatypeUri != null && !datatypeUri.isEmpty()) {
            if (XSD.anyURI.getURI().equals(datatypeUri)) {
                return literalCreationModel.createTypedLiteral(value, datatypeUri);
            }
            if ((XSD.xstring.getURI().equals(datatypeUri) || RDF.dtLangString.getURI().equals(datatypeUri)) && lang != null && lang.length() > 0) {
                return ResourceFactory.createLangLiteral((String)value, (String)lang);
            }
            return literalCreationModel.createTypedLiteral(value, datatypeUri);
        }
        if (lang != null && lang.length() > 0) {
            return ResourceFactory.createLangLiteral((String)value, (String)lang);
        }
        return ResourceFactory.createPlainLiteral((String)value);
    }

    public Map<String, String> getValidationErrors() {
        return this.validationErrors;
    }

    public Map<String, List<Literal>> getLiteralsFromForm() {
        return this.literalsFromForm;
    }

    public Map<String, List<String>> getUrisFromForm() {
        return this.urisFromForm;
    }

    public Literal getTime(Map<String, String[]> queryParameters, String fieldName) {
        List<String> hour = Arrays.asList(queryParameters.get("hour" + fieldName));
        List<String> minute = Arrays.asList(queryParameters.get("minute" + fieldName));
        if (hour == null || hour.size() == 0 || minute == null || minute.size() == 0) {
            this.log.info((Object)("Could not find query parameter values for time field " + fieldName));
            this.validationErrors.put(fieldName, "time must be supplied");
            return null;
        }
        int hourInt = -1;
        int minuteInt = -1;
        String hourParamStr = hour.get(0);
        String minuteParamStr = minute.get(0);
        if (hourParamStr.length() == 0 && minuteParamStr.length() == 0) {
            return null;
        }
        String errors = "";
        try {
            hourInt = Integer.parseInt(hour.get(0));
            if (hourInt < 0 || hourInt > 23) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            errors = errors + "Please enter a valid hour.  ";
        }
        try {
            minuteInt = Integer.parseInt(minute.get(0));
            if (minuteInt < 0 || minuteInt > 59) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            errors = errors + "Please enter a valid minute.  ";
        }
        if (errors.length() > 0) {
            this.validationErrors.put(fieldName, errors);
            return null;
        }
        String hourStr = hourInt < 10 ? "0" + Integer.toString(hourInt) : Integer.toString(hourInt);
        String minuteStr = minuteInt < 10 ? "0" + Integer.toString(minuteInt) : Integer.toString(minuteInt);
        String secondStr = "00";
        return new EditLiteral(hourStr + ":" + minuteStr + ":" + secondStr, TIME_URI, null);
    }

    public void setLiteralsFromForm(Map<String, List<Literal>> literalsFromForm) {
        this.literalsFromForm = literalsFromForm;
    }

    public void setUrisFromForm(Map<String, List<String>> urisFromForm) {
        this.urisFromForm = urisFromForm;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String getEntityToReturnTo() {
        return this.entityToReturnTo;
    }

    public void setEntityToReturnTo(String string) {
        this.entityToReturnTo = string;
    }

    public void addLiteralToForm(EditConfigurationVTwo editConfig, FieldVTwo field, String var, String[] valuesArray) {
        List<String> valueList;
        List<String> list = valueList = valuesArray != null ? Arrays.asList(valuesArray) : null;
        if (valueList != null && valueList.size() > 0) {
            ArrayList<Literal> literalsArray = new ArrayList<Literal>();
            for (String value : valueList) {
                if (StringUtils.isEmpty((CharSequence)(value = N3EditUtils.stripInvalidXMLChars(value)))) continue;
                String rangeLang = field.getRangeLang();
                try {
                    if (this._vreq != null) {
                        Boolean getLabelLanguage = false;
                        if (!StringUtils.isBlank((CharSequence)editConfig.formUrl) && editConfig.formUrl.contains("RDFSLabelGenerator")) {
                            getLabelLanguage = true;
                        }
                        if (!StringUtils.isBlank((CharSequence)editConfig.getLiteralsInScope().get("label").get(0).getLanguage()) && getLabelLanguage.booleanValue()) {
                            rangeLang = editConfig.getLiteralsInScope().get("label").get(0).getLanguage();
                        } else {
                            rangeLang = this._vreq.getLocale().getLanguage();
                            if (!this._vreq.getLocale().getCountry().isEmpty()) {
                                rangeLang = rangeLang + "-" + this._vreq.getLocale().getCountry();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                literalsArray.add(this.createLiteral(value, field.getRangeDatatypeUri(), rangeLang));
            }
            this.literalsFromForm.put(var, literalsArray);
        } else {
            this.log.debug((Object)("could not find value for parameter " + var));
        }
    }

    public void addUriToForm(EditConfigurationVTwo editConfig, String var, String[] valuesArray) {
        List<String> values;
        List<String> list = values = valuesArray != null ? Arrays.asList(valuesArray) : null;
        if (values != null && values.size() > 0) {
            this.urisFromForm.put(var, values);
            for (String uri : values) {
                if (uri == null || uri.length() != 0 || !editConfig.getNewResources().containsKey(var)) continue;
                this.log.debug((Object)("A new resource URI will be made for var " + var + " since it was blank on the form."));
                this.urisFromForm.remove(var);
            }
        } else {
            this.log.debug((Object)("No value found for query parameter " + var));
        }
    }

    public boolean hasLiteralValue(String key) {
        return this.literalsFromForm.containsKey(key) && this.literalsFromForm.get(key) != null;
    }

    public boolean hasUriValue(String key) {
        return this.urisFromForm.containsKey(key) && this.urisFromForm.get(key) != null;
    }

    static {
        TIME_URI = XSD.time.getURI();
        literalCreationModel = ModelFactory.createDefaultModel();
    }
}

