/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.email;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.web.directives.EmailDirective;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerEmailMessage {
    private static final Log log = LogFactory.getLog(FreemarkerEmailMessage.class);
    private final VitroRequest vreq;
    private final Session mailSession;
    private final Configuration config;
    private final List<Recipient> recipients = new ArrayList<Recipient>();
    private final InternetAddress replyToAddress;
    private InternetAddress fromAddress = null;
    private String subject = "";
    private String templateName = "";
    private String htmlContent = "";
    private String textContent = "";
    private Map<String, Object> bodyMap = Collections.emptyMap();

    FreemarkerEmailMessage(VitroRequest vreq, Configuration fConfig, Session mailSession, InternetAddress replyToAddress) {
        this.vreq = vreq;
        this.mailSession = mailSession;
        this.replyToAddress = replyToAddress;
        this.config = fConfig;
    }

    public void addRecipient(Message.RecipientType type, String emailAddress) {
        if (type == null) {
            throw new NullPointerException("type may not be null.");
        }
        if (emailAddress == null) {
            log.warn((Object)("recipient type was '" + type + "', but email address was null."));
            return;
        }
        try {
            this.recipients.add(new Recipient(type, emailAddress));
        }
        catch (AddressException e) {
            log.warn((Object)("invalid recipient address: " + type + ", '" + emailAddress + "'"));
        }
    }

    public void addRecipient(Message.RecipientType type, String emailAddress, String personalName) {
        if (personalName == null) {
            this.addRecipient(type, emailAddress);
        }
        if (type == null) {
            throw new NullPointerException("type may not be null.");
        }
        if (emailAddress == null) {
            log.warn((Object)("recipient type was '" + type + "', but email address was null."));
            return;
        }
        try {
            this.recipients.add(new Recipient(type, emailAddress, personalName));
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("invalid recipient address: " + type + ", '" + emailAddress + "', personal name '" + personalName + "'"));
        }
    }

    public void setSubject(String subject) {
        this.subject = this.nonNull(subject, "");
    }

    public void setHtmlContent(String htmlContent) {
        this.htmlContent = this.nonNull(htmlContent, "");
    }

    public void setTextContent(String textContent) {
        this.textContent = this.nonNull(textContent, "");
    }

    public void setTemplate(String templateName) {
        this.templateName = this.nonNull(templateName, "");
    }

    public void setBodyMap(Map<String, Object> body) {
        this.bodyMap = body == null ? Collections.emptyMap() : new HashMap<String, Object>(body);
    }

    public void processTemplate() {
        this.bodyMap.put("email", new EmailDirective(this));
        try {
            this.config.getTemplate(this.templateName).process(this.bodyMap, (Writer)new StringWriter());
        }
        catch (TemplateException | IOException e) {
            log.error((Object)e, e);
        }
    }

    public boolean send() {
        try {
            MimeMessage msg = new MimeMessage(this.mailSession);
            msg.setReplyTo(new Address[]{this.replyToAddress});
            if (this.fromAddress == null) {
                msg.addFrom(new Address[]{this.replyToAddress});
            } else {
                msg.addFrom(new Address[]{this.fromAddress});
            }
            for (Recipient recipient : this.recipients) {
                msg.addRecipient(recipient.type, (Address)recipient.address);
            }
            msg.setSubject(this.subject);
            if (this.textContent.isEmpty()) {
                if (this.htmlContent.isEmpty()) {
                    log.error((Object)"Message has neither text body nor HTML body");
                } else {
                    msg.setContent((Object)this.htmlContent, "text/html; charset=UTF-8");
                }
            } else if (this.htmlContent.isEmpty()) {
                msg.setContent((Object)this.textContent, "text/plain; charset=UTF-8");
            } else {
                MimeMultipart content = new MimeMultipart("alternative");
                this.addBodyPart(content, this.textContent, "text/plain; charset=UTF-8");
                this.addBodyPart(content, this.htmlContent, "text/html; charset=UTF-8");
                msg.setContent((Multipart)content);
            }
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return true;
        }
        catch (MessagingException e) {
            log.error((Object)"Failed to send message.", (Throwable)e);
            return false;
        }
    }

    private void addBodyPart(MimeMultipart content, String textBody, String type) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)textBody, type);
        content.addBodyPart((BodyPart)bodyPart);
    }

    public String getReplyToAddress() {
        return this.replyToAddress.getAddress();
    }

    private <T> T nonNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    private static class Recipient {
        final Message.RecipientType type;
        final InternetAddress address;

        public Recipient(Message.RecipientType type, String address) throws AddressException {
            this.type = type;
            this.address = new InternetAddress(address);
        }

        public Recipient(Message.RecipientType type, String address, String personalName) throws UnsupportedEncodingException {
            this.type = type;
            this.address = new InternetAddress(address, personalName);
        }
    }
}

