/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.filestorage.FileServingHelper;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.FileInfo;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.ImageInfo;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileAlreadyExistsException;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadedFileHelper {
    private static final Log log = LogFactory.getLog(UploadedFileHelper.class);
    private final FileStorage fileStorage;
    private final WebappDaoFactory wadf;
    private final IndividualDao individualDao;
    private final DataPropertyStatementDao dataPropertyStatementDao;
    private final ObjectPropertyStatementDao objectPropertyStatementDao;
    private final ServletContext ctx;

    public UploadedFileHelper(FileStorage fileStorage, WebappDaoFactory wadf, ServletContext ctx) {
        this.fileStorage = fileStorage;
        this.wadf = wadf;
        this.individualDao = wadf.getIndividualDao();
        this.dataPropertyStatementDao = wadf.getDataPropertyStatementDao();
        this.objectPropertyStatementDao = wadf.getObjectPropertyStatementDao();
        this.ctx = ctx;
    }

    public FileInfo createFile(String filename, String mimeType, InputStream inputStream) throws FileAlreadyExistsException, IOException {
        if (filename == null) {
            throw new NullPointerException("filename may not be null.");
        }
        if (mimeType == null) {
            throw new NullPointerException("mimeType may not be null.");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream may not be null.");
        }
        Individual byteStream = this.createByteStreamIndividual(filename);
        String bytestreamUri = byteStream.getURI();
        String aliasUrl = byteStream.getDataValue("http://vitro.mannlib.cornell.edu/ns/vitro/public#directDownloadUrl");
        Individual file = this.createFileIndividual(mimeType, filename, byteStream);
        String fileUri = file.getURI();
        this.fileStorage.createFile(bytestreamUri, filename, inputStream);
        FileInfo.Builder builder = new FileInfo.Builder();
        builder.setFilename(filename);
        builder.setMimeType(mimeType);
        builder.setUri(fileUri);
        builder.setBytestreamUri(bytestreamUri);
        builder.setBytestreamAliasUrl(aliasUrl);
        return builder.build();
    }

    public void setImagesOnEntity(String entityUri, FileInfo mainInfo, FileInfo thumbInfo) {
        if (entityUri == null) {
            throw new NullPointerException("entityUri may not be null.");
        }
        if (mainInfo == null) {
            throw new NullPointerException("mainInfo may not be null.");
        }
        if (thumbInfo == null) {
            throw new NullPointerException("thumbInfo may not be null.");
        }
        Individual entity = this.individualDao.getIndividualByURI(entityUri);
        if (entity == null) {
            throw new NullPointerException("No entity found for URI '" + entityUri + "'.");
        }
        this.objectPropertyStatementDao.insertNewObjectPropertyStatement(new ObjectPropertyStatementImpl(mainInfo.getUri(), "http://vitro.mannlib.cornell.edu/ns/vitro/public#thumbnailImage", thumbInfo.getUri()));
        entity.setMainImageUri(mainInfo.getUri());
        this.individualDao.updateIndividual(entity);
        log.debug((Object)("Set images on '" + entity.getURI() + "': main=" + mainInfo + ", thumb=" + thumbInfo));
    }

    public void removeMainImage(Individual entity) {
        ImageInfo imageInfo = ImageInfo.instanceFromEntityUri(this.wadf, entity);
        if (imageInfo == null) {
            log.debug((Object)("No image to remove from '" + entity.getURI() + "'"));
            return;
        }
        entity.setMainImageUri(null);
        this.individualDao.updateIndividual(entity);
        ObjectPropertyStatementImpl stmt = new ObjectPropertyStatementImpl(imageInfo.getMainImage().getUri(), "http://vitro.mannlib.cornell.edu/ns/vitro/public#thumbnailImage", imageInfo.getThumbnail().getUri());
        this.objectPropertyStatementDao.deleteObjectPropertyStatement(stmt);
        this.deleteIfNotReferenced(imageInfo.getMainImage());
        this.deleteIfNotReferenced(imageInfo.getThumbnail());
    }

    private Individual createByteStreamIndividual(String filename) {
        IndividualImpl byteStream = new IndividualImpl();
        byteStream.setVClassURI("http://vitro.mannlib.cornell.edu/ns/vitro/public#FileByteStream");
        String uri = null;
        try {
            uri = this.individualDao.insertNewIndividual(byteStream);
        }
        catch (InsertException e) {
            throw new IllegalStateException("Failed to create the bytestream individual.", e);
        }
        this.dataPropertyStatementDao.insertNewDataPropertyStatement(new DataPropertyStatementImpl(uri, "http://vitro.mannlib.cornell.edu/ns/vitro/public#directDownloadUrl", FileServingHelper.getBytestreamAliasUrl(uri, filename, this.ctx)));
        return this.individualDao.getIndividualByURI(uri);
    }

    private Individual createFileIndividual(String mimeType, String filename, Individual byteStream) {
        IndividualImpl file = new IndividualImpl();
        file.setVClassURI("http://vitro.mannlib.cornell.edu/ns/vitro/public#File");
        String uri = null;
        try {
            uri = this.individualDao.insertNewIndividual(file);
        }
        catch (InsertException e) {
            throw new IllegalStateException("Failed to create the file individual.", e);
        }
        this.dataPropertyStatementDao.insertNewDataPropertyStatement(new DataPropertyStatementImpl(uri, "http://vitro.mannlib.cornell.edu/ns/vitro/public#filename", filename));
        this.dataPropertyStatementDao.insertNewDataPropertyStatement(new DataPropertyStatementImpl(uri, "http://vitro.mannlib.cornell.edu/ns/vitro/public#mimeType", mimeType));
        this.objectPropertyStatementDao.insertNewObjectPropertyStatement(new ObjectPropertyStatementImpl(uri, "http://vitro.mannlib.cornell.edu/ns/vitro/public#downloadLocation", byteStream.getURI()));
        return this.individualDao.getIndividualByURI(uri);
    }

    private void deleteIfNotReferenced(FileInfo file) {
        if (!this.isFileReferenced(file.getUri())) {
            try {
                this.fileStorage.deleteFile(file.getBytestreamUri());
                this.individualDao.deleteIndividual(file.getBytestreamUri());
                this.individualDao.deleteIndividual(file.getUri());
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't delete the file: '" + file.getBytestreamUri(), e);
            }
        }
    }

    private boolean isFileReferenced(String surrogateUri) {
        if (surrogateUri == null) {
            return false;
        }
        ObjectPropertyStatementImpl opStmt = new ObjectPropertyStatementImpl(null, null, surrogateUri);
        List<ObjectPropertyStatement> stmts = this.objectPropertyStatementDao.getObjectPropertyStatements(opStmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)(stmts.size() + " statements referencing '" + surrogateUri + "'"));
            for (ObjectPropertyStatement stmt : stmts) {
                log.debug((Object)("'" + stmt.getSubjectURI() + "' -- '" + stmt.getPropertyURI() + "' -- '" + stmt.getObjectURI() + "'"));
            }
        }
        return !stmts.isEmpty();
    }
}

