/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nLogger;
import edu.cornell.mannlib.vitro.webapp.i18n.VitroResourceBundle;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18n {
    private static final Log log = LogFactory.getLog(I18n.class);
    public static final String DEFAULT_BUNDLE_NAME = "all";
    private static final String ATTRIBUTE_CACHE_CLEARED = I18n.class.getName() + "-cacheCleared";
    private static I18n instance;
    private final ServletContext ctx;
    private AtomicReference<String> themeDirectory = new AtomicReference<String>("");

    protected I18n(ServletContext ctx) {
        this.ctx = ctx;
    }

    public static void setup(ServletContext ctx) {
        instance = new I18n(ctx);
    }

    public static String text(String bundleName, HttpServletRequest req, String key, Object ... parameters) {
        return I18n.bundle(bundleName, req).text(key, parameters);
    }

    public static String text(HttpServletRequest req, String key, Object ... parameters) {
        return I18n.bundle(req).text(key, parameters);
    }

    public static I18nBundle bundle(String bundleName, HttpServletRequest req) {
        return instance.getBundle(bundleName, req);
    }

    public static I18nBundle bundle(HttpServletRequest req) {
        return instance.getBundle(DEFAULT_BUNDLE_NAME, req);
    }

    public static I18nBundle bundle(List<Locale> preferredLocales) {
        return instance.getBundle(DEFAULT_BUNDLE_NAME, preferredLocales);
    }

    protected I18nBundle getBundle(String bundleName, HttpServletRequest req) {
        log.debug((Object)("Getting request bundle '" + bundleName + "'"));
        this.checkDevelopmentMode(req);
        this.checkForChangeInThemeDirectory(req);
        Locale locale = req.getLocale();
        return this.getBundle(bundleName, locale);
    }

    protected I18nBundle getBundle(String bundleName, List<Locale> preferredLocales) {
        log.debug((Object)("Getting context bundle '" + bundleName + "'"));
        this.checkDevelopmentMode();
        this.checkForChangeInThemeDirectory(this.ctx);
        Locale locale = SelectedLocale.getPreferredLocale(this.ctx, preferredLocales);
        return this.getBundle(bundleName, locale);
    }

    private I18nBundle getBundle(String bundleName, Locale locale) {
        I18nLogger i18nLogger = new I18nLogger();
        try {
            String dir = this.themeDirectory.get();
            ThemeBasedControl control = new ThemeBasedControl(this.ctx, dir);
            ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale, control);
            return new I18nBundle(bundleName, rb, i18nLogger);
        }
        catch (MissingResourceException e) {
            log.warn((Object)("Didn't find text bundle '" + bundleName + "'"));
            return I18nBundle.emptyBundle(bundleName, i18nLogger);
        }
        catch (Exception e) {
            log.error((Object)("Failed to create text bundle '" + bundleName + "'"), (Throwable)e);
            return I18nBundle.emptyBundle(bundleName, i18nLogger);
        }
    }

    private void checkDevelopmentMode(HttpServletRequest req) {
        if (DeveloperSettings.getInstance().getBoolean(Key.I18N_DEFEAT_CACHE)) {
            log.debug((Object)"In development mode - clearing the cache.");
            this.clearCacheOnRequest(req);
        }
    }

    private void checkDevelopmentMode() {
        if (DeveloperSettings.getInstance().getBoolean(Key.I18N_DEFEAT_CACHE)) {
            log.debug((Object)"In development mode - clearing the cache.");
            ResourceBundle.clearCache();
        }
    }

    private void checkForChangeInThemeDirectory(HttpServletRequest req) {
        String previousDir;
        String currentDir = new VitroRequest(req).getAppBean().getThemeDir();
        if (!currentDir.equals(previousDir = this.themeDirectory.getAndSet(currentDir))) {
            log.debug((Object)("Theme directory changed from '" + previousDir + "' to '" + currentDir + "' - clearing the cache."));
            this.clearCacheOnRequest(req);
        }
    }

    private void checkForChangeInThemeDirectory(ServletContext ctx) {
        String previousDir;
        String currentDir;
        WebappDaoFactory wdf = ModelAccess.on(ctx).getWebappDaoFactory();
        if (Objects.nonNull(wdf) && Objects.nonNull(wdf.getApplicationDao()) && Objects.nonNull(wdf.getApplicationDao().getApplicationBean()) && !(currentDir = wdf.getApplicationDao().getApplicationBean().getThemeDir()).equals(previousDir = this.themeDirectory.getAndSet(currentDir))) {
            log.debug((Object)("Theme directory changed from '" + previousDir + "' to '" + currentDir + "' - clearing the cache."));
            ResourceBundle.clearCache();
        }
    }

    private void clearCacheOnRequest(HttpServletRequest req) {
        if (req.getAttribute(ATTRIBUTE_CACHE_CLEARED) != null) {
            log.debug((Object)"Cache was already cleared on this request.");
        } else {
            ResourceBundle.clearCache();
            log.debug((Object)"Cache cleared.");
            req.setAttribute(ATTRIBUTE_CACHE_CLEARED, (Object)Boolean.TRUE);
        }
    }

    private static class LocaleComparator
    implements Comparator<Locale> {
        private LocaleComparator() {
        }

        @Override
        public int compare(Locale o1, Locale o2) {
            int c = o1.getLanguage().compareTo(o2.getLanguage());
            if (c == 0 && (c = o1.getCountry().compareTo(o2.getCountry())) == 0) {
                c = o1.getVariant().compareTo(o2.getVariant());
            }
            return c;
        }
    }

    static class ThemeBasedControl
    extends ResourceBundle.Control {
        private static final String BUNDLE_DIRECTORY = "i18n/";
        private final ServletContext ctx;
        private final String themeDirectory;

        public ThemeBasedControl(ServletContext ctx, String themeDirectory) {
            this.ctx = ctx;
            this.themeDirectory = themeDirectory;
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            this.checkArguments(baseName, locale, format);
            log.debug((Object)("Creating bundle for '" + baseName + "', " + locale + ", '" + format + "', " + reload));
            String bundleName = this.toBundleName(baseName, locale);
            if (bundleName == null) {
                throw new NullPointerException("bundleName may not be null.");
            }
            String themeI18nPath = "/" + this.themeDirectory + BUNDLE_DIRECTORY;
            String appI18nPath = "/i18n/";
            log.debug((Object)("Paths are '" + themeI18nPath + "' and '" + appI18nPath + "'"));
            return VitroResourceBundle.getBundle(bundleName, this.ctx, appI18nPath, themeI18nPath, this);
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> usualList = super.getCandidateLocales(baseName, locale);
            SortedSet<Locale> approximateMatches = this.findApproximateMatches(locale);
            approximateMatches.removeAll(usualList);
            if (approximateMatches.isEmpty()) {
                return usualList;
            }
            LinkedList<Locale> mergedList = new LinkedList<Locale>(usualList);
            int rootLocaleHere = mergedList.indexOf(Locale.ROOT);
            if (rootLocaleHere == -1) {
                mergedList.addAll(approximateMatches);
            } else {
                mergedList.addAll(rootLocaleHere, approximateMatches);
            }
            return mergedList;
        }

        private SortedSet<Locale> findApproximateMatches(Locale locale) {
            TreeSet<Locale> set = new TreeSet<Locale>(new LocaleComparator());
            for (Locale l : SelectedLocale.getSelectableLocales(this.ctx)) {
                if (!locale.getLanguage().equals(l.getLanguage())) continue;
                set.add(l);
            }
            return set;
        }

        private void checkArguments(String baseName, Locale locale, String format) {
            if (baseName == null) {
                throw new NullPointerException("baseName may not be null.");
            }
            if (locale == null) {
                throw new NullPointerException("locale may not be null.");
            }
            if (format == null) {
                throw new NullPointerException("format may not be null.");
            }
            if (!FORMAT_DEFAULT.contains(format)) {
                throw new IllegalArgumentException("format must be one of these: " + FORMAT_DEFAULT);
            }
        }
    }
}

