/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nLogger {
    private static final Log log = LogFactory.getLog(I18nLogger.class);
    private final boolean isLogging;

    public I18nLogger() {
        DeveloperSettings settings = DeveloperSettings.getInstance();
        this.isLogging = settings.getBoolean(Key.I18N_LOG_STRINGS) && log.isInfoEnabled();
    }

    public void log(String bundleName, String key, Object[] parameters, String rawText, String formattedText) {
        if (this.isLogging) {
            String message = String.format("Retrieved from %s.%s with %s: '%s'", bundleName, key, Arrays.toString(parameters), rawText);
            if (!rawText.equals(formattedText)) {
                message = message + String.format(" --> '%s'", formattedText);
            }
            log.info((Object)message);
        }
    }
}

