/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.RDFNode;

public interface RDFService {
    public boolean changeSetUpdate(ChangeSet var1) throws RDFServiceException;

    public void newIndividual(String var1, String var2) throws RDFServiceException;

    public void newIndividual(String var1, String var2, String var3) throws RDFServiceException;

    public InputStream sparqlConstructQuery(String var1, ModelSerializationFormat var2) throws RDFServiceException;

    public void sparqlConstructQuery(String var1, Model var2) throws RDFServiceException;

    public InputStream sparqlDescribeQuery(String var1, ModelSerializationFormat var2) throws RDFServiceException;

    public InputStream sparqlSelectQuery(String var1, ResultFormat var2) throws RDFServiceException;

    public void sparqlSelectQuery(String var1, ResultSetConsumer var2) throws RDFServiceException;

    public boolean sparqlAskQuery(String var1) throws RDFServiceException;

    public List<String> getGraphURIs() throws RDFServiceException;

    public void getGraphMetadata() throws RDFServiceException;

    public String getDefaultWriteGraphURI() throws RDFServiceException;

    public void serializeAll(OutputStream var1) throws RDFServiceException;

    public void serializeGraph(String var1, OutputStream var2) throws RDFServiceException;

    public boolean isEquivalentGraph(String var1, InputStream var2, ModelSerializationFormat var3) throws RDFServiceException;

    public boolean isEquivalentGraph(String var1, Model var2) throws RDFServiceException;

    public void registerJenaModelChangedListener(ModelChangedListener var1) throws RDFServiceException;

    public void unregisterJenaModelChangedListener(ModelChangedListener var1) throws RDFServiceException;

    public void registerListener(ChangeListener var1) throws RDFServiceException;

    public void unregisterListener(ChangeListener var1) throws RDFServiceException;

    public ChangeSet manufactureChangeSet();

    public long countTriples(RDFNode var1, RDFNode var2, RDFNode var3) throws RDFServiceException;

    public Model getTriples(RDFNode var1, RDFNode var2, RDFNode var3, long var4, long var6) throws RDFServiceException;

    public boolean preferPreciseOptionals();

    public void close();

    public void setVitroRequest(VitroRequest var1);

    public VitroRequest getVitroRequest();

    public static enum ResultFormat {
        JSON,
        CSV,
        XML,
        TEXT;

    }

    public static enum ModelSerializationFormat {
        RDFXML,
        N3,
        NTRIPLE;

    }

    public static enum SPARQLQueryType {
        SELECT,
        CONSTRUCT,
        DESCRIBE,
        ASK;

    }
}

