/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import edu.cornell.mannlib.vitro.webapp.reasoner.ModelUpdate;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.Statement;

public class SimpleReasonerTBoxListener
extends StatementListener {
    private static final Log log = LogFactory.getLog(SimpleReasonerTBoxListener.class);
    private SimpleReasoner simpleReasoner;
    private Thread workerThread;
    private boolean stopRequested;
    private String name;
    private volatile boolean processingUpdates = false;
    private ConcurrentLinkedQueue<ModelUpdate> modelUpdates = null;

    public SimpleReasonerTBoxListener(SimpleReasoner simpleReasoner) {
        this.simpleReasoner = simpleReasoner;
        this.stopRequested = false;
        this.modelUpdates = new ConcurrentLinkedQueue();
        this.processingUpdates = false;
    }

    public SimpleReasonerTBoxListener(SimpleReasoner simpleReasoner, String name) {
        this.simpleReasoner = simpleReasoner;
        this.name = name;
        this.stopRequested = false;
        this.modelUpdates = new ConcurrentLinkedQueue();
        this.processingUpdates = false;
    }

    public void addedStatement(Statement statement) {
        ModelUpdate mu = new ModelUpdate(statement, ModelUpdate.Operation.ADD, "http://vitro.mannlib.cornell.edu/default/asserted-tbox");
        this.processUpdate(mu);
    }

    public void removedStatement(Statement statement) {
        ModelUpdate mu = new ModelUpdate(statement, ModelUpdate.Operation.RETRACT, "http://vitro.mannlib.cornell.edu/default/asserted-tbox");
        this.processUpdate(mu);
    }

    private synchronized void processUpdate(ModelUpdate mu) {
        if (!this.processingUpdates && this.modelUpdates.peek() != null) {
            log.warn((Object)("TBoxProcessor thread was not running and work queue is not empty. size = " + this.modelUpdates.size() + " The work will be processed now."));
        }
        this.modelUpdates.add(mu);
        if (!this.processingUpdates) {
            this.processingUpdates = true;
            this.workerThread = new TBoxUpdateProcessor("TBoxUpdateProcessor (" + this.getName() + ")");
            this.workerThread.start();
        }
    }

    private synchronized ModelUpdate nextUpdate() {
        ModelUpdate mu = this.modelUpdates.poll();
        this.processingUpdates = mu != null;
        return mu;
    }

    public String getName() {
        return this.name == null ? "SimpleReasonerTBoxListener" : this.name;
    }

    public void setStopRequested() {
        this.stopRequested = true;
    }

    private class TBoxUpdateProcessor
    extends VitroBackgroundThread {
        public TBoxUpdateProcessor(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                log.debug((Object)"starting thread");
                ModelUpdate mu = SimpleReasonerTBoxListener.this.nextUpdate();
                while (mu != null && !SimpleReasonerTBoxListener.this.stopRequested) {
                    if (mu.getOperation() == ModelUpdate.Operation.ADD) {
                        SimpleReasonerTBoxListener.this.simpleReasoner.addedTBoxStatement(mu.getStatement());
                    } else if (mu.getOperation() == ModelUpdate.Operation.RETRACT) {
                        SimpleReasonerTBoxListener.this.simpleReasoner.removedTBoxStatement(mu.getStatement());
                    } else {
                        log.error((Object)("unexpected operation value in ModelUpdate object: " + (Object)((Object)mu.getOperation())));
                    }
                    mu = SimpleReasonerTBoxListener.this.nextUpdate();
                }
            }
            finally {
                SimpleReasonerTBoxListener.this.processingUpdates = false;
                log.debug((Object)"ending thread");
            }
        }
    }
}

