/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.exclusions;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExcludeBasedOnTypeNamespace
implements SearchIndexExcluder {
    private final List<String> namespaces = new ArrayList<String>();
    Pattern nsRegexPattern;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#excludes")
    public void addExcludedNamespace(String uri) {
        this.namespaces.add(uri);
    }

    @Validation
    public void compileRegexPattern() {
        StringBuilder nsOrPattern = new StringBuilder();
        for (int i = 0; i < this.namespaces.size(); ++i) {
            String ns = this.namespaces.get(i);
            nsOrPattern.append(i != 0 ? "|" : "").append(Pattern.quote(ns)).append("[^/#]*$");
        }
        this.nsRegexPattern = Pattern.compile(nsOrPattern.toString());
    }

    @Override
    public String checkForExclusion(Individual ind) {
        if (ind != null && ind.getVClasses() != null) {
            for (VClass vclass : ind.getVClasses()) {
                String excludeMsg = this.checkForSkip(ind, vclass);
                if (excludeMsg == null) continue;
                return excludeMsg;
            }
        }
        return null;
    }

    String checkForSkip(Individual individual, VClass vclass) {
        Matcher match;
        if (vclass != null && vclass.getURI() != null && (match = this.nsRegexPattern.matcher(vclass.getURI())).matches()) {
            return "Skipping because it is of a type in an excluded namespace.";
        }
        return null;
    }

    public String toString() {
        return "ExcludeBasedOnTypeNamespace[namespaces=" + this.namespaces + "]";
    }
}

