/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyStatementTemplateModel;
import java.util.List;

public class SubclassTemplateModel
extends BaseTemplateModel
implements Comparable<SubclassTemplateModel> {
    private final VClass vclass;
    private final List<ObjectPropertyStatementTemplateModel> statements;

    SubclassTemplateModel(VClass vclass, List<ObjectPropertyStatementTemplateModel> statements) {
        this.vclass = vclass;
        this.statements = statements;
    }

    @Override
    public int compareTo(SubclassTemplateModel other) {
        if (other == null) {
            return -1;
        }
        VClass vclassOther = other.getVClass();
        if (this.vclass == null) {
            return vclassOther == null ? 0 : 1;
        }
        if (vclassOther == null) {
            return -1;
        }
        int rank = this.vclass.getDisplayRank();
        int rankOther = vclassOther.getDisplayRank();
        int intCompare = 0;
        intCompare = rank < 1 ? (rankOther < 1 ? 0 : 1) : (rankOther < 1 ? -1 : Integer.compare(rank, rankOther));
        if (intCompare != 0) {
            return intCompare;
        }
        String name = this.getName();
        String nameOther = vclassOther.getName();
        if (name == null) {
            return nameOther == null ? 0 : 1;
        }
        if (nameOther == null) {
            return -1;
        }
        return name.compareToIgnoreCase(nameOther);
    }

    protected VClass getVClass() {
        return this.vclass;
    }

    public String getName() {
        return this.vclass == null ? "" : this.vclass.getName();
    }

    public List<ObjectPropertyStatementTemplateModel> getStatements() {
        return this.statements;
    }
}

