/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.bean;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBeanImpl;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionLevels;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.RoleRestrictedProperty;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccessStub;

public class PropertyRestrictionBeanImplTest
extends AbstractTestClass {
    private static final String NS_PROHIBITED = "http://prbi.prohibited/";
    private static final String URI_RESOURCE_EXCEPTIONAL = "http://prbi.prohibited/exceptionalResource";
    private static final String URI_PREDICATE_EXCEPTIONAL = "http://prbi.prohibited/exceptionalPredicate";
    private static final List<String> PROHIBITED_NAMESPACES = Arrays.asList("http://prbi.prohibited/");
    private static final List<String> PERMITTED_EXCEPTIONS = Arrays.asList("http://prbi.prohibited/exceptionalResource", "http://prbi.prohibited/exceptionalPredicate");
    private static final String URI_RESOURCE_ANY = "http://prbi.test/anyResource";
    private static final String URI_RESOURCE_PROHIBITED = "http://prbi.prohibited/resource";
    private static final String URI_PREDICATE_BARE = "http://prbi.test/barePredicate";
    private static final String URI_PREDICATE_PROHIBITED = "http://prbi.prohibited/predicate";
    private static final String URI_PREDICATE_UNKNOWN = "http://prbi.test/unknownPredicate";
    private static final String URI_DOMAIN_1 = "http://prbi.test/domain1";
    private static final String URI_RANGE_1 = "http://prbi.test/range1";
    private static final String URI_DOMAIN_2 = "http://prbi.test/domain2";
    private static final String URI_RANGE_2 = "http://prbi.test/range2";
    private PropertyRestrictionBeanImpl bean;
    private ObjectProperty barePredicate;
    private ObjectProperty prohibitedPredicate;
    private ObjectProperty exceptionalPredicate;
    private ObjectProperty unknownPredicate;
    private FauxProperty emptyFaux;
    private FauxProperty restrictedFaux;
    private FauxProperty unknownFaux;

    @Before
    public void setup() {
        this.barePredicate = this.createObjectProperty(null, URI_PREDICATE_BARE, null, BaseResourceBean.RoleLevel.EDITOR, BaseResourceBean.RoleLevel.CURATOR, BaseResourceBean.RoleLevel.DB_ADMIN);
        this.unknownPredicate = this.createObjectProperty(null, URI_PREDICATE_UNKNOWN, null, null, null, null);
        this.prohibitedPredicate = this.createObjectProperty(null, URI_PREDICATE_PROHIBITED, null, null, null, null);
        this.exceptionalPredicate = this.createObjectProperty(null, URI_PREDICATE_EXCEPTIONAL, null, BaseResourceBean.RoleLevel.CURATOR, BaseResourceBean.RoleLevel.EDITOR, BaseResourceBean.RoleLevel.EDITOR);
        this.emptyFaux = this.createFauxProperty(URI_DOMAIN_1, URI_PREDICATE_BARE, URI_RANGE_1, null, null, null);
        this.restrictedFaux = this.createFauxProperty(URI_DOMAIN_2, URI_PREDICATE_BARE, URI_RANGE_2, BaseResourceBean.RoleLevel.EDITOR, BaseResourceBean.RoleLevel.DB_ADMIN, BaseResourceBean.RoleLevel.CURATOR);
        this.unknownFaux = this.createFauxProperty(URI_DOMAIN_1, URI_PREDICATE_UNKNOWN, URI_RANGE_1, BaseResourceBean.RoleLevel.NOBODY, BaseResourceBean.RoleLevel.NOBODY, BaseResourceBean.RoleLevel.NOBODY);
        ObjectPropertyDaoStub opDao = new ObjectPropertyDaoStub();
        opDao.addObjectProperty(this.barePredicate);
        opDao.addObjectProperty(this.prohibitedPredicate);
        opDao.addObjectProperty(this.exceptionalPredicate);
        DataPropertyDaoStub dpDao = new DataPropertyDaoStub();
        FauxPropertyDaoStub fpDao = new FauxPropertyDaoStub();
        fpDao.insertFauxProperty(this.emptyFaux);
        fpDao.insertFauxProperty(this.restrictedFaux);
        WebappDaoFactoryStub wadf = new WebappDaoFactoryStub();
        wadf.setObjectPropertyDao(opDao);
        wadf.setDataPropertyDao(dpDao);
        wadf.setFauxPropertyDao(fpDao);
        ContextModelAccessStub models = new ContextModelAccessStub();
        models.setWebappDaoFactory(wadf);
        this.bean = new PropertyRestrictionBeanImpl(PROHIBITED_NAMESPACES, PERMITTED_EXCEPTIONS, (ContextModelAccess)models);
    }

    private ObjectProperty createObjectProperty(String domainUri, String uri, String rangeUri, BaseResourceBean.RoleLevel displayThreshold, BaseResourceBean.RoleLevel modifyThreshold, BaseResourceBean.RoleLevel publishThreshold) {
        ObjectProperty op = new ObjectProperty();
        op.setURI(uri);
        op.setDomainVClassURI(domainUri);
        op.setRangeVClassURI(rangeUri);
        op.setHiddenFromDisplayBelowRoleLevel(displayThreshold);
        op.setProhibitedFromUpdateBelowRoleLevel(modifyThreshold);
        op.setHiddenFromPublishBelowRoleLevel(publishThreshold);
        return op;
    }

    private FauxProperty createFauxProperty(String domainUri, String uri, String rangeUri, BaseResourceBean.RoleLevel displayThreshold, BaseResourceBean.RoleLevel modifyThreshold, BaseResourceBean.RoleLevel publishThreshold) {
        FauxProperty fp = new FauxProperty(domainUri, uri, rangeUri);
        fp.setHiddenFromDisplayBelowRoleLevel(displayThreshold);
        fp.setProhibitedFromUpdateBelowRoleLevel(modifyThreshold);
        fp.setHiddenFromPublishBelowRoleLevel(publishThreshold);
        return fp;
    }

    @Test
    public void nullResource_display_false() {
        Assert.assertFalse((boolean)this.bean.canDisplayResource(null, this.highestRole()));
    }

    @Test
    public void anyResource_display_true() {
        Assert.assertTrue((boolean)this.bean.canDisplayResource(URI_RESOURCE_ANY, this.lowestRole()));
    }

    @Test
    public void anyResource_nullUserRole_display_false() {
        Assert.assertFalse((boolean)this.bean.canDisplayResource(URI_RESOURCE_ANY, null));
    }

    @Test
    public void nullResource_modify_false() {
        Assert.assertFalse((boolean)this.bean.canModifyResource(null, this.highestRole()));
    }

    @Test
    public void prohibitedResource_modify_false() {
        Assert.assertFalse((boolean)this.bean.canModifyResource(URI_RESOURCE_PROHIBITED, this.highestRole()));
    }

    @Test
    public void exceptionalResource_modify_true() {
        Assert.assertTrue((boolean)this.bean.canModifyResource(URI_RESOURCE_EXCEPTIONAL, this.lowestRole()));
    }

    @Test
    public void unremarkableResource_modify_true() {
        Assert.assertTrue((boolean)this.bean.canModifyResource(URI_RESOURCE_ANY, this.lowestRole()));
    }

    @Test
    public void unremarkableResource_nullUserRole_modify_false() {
        Assert.assertFalse((boolean)this.bean.canModifyResource(URI_RESOURCE_ANY, null));
    }

    @Test
    public void nullResource_publish_false() {
        Assert.assertFalse((boolean)this.bean.canPublishResource(null, this.highestRole()));
    }

    @Test
    public void anyResource_publish_true() {
        Assert.assertTrue((boolean)this.bean.canPublishResource(URI_RESOURCE_ANY, this.lowestRole()));
    }

    @Test
    public void anyResource_nullUserRole_publish_false() {
        Assert.assertFalse((boolean)this.bean.canPublishResource(URI_RESOURCE_ANY, null));
    }

    @Test
    public void nullPredicate_display_false() {
        Assert.assertFalse((boolean)this.bean.canDisplayPredicate(null, this.highestRole()));
    }

    @Test
    public void barePredicate_display_byRole() {
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate((Property)this.barePredicate, this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY)));
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate((Property)this.barePredicate, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY)));
        Assert.assertFalse((boolean)this.bean.canDisplayPredicate((Property)this.barePredicate, this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY)));
    }

    @Test
    public void unknownBarePredicate_display_true() {
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate((Property)this.unknownPredicate, this.lowestRole()));
    }

    @Test
    public void emptyQualifiedPredicate_display_byBareRole() {
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate(this.asProperty(this.emptyFaux), this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY)));
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate(this.asProperty(this.emptyFaux), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY)));
        Assert.assertFalse((boolean)this.bean.canDisplayPredicate(this.asProperty(this.emptyFaux), this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY)));
    }

    @Test
    public void restrictedQualifiedPredicate_display_byRole() {
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate(this.asProperty(this.restrictedFaux), this.higherRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.DISPLAY)));
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate(this.asProperty(this.restrictedFaux), this.sameRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.DISPLAY)));
        Assert.assertFalse((boolean)this.bean.canDisplayPredicate(this.asProperty(this.restrictedFaux), this.lowerRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.DISPLAY)));
    }

    @Test
    public void unknownQualifiedPredicate_display_true() {
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate(this.asProperty(this.unknownFaux), this.lowestRole()));
    }

    @Test
    public void nullPredicate_modify_false() {
        Assert.assertFalse((boolean)this.bean.canModifyPredicate(null, this.highestRole()));
    }

    @Test
    public void prohibitedPredicate_modify_false() {
        Assert.assertFalse((boolean)this.bean.canModifyPredicate((Property)this.prohibitedPredicate, this.lowestRole()));
    }

    @Test
    public void exceptionalPredicate_modify_byRole() {
        Assert.assertTrue((boolean)this.bean.canModifyPredicate((Property)this.exceptionalPredicate, this.higherRole((RoleRestrictedProperty)this.exceptionalPredicate, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertTrue((boolean)this.bean.canModifyPredicate((Property)this.exceptionalPredicate, this.sameRole((RoleRestrictedProperty)this.exceptionalPredicate, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertFalse((boolean)this.bean.canModifyPredicate((Property)this.exceptionalPredicate, this.lowerRole((RoleRestrictedProperty)this.exceptionalPredicate, PropertyRestrictionLevels.Which.MODIFY)));
    }

    @Test
    public void barePredicate_modify_byRole() {
        Assert.assertTrue((boolean)this.bean.canModifyPredicate((Property)this.barePredicate, this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertTrue((boolean)this.bean.canModifyPredicate((Property)this.barePredicate, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertFalse((boolean)this.bean.canModifyPredicate((Property)this.barePredicate, this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY)));
    }

    @Test
    public void unknownBarePredicate_modify_true() {
        Assert.assertTrue((boolean)this.bean.canModifyPredicate((Property)this.unknownPredicate, this.lowestRole()));
    }

    @Test
    public void emptyQualifiedPredicate_modify_byBareRole() {
        Assert.assertTrue((boolean)this.bean.canModifyPredicate(this.asProperty(this.emptyFaux), this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertTrue((boolean)this.bean.canModifyPredicate(this.asProperty(this.emptyFaux), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertFalse((boolean)this.bean.canModifyPredicate(this.asProperty(this.emptyFaux), this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY)));
    }

    @Test
    public void restrictedQualifiedPredicate_modify_byRole() {
        Assert.assertTrue((boolean)this.bean.canModifyPredicate(this.asProperty(this.restrictedFaux), this.higherRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertTrue((boolean)this.bean.canModifyPredicate(this.asProperty(this.restrictedFaux), this.sameRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.MODIFY)));
        Assert.assertFalse((boolean)this.bean.canModifyPredicate(this.asProperty(this.restrictedFaux), this.lowerRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.MODIFY)));
    }

    @Test
    public void unknownQualifiedPredicate_modify_true() {
        Assert.assertTrue((boolean)this.bean.canModifyPredicate(this.asProperty(this.unknownFaux), this.lowestRole()));
    }

    @Test
    public void nullPredicate_publish_false() {
        Assert.assertFalse((boolean)this.bean.canPublishPredicate(null, this.highestRole()));
    }

    @Test
    public void barePredicate_publish_byRole() {
        Assert.assertTrue((boolean)this.bean.canPublishPredicate((Property)this.barePredicate, this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertTrue((boolean)this.bean.canPublishPredicate((Property)this.barePredicate, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertFalse((boolean)this.bean.canPublishPredicate((Property)this.barePredicate, this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
    }

    @Test
    public void unknownBarePredicate_publish_true() {
        Assert.assertTrue((boolean)this.bean.canPublishPredicate((Property)this.unknownPredicate, this.lowestRole()));
    }

    @Test
    public void emptyQualifiedPredicate_publish_byBareRole() {
        Assert.assertTrue((boolean)this.bean.canPublishPredicate(this.asProperty(this.emptyFaux), this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertTrue((boolean)this.bean.canPublishPredicate(this.asProperty(this.emptyFaux), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertFalse((boolean)this.bean.canPublishPredicate(this.asProperty(this.emptyFaux), this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
    }

    @Test
    public void restrictedQualifiedPredicate_publish_byRole() {
        Assert.assertTrue((boolean)this.bean.canPublishPredicate(this.asProperty(this.restrictedFaux), this.higherRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertTrue((boolean)this.bean.canPublishPredicate(this.asProperty(this.restrictedFaux), this.sameRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertFalse((boolean)this.bean.canPublishPredicate(this.asProperty(this.restrictedFaux), this.lowerRole((RoleRestrictedProperty)this.restrictedFaux, PropertyRestrictionLevels.Which.PUBLISH)));
    }

    @Test
    public void unknownQualifiedPredicate_publish_true() {
        Assert.assertTrue((boolean)this.bean.canPublishPredicate(this.asProperty(this.unknownFaux), this.lowestRole()));
    }

    @Test
    public void updateToAllowDisplay() {
        BaseResourceBean.RoleLevel desiredDisplayLevel = this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY);
        Assert.assertFalse((boolean)this.bean.canDisplayPredicate((Property)this.barePredicate, desiredDisplayLevel));
        this.bean.updateProperty(this.updatedLevels((RoleRestrictedProperty)this.barePredicate, desiredDisplayLevel, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate((Property)this.barePredicate, desiredDisplayLevel));
    }

    @Test
    public void updateToAllowModify() {
        BaseResourceBean.RoleLevel desiredModifyLevel = this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY);
        Assert.assertFalse((boolean)this.bean.canModifyPredicate((Property)this.barePredicate, desiredModifyLevel));
        this.bean.updateProperty(this.updatedLevels((RoleRestrictedProperty)this.barePredicate, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY), desiredModifyLevel, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertTrue((boolean)this.bean.canModifyPredicate((Property)this.barePredicate, desiredModifyLevel));
    }

    @Test
    public void updateToAllowPublish() {
        BaseResourceBean.RoleLevel desiredPublishLevel = this.lowerRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH);
        Assert.assertFalse((boolean)this.bean.canPublishPredicate((Property)this.barePredicate, desiredPublishLevel));
        this.bean.updateProperty(this.updatedLevels((RoleRestrictedProperty)this.barePredicate, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY), desiredPublishLevel));
        Assert.assertTrue((boolean)this.bean.canPublishPredicate((Property)this.barePredicate, desiredPublishLevel));
    }

    @Test
    public void updateToDisallowDisplay() {
        BaseResourceBean.RoleLevel desiredDisplayLevel = this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY);
        Assert.assertTrue((boolean)this.bean.canDisplayPredicate((Property)this.barePredicate, desiredDisplayLevel));
        this.bean.updateProperty(this.updatedLevels((RoleRestrictedProperty)this.barePredicate, this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertFalse((boolean)this.bean.canDisplayPredicate((Property)this.barePredicate, desiredDisplayLevel));
    }

    @Test
    public void updateToDisallowModify() {
        BaseResourceBean.RoleLevel desiredModifyLevel = this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY);
        Assert.assertTrue((boolean)this.bean.canModifyPredicate((Property)this.barePredicate, desiredModifyLevel));
        this.bean.updateProperty(this.updatedLevels((RoleRestrictedProperty)this.barePredicate, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY), this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertFalse((boolean)this.bean.canModifyPredicate((Property)this.barePredicate, desiredModifyLevel));
    }

    @Test
    public void updateToDisallowPublish() {
        BaseResourceBean.RoleLevel desiredPublishLevel = this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH);
        Assert.assertTrue((boolean)this.bean.canPublishPredicate((Property)this.barePredicate, desiredPublishLevel));
        this.bean.updateProperty(this.updatedLevels((RoleRestrictedProperty)this.barePredicate, this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.DISPLAY), this.sameRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.MODIFY), this.higherRole((RoleRestrictedProperty)this.barePredicate, PropertyRestrictionLevels.Which.PUBLISH)));
        Assert.assertFalse((boolean)this.bean.canPublishPredicate((Property)this.barePredicate, desiredPublishLevel));
    }

    private BaseResourceBean.RoleLevel lowestRole() {
        return BaseResourceBean.RoleLevel.values()[0];
    }

    private BaseResourceBean.RoleLevel highestRole() {
        BaseResourceBean.RoleLevel[] values = BaseResourceBean.RoleLevel.values();
        return values[values.length - 1];
    }

    private BaseResourceBean.RoleLevel sameRole(RoleRestrictedProperty p, PropertyRestrictionLevels.Which which) {
        switch (which) {
            case DISPLAY: {
                return p.getHiddenFromDisplayBelowRoleLevel();
            }
            case MODIFY: {
                return p.getProhibitedFromUpdateBelowRoleLevel();
            }
        }
        return p.getHiddenFromPublishBelowRoleLevel();
    }

    private BaseResourceBean.RoleLevel lowerRole(RoleRestrictedProperty p, PropertyRestrictionLevels.Which which) {
        return BaseResourceBean.RoleLevel.values()[this.sameRole(p, which).ordinal() - 1];
    }

    private BaseResourceBean.RoleLevel higherRole(RoleRestrictedProperty p, PropertyRestrictionLevels.Which which) {
        return BaseResourceBean.RoleLevel.values()[this.sameRole(p, which).ordinal() + 1];
    }

    private Property asProperty(FauxProperty fp) {
        Property p = new Property();
        p.setURI(fp.getBaseURI());
        p.setDomainVClassURI(fp.getDomainURI());
        p.setRangeVClassURI(fp.getRangeURI());
        return p;
    }

    private PropertyRestrictionLevels updatedLevels(RoleRestrictedProperty p, BaseResourceBean.RoleLevel displayLevel, BaseResourceBean.RoleLevel modifyLevel, BaseResourceBean.RoleLevel publishLevel) {
        return new PropertyRestrictionLevels(new PropertyDao.FullPropertyKey(p), displayLevel, modifyLevel, publishLevel);
    }
}

