/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiExecutor;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SparqlQueryApiExecutorTest
extends AbstractTestClass {
    private static final String ACCEPT_TEXT = "text/plain";
    private static final String ACCEPT_CSV = "text/csv";
    private static final String ACCEPT_TSV = "text/tab-separated-values";
    private static final String ACCEPT_SPARQL_XML = "application/sparql-results+xml";
    private static final String ACCEPT_SPARQL_JSON = "application/sparql-results+json";
    private static final String ACCEPT_RDFXML = "application/rdf+xml";
    private static final String ACCEPT_N3 = "text/n3";
    private static final String ACCEPT_TURTLE = "text/turtle";
    private static final String ACCEPT_JSON = "application/json";
    private static final String MODEL_CONTENTS_N3 = "<http://here.edu/subject> \n    <http://here.edu/predicate> <http://here.edu/object> .<http://here.edu/s2> \n    <http://here.edu/p2> <http://here.edu/o2> .";
    private static final String BASE_URI = "http://here.edu";
    private static final String SELECT_ALL_QUERY = "SELECT ?s ?p ?o WHERE {?s ?p ?o} ORDER BY DESC(?s)";
    private static final String SELECT_RESULT_TEXT = "--------------------------------------------------------------------------------------\n| s                         | p                           | o                        |\n======================================================================================\n| <http://here.edu/subject> | <http://here.edu/predicate> | <http://here.edu/object> |\n| <http://here.edu/s2>      | <http://here.edu/p2>        | <http://here.edu/o2>     |\n--------------------------------------------------------------------------------------\n";
    private static final String SELECT_RESULT_CSV = "s,p,o\nhttp://here.edu/subject,http://here.edu/predicate,http://here.edu/object\nhttp://here.edu/s2,http://here.edu/p2,http://here.edu/o2\n";
    private static final String SELECT_RESULT_TSV = "s\tp\to\nhttp://here.edu/subject\thttp://here.edu/predicate\thttp://here.edu/object\nhttp://here.edu/s2\thttp://here.edu/p2\thttp://here.edu/o2\n";
    private static final String SELECT_RESULT_XML = "<?xml version=\"1.0\"?>\n<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\">\n  <head>\n    <variable name=\"s\"/>\n    <variable name=\"p\"/>\n    <variable name=\"o\"/>\n  </head>\n  <results>\n    <result>\n      <binding name=\"s\">\n        <uri>http://here.edu/subject</uri>\n      </binding>\n      <binding name=\"p\">\n        <uri>http://here.edu/predicate</uri>\n      </binding>\n      <binding name=\"o\">\n        <uri>http://here.edu/object</uri>\n      </binding>\n    </result>\n    <result>\n      <binding name=\"s\">\n        <uri>http://here.edu/s2</uri>\n      </binding>\n      <binding name=\"p\">\n        <uri>http://here.edu/p2</uri>\n      </binding>\n      <binding name=\"o\">\n        <uri>http://here.edu/o2</uri>\n      </binding>\n    </result>\n  </results>\n</sparql>\n";
    private static final String SELECT_RESULT_JSON = "{\n  \"head\": {\n    \"vars\": [ \"s\" , \"p\" , \"o\" ]\n  } ,\n  \"results\": {\n    \"bindings\": [\n      {\n        \"s\": { \"type\": \"uri\" , \"value\": \"http://here.edu/subject\" } ,\n        \"p\": { \"type\": \"uri\" , \"value\": \"http://here.edu/predicate\" } ,\n        \"o\": { \"type\": \"uri\" , \"value\": \"http://here.edu/object\" }\n      } ,\n      {\n        \"s\": { \"type\": \"uri\" , \"value\": \"http://here.edu/s2\" } ,\n        \"p\": { \"type\": \"uri\" , \"value\": \"http://here.edu/p2\" } ,\n        \"o\": { \"type\": \"uri\" , \"value\": \"http://here.edu/o2\" }\n      }\n    ]\n  }\n}\n";
    private static final String ASK_ALL_QUERY = "ASK WHERE {?s ?p ?o}";
    private static final String ASK_RESULT_TEXT = "true";
    private static final String ASK_RESULT_CSV = "true";
    private static final String ASK_RESULT_TSV = "true";
    private static final String ASK_RESULT_XML = "<?xml version=\"1.0\"?>\n<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\">\n  <head></head>\n  <boolean>true</boolean>\n</sparql>";
    private static final String ASK_RESULT_JSON = "{\n  \"head\" : { } ,\n  \"boolean\" : true\n}\n";
    private static final String CONSTRUCT_ALL_QUERY = "CONSTRUCT {?s ?p ?o} WHERE { LET (?s := <http://here.edu/subject>) <http://here.edu/subject> ?p ?o}";
    private static final String CONSTRUCT_RESULT_TEXT = "<http://here.edu/subject> <http://here.edu/predicate> <http://here.edu/object> .\n";
    private static final String CONSTRUCT_RESULT_TURTLE = "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n";
    private static final String CONSTRUCT_RESULT_N3 = "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n";
    private static final String CONSTRUCT_RESULT_RDFXML = "<rdf:RDF\n    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n    xmlns:j.0=\"http://here.edu/\"\n    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" > \n  <rdf:Description rdf:about=\"http://here.edu/subject\">\n    <j.0:predicate rdf:resource=\"http://here.edu/object\"/>\n  </rdf:Description>\n</rdf:RDF>\n";
    private static final String CONSTRUCT_RESULT_JSONLD = "{\n  \"@id\" : \"http://here.edu/subject\",\n  \"predicate\" : \"http://here.edu/object\",\n  \"@context\" : {\n    \"predicate\" : {\n      \"@id\" : \"http://here.edu/predicate\",\n      \"@type\" : \"@id\"\n    },\n    \"rdf\" : \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\",\n    \"owl\" : \"http://www.w3.org/2002/07/owl#\",\n    \"xsd\" : \"http://www.w3.org/2001/XMLSchema#\",\n    \"rdfs\" : \"http://www.w3.org/2000/01/rdf-schema#\"\n  }\n}\n";
    private static final String DESCRIBE_ALL_QUERY = "DESCRIBE <http://here.edu/subject>";
    private static final String DESCRIBE_RESULT_TEXT = "<http://here.edu/subject> <http://here.edu/predicate> <http://here.edu/object> .\n";
    private static final String DESCRIBE_RESULT_RDFXML = "<rdf:RDF\n    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n    xmlns:j.0=\"http://here.edu/\"\n    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" > \n  <rdf:Description rdf:about=\"http://here.edu/subject\">\n    <j.0:predicate rdf:resource=\"http://here.edu/object\"/>\n  </rdf:Description>\n</rdf:RDF>\n";
    private static final String DESCRIBE_RESULT_N3 = "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n";
    private static final String DESCRIBE_RESULT_TURTLE = "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n";
    private static final String DESCRIBE_RESULT_JSONLD = "{\n  \"@id\" : \"http://here.edu/subject\",\n  \"predicate\" : \"http://here.edu/object\",\n  \"@context\" : {\n    \"predicate\" : {\n      \"@id\" : \"http://here.edu/predicate\",\n      \"@type\" : \"@id\"\n    },\n    \"rdf\" : \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\",\n    \"owl\" : \"http://www.w3.org/2002/07/owl#\",\n    \"xsd\" : \"http://www.w3.org/2001/XMLSchema#\",\n    \"rdfs\" : \"http://www.w3.org/2000/01/rdf-schema#\"\n  }\n}\n";
    private OntModel model;
    private RDFService rdfService;

    @Before
    public void setup() {
        this.model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        this.model.read((Reader)new StringReader(MODEL_CONTENTS_N3), BASE_URI, "N3");
        this.rdfService = new RDFServiceModel((Model)this.model);
    }

    @Test(expected=NullPointerException.class)
    public void nullRdfService() throws Exception {
        SparqlQueryApiExecutor.instance(null, (String)SELECT_ALL_QUERY, (String)ACCEPT_TEXT);
    }

    @Test(expected=NullPointerException.class)
    public void nullQuery() throws Exception {
        SparqlQueryApiExecutor.instance((RDFService)this.rdfService, null, (String)ACCEPT_TEXT);
        Assert.fail((String)"nullQuery not implemented");
    }

    @Test(expected=QueryParseException.class)
    public void emptyQuery() throws Exception {
        SparqlQueryApiExecutor.instance((RDFService)this.rdfService, (String)"", (String)ACCEPT_TEXT);
        Assert.fail((String)"emptyQuery not implemented");
    }

    @Test(expected=QueryParseException.class)
    public void cantParseQuery() throws Exception {
        SparqlQueryApiExecutor.instance((RDFService)this.rdfService, (String)"BOGUS", (String)ACCEPT_TEXT);
        Assert.fail((String)"cantParseQuery not implemented");
    }

    @Test(expected=NotAcceptableException.class)
    public void noAcceptableContentType() throws Exception {
        SparqlQueryApiExecutor.instance((RDFService)this.rdfService, (String)SELECT_ALL_QUERY, (String)"bogus");
        Assert.fail((String)"noAcceptableContentType not implemented");
    }

    @Test
    public void selectToText() throws Exception {
        this.executeQuery("select to text", SELECT_ALL_QUERY, ACCEPT_TEXT, SELECT_RESULT_TEXT);
    }

    @Test
    public void selectToCsv() throws Exception {
        this.executeQuery("select to csv", SELECT_ALL_QUERY, ACCEPT_CSV, SELECT_RESULT_CSV);
    }

    @Test
    public void selectToTsv() throws Exception {
        this.executeQuery("select to tsv", SELECT_ALL_QUERY, ACCEPT_TSV, SELECT_RESULT_TSV);
    }

    @Test
    public void selectToXml() throws Exception {
        this.executeQuery("select to xml", SELECT_ALL_QUERY, ACCEPT_SPARQL_XML, SELECT_RESULT_XML);
    }

    @Test
    public void selectToJson() throws Exception {
        this.executeQuery("select to json", SELECT_ALL_QUERY, ACCEPT_SPARQL_JSON, SELECT_RESULT_JSON);
    }

    @Test
    public void selectWithInvalidContentType() throws Exception {
        this.executeWithInvalidAcceptHeader("select with application/rdf+xml", SELECT_ALL_QUERY, ACCEPT_RDFXML);
        this.executeWithInvalidAcceptHeader("select with text/n3", SELECT_ALL_QUERY, ACCEPT_N3);
        this.executeWithInvalidAcceptHeader("select with text/turtle", SELECT_ALL_QUERY, ACCEPT_TURTLE);
        this.executeWithInvalidAcceptHeader("select with application/json", SELECT_ALL_QUERY, ACCEPT_JSON);
    }

    @Test
    public void askToText() throws Exception {
        this.executeQuery("ask to text", ASK_ALL_QUERY, ACCEPT_TEXT, "true");
    }

    @Test
    public void askToCsv() throws Exception {
        this.executeQuery("ask to csv", ASK_ALL_QUERY, ACCEPT_CSV, "true");
    }

    @Test
    public void askToTsv() throws Exception {
        this.executeQuery("ask to tsv", ASK_ALL_QUERY, ACCEPT_TSV, "true");
    }

    @Test
    public void askToXml() throws Exception {
        this.executeQuery("ask to xml", ASK_ALL_QUERY, ACCEPT_SPARQL_XML, ASK_RESULT_XML);
    }

    @Test
    public void askToJson() throws Exception {
        this.executeQuery("ask to json", ASK_ALL_QUERY, ACCEPT_SPARQL_JSON, ASK_RESULT_JSON);
    }

    @Test
    public void askWithInvalidAcceptHeader() throws Exception {
        this.executeWithInvalidAcceptHeader("ask with application/rdf+xml", ASK_ALL_QUERY, ACCEPT_RDFXML);
        this.executeWithInvalidAcceptHeader("ask with text/n3", ASK_ALL_QUERY, ACCEPT_N3);
        this.executeWithInvalidAcceptHeader("ask with text/turtle", ASK_ALL_QUERY, ACCEPT_TURTLE);
        this.executeWithInvalidAcceptHeader("ask with application/json", ASK_ALL_QUERY, ACCEPT_JSON);
    }

    @Test
    public void constructToText() throws Exception {
        this.executeQuery("construct to text", CONSTRUCT_ALL_QUERY, ACCEPT_TEXT, "<http://here.edu/subject> <http://here.edu/predicate> <http://here.edu/object> .\n");
    }

    @Test
    public void constructToRdfXml() throws Exception {
        this.executeQuery("construct to rdf/xml", CONSTRUCT_ALL_QUERY, ACCEPT_RDFXML, "<rdf:RDF\n    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n    xmlns:j.0=\"http://here.edu/\"\n    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" > \n  <rdf:Description rdf:about=\"http://here.edu/subject\">\n    <j.0:predicate rdf:resource=\"http://here.edu/object\"/>\n  </rdf:Description>\n</rdf:RDF>\n");
    }

    @Test
    public void constructToN3() throws Exception {
        this.executeQuery("construct to n3", CONSTRUCT_ALL_QUERY, ACCEPT_N3, "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n");
    }

    @Test
    public void constructToTurtle() throws Exception {
        this.executeQuery("construct to turtle", CONSTRUCT_ALL_QUERY, ACCEPT_TURTLE, "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n");
    }

    @Test
    public void constructToJsonld() throws Exception {
        this.executeQuery("construct to JSON-LD", CONSTRUCT_ALL_QUERY, ACCEPT_JSON, "{\n  \"@id\" : \"http://here.edu/subject\",\n  \"predicate\" : \"http://here.edu/object\",\n  \"@context\" : {\n    \"predicate\" : {\n      \"@id\" : \"http://here.edu/predicate\",\n      \"@type\" : \"@id\"\n    },\n    \"rdf\" : \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\",\n    \"owl\" : \"http://www.w3.org/2002/07/owl#\",\n    \"xsd\" : \"http://www.w3.org/2001/XMLSchema#\",\n    \"rdfs\" : \"http://www.w3.org/2000/01/rdf-schema#\"\n  }\n}\n");
    }

    @Test
    public void constructWithInvalidAcceptHeader() throws Exception {
        this.executeWithInvalidAcceptHeader("construct with text/csv", CONSTRUCT_ALL_QUERY, ACCEPT_CSV);
        this.executeWithInvalidAcceptHeader("construct with text/tsv", CONSTRUCT_ALL_QUERY, "text/tsv");
        this.executeWithInvalidAcceptHeader("construct with application/sparql-results+xml", CONSTRUCT_ALL_QUERY, ACCEPT_SPARQL_XML);
        this.executeWithInvalidAcceptHeader("construct with application/sparql-results+json", CONSTRUCT_ALL_QUERY, ACCEPT_SPARQL_JSON);
    }

    @Test
    public void describeToText() throws Exception {
        this.executeQuery("describe to text", DESCRIBE_ALL_QUERY, ACCEPT_TEXT, "<http://here.edu/subject> <http://here.edu/predicate> <http://here.edu/object> .\n");
    }

    @Test
    public void describeToRdfXml() throws Exception {
        this.executeQuery("describe to rdf/xml", DESCRIBE_ALL_QUERY, ACCEPT_RDFXML, "<rdf:RDF\n    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n    xmlns:j.0=\"http://here.edu/\"\n    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" > \n  <rdf:Description rdf:about=\"http://here.edu/subject\">\n    <j.0:predicate rdf:resource=\"http://here.edu/object\"/>\n  </rdf:Description>\n</rdf:RDF>\n");
    }

    @Test
    public void describeToN3() throws Exception {
        this.executeQuery("describe to n3", DESCRIBE_ALL_QUERY, ACCEPT_N3, "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n");
    }

    @Test
    public void describeToTurtle() throws Exception {
        this.executeQuery("describe to turtle", DESCRIBE_ALL_QUERY, ACCEPT_TURTLE, "@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n\n<http://here.edu/subject>\n      <http://here.edu/predicate>\n              <http://here.edu/object> .\n");
    }

    @Test
    public void describeToJsonld() throws Exception {
        this.executeQuery("describe to JSON-LD", DESCRIBE_ALL_QUERY, ACCEPT_JSON, "{\n  \"@id\" : \"http://here.edu/subject\",\n  \"predicate\" : \"http://here.edu/object\",\n  \"@context\" : {\n    \"predicate\" : {\n      \"@id\" : \"http://here.edu/predicate\",\n      \"@type\" : \"@id\"\n    },\n    \"rdf\" : \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\",\n    \"owl\" : \"http://www.w3.org/2002/07/owl#\",\n    \"xsd\" : \"http://www.w3.org/2001/XMLSchema#\",\n    \"rdfs\" : \"http://www.w3.org/2000/01/rdf-schema#\"\n  }\n}\n");
    }

    @Test
    public void describeWithInvalidAcceptHeader() throws Exception {
        this.executeWithInvalidAcceptHeader("describe with text/csv", DESCRIBE_ALL_QUERY, ACCEPT_CSV);
        this.executeWithInvalidAcceptHeader("describe with text/tsv", DESCRIBE_ALL_QUERY, "text/tsv");
        this.executeWithInvalidAcceptHeader("describe with application/sparql-results+xml", DESCRIBE_ALL_QUERY, ACCEPT_SPARQL_XML);
        this.executeWithInvalidAcceptHeader("describe with application/sparql-results+json", DESCRIBE_ALL_QUERY, ACCEPT_SPARQL_JSON);
    }

    private void executeQuery(String message, String queryString, String acceptHeader, String expected) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SparqlQueryApiExecutor executor = SparqlQueryApiExecutor.instance((RDFService)this.rdfService, (String)queryString, (String)acceptHeader);
        executor.executeAndFormat((OutputStream)out);
        if (ACCEPT_RDFXML.equals(acceptHeader)) {
            this.assertEquivalentRdfxml(message, expected, out.toString());
        } else if (ACCEPT_TURTLE.equals(acceptHeader)) {
            this.assertEquivalentTurtle(message, expected, out.toString());
        } else if (ACCEPT_N3.equals(acceptHeader)) {
            this.assertEquivalentN3(message, expected, out.toString());
        } else if (ACCEPT_JSON.equals(acceptHeader)) {
            this.assertEquivalentJSON(message, expected, out.toString());
        } else {
            this.assertEqualsIgnoreWhiteSpace(message, expected, out.toString());
        }
    }

    private void assertEquivalentRdfxml(String message, String expected, String actual) {
        Assert.assertEquals((String)message, this.getRdfxmlNamespaces(expected), this.getRdfxmlNamespaces(actual));
        this.assertEqualsIgnoreWhiteSpace(message, this.omitRdfxmlNamespaces(expected), this.omitRdfxmlNamespaces(actual));
    }

    private Set<String> getRdfxmlNamespaces(String rdfxml) {
        TreeSet<String> namespaces = new TreeSet<String>();
        Pattern p = Pattern.compile("xmlns:\\w+=\\\"[^\\\"]*\\\"");
        Matcher m = p.matcher(rdfxml);
        while (m.find()) {
            namespaces.add(m.group());
        }
        return namespaces;
    }

    private String omitRdfxmlNamespaces(String rdfxml) {
        return rdfxml.replaceAll("xmlns:\\w+=\\\"[^\\\"]*\\\"", "");
    }

    private void assertEquivalentTurtle(String message, String expected, String actual) {
        Assert.assertEquals((String)message, this.getTurtlePrefixes(expected), this.getTurtlePrefixes(actual));
        this.assertEqualsIgnoreWhiteSpace(message, this.getTurtleRemainder(expected), this.getTurtleRemainder(actual));
    }

    private void assertEquivalentN3(String message, String expected, String actual) {
        this.assertEquivalentTurtle(message, expected, actual);
    }

    private Set<String> getTurtlePrefixes(String ttl) {
        TreeSet<String> prefixes = new TreeSet<String>();
        for (String line : ttl.split("[\\n\\r]+")) {
            if (!line.startsWith("@prefix")) continue;
            prefixes.add(line.replaceAll("\\s+", " "));
        }
        return prefixes;
    }

    private String getTurtleRemainder(String ttl) {
        ArrayList<String> remainder = new ArrayList<String>();
        for (String line : ttl.split("[\\n\\r]+")) {
            if (line.startsWith("@prefix")) continue;
            remainder.add(line);
        }
        return StringUtils.join(remainder, (String)"\n");
    }

    private void assertEquivalentJSON(String message, String expected, String actual) {
        ObjectMapper om = new ObjectMapper();
        try {
            Map expMap = (Map)om.readValue(expected, Map.class);
            Map actMap = (Map)om.readValue(actual, Map.class);
            Assert.assertEquals((String)message, (Object)expMap, (Object)actMap);
        }
        catch (IOException e) {
            Assert.assertEquals((String)message, (Object)expected.replaceAll("\\s+", " "), (Object)actual.replaceAll("\\s+", " "));
        }
    }

    private void assertEqualsIgnoreWhiteSpace(String message, String expected, String actual) {
        Assert.assertEquals((String)message, (Object)expected.replaceAll("\\s+", " "), (Object)actual.replaceAll("\\s+", " "));
    }

    private void executeWithInvalidAcceptHeader(String message, String queryString, String acceptHeader) throws Exception {
        try {
            SparqlQueryApiExecutor.instance((RDFService)this.rdfService, (String)queryString, (String)acceptHeader);
            Assert.fail((String)(message + " - Expected a NotAcceptableException"));
        }
        catch (NotAcceptableException notAcceptableException) {
            // empty catch block
        }
    }
}

