/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.dao.NewURIMakerVitro;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class NewURIMakerVitroTest
extends AbstractTestClass {
    @Test
    public void testMultipleNewURIs() {
        HashMap newResources = new HashMap();
        newResources.put("page", null);
        newResources.put("menuItem", null);
        newResources.put("dataGetter", null);
        WebappDaoFactoryJena wadf = this.setupWebappDaoFactory();
        NewURIMakerVitro nv = new NewURIMakerVitro((WebappDaoFactory)wadf);
        HashMap<String, String> varToNewURIs = new HashMap<String, String>();
        try {
            for (String key : newResources.keySet()) {
                String prefix = (String)newResources.get(key);
                String uri = nv.getUnusedNewURI(prefix);
                varToNewURIs.put(key, uri);
            }
        }
        catch (Exception ex) {
            System.out.println("Error occurred " + ex);
        }
        ArrayList values = new ArrayList(varToNewURIs.values());
        HashSet valuesSet = new HashSet(varToNewURIs.values());
        Assert.assertTrue((valuesSet.size() == values.size() ? 1 : 0) != 0);
    }

    @Test
    public void testNonNullNamespace() {
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("page", "http://displayOntology/test/n12");
        WebappDaoFactoryJena wadf = this.setupWebappDaoFactory();
        NewURIMakerVitro nv = new NewURIMakerVitro((WebappDaoFactory)wadf);
        HashMap<String, String> varToNewURIs = new HashMap<String, String>();
        try {
            for (String key : newResources.keySet()) {
                String prefix = (String)newResources.get(key);
                String uri = nv.getUnusedNewURI(prefix);
                varToNewURIs.put(key, uri);
            }
        }
        catch (Exception ex) {
            System.out.println("Error occurred " + ex);
        }
        ArrayList values = new ArrayList(varToNewURIs.values());
        HashSet valuesSet = new HashSet(varToNewURIs.values());
        Assert.assertTrue((valuesSet.size() == values.size() ? 1 : 0) != 0);
    }

    private WebappDaoFactoryJena setupWebappDaoFactory() {
        String defaultNamespace = "http://vivo.mannlib.cornell.edu/individual/";
        String testNamespace = "http://displayOntology/test/";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ontModel.add(ontModel.createResource(defaultNamespace + "n234"), RDF.type, (RDFNode)OWL.Thing);
        ontModel.add(ontModel.createResource(testNamespace + "n234"), RDF.type, (RDFNode)OWL.Thing);
        SimpleOntModelSelector selector = new SimpleOntModelSelector(ontModel);
        WebappDaoFactoryConfig config = new WebappDaoFactoryConfig();
        config.setDefaultNamespace(defaultNamespace);
        WebappDaoFactoryJena wadf = new WebappDaoFactoryJena((OntModelSelector)selector, config);
        return wadf;
    }
}

