/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.processEdit;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.RdfLiteralHash;
import org.junit.Assert;
import org.junit.Test;

public class RdfLiteralHashTest {
    final String TEST_VALUE = "this is a test literal string";
    final String TEST_DATA_PROP_URI = "http://this.is.a.test.uri.com/1999/02/blec-ns#test2332";
    final String TEST_INDIVIDUAL_URI = "http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878";
    final String TEST_DATA_TYPE_URI = "http://this.is.a.uri.com/TEST/DATA/TYPE#e8";
    final String TEST_LANG = "ENG";

    @Test
    public void testEdBackground() {
        String value = "[CELE97] Waldemar Celes and Jonathan Corson-Rikert. &quot;Act: An Easy-to-use and Dynamically Extensible 3D Graphics Library&quot; in Proceedings, Brazilian Symposium on Computer Graphics and Image Processing, Campos do Jordao, SP -Brazil, October, 1997.";
        String propUri = "http://vivo.library.cornell.edu/ns/0.1#publications";
        String subject = "http://vivo.library.cornell.edu/ns/0.1#individual22972";
        String datatypeUri = null;
        String language = null;
        DataPropertyStatementImpl stmt = new DataPropertyStatementImpl();
        stmt.setIndividualURI(subject);
        stmt.setData(value);
        stmt.setDatapropURI(propUri);
        stmt.setDatatypeURI(datatypeUri);
        stmt.setLanguage(language);
        int hash = RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmt);
        Assert.assertTrue((hash != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1646037091L, (long)hash);
    }

    @Test
    public void testMakeRdfLiteralHash() {
        DataPropertyStatementImpl stmt = new DataPropertyStatementImpl();
        stmt.setData("this is a test literal string");
        stmt.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmt.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        int hash = RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmt);
        Assert.assertTrue((hash != 0 ? 1 : 0) != 0);
        stmt = new DataPropertyStatementImpl();
        stmt.setData("this is a test literal string");
        stmt.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmt.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        stmt.setDatatypeURI("http://this.is.a.uri.com/TEST/DATA/TYPE#e8");
        hash = RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmt);
        Assert.assertTrue((hash != 0 ? 1 : 0) != 0);
        stmt = new DataPropertyStatementImpl();
        stmt.setData("this is a test literal string");
        stmt.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmt.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        stmt.setLanguage("ENG");
        hash = RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmt);
        Assert.assertTrue((hash != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoesStmtMatchHash() {
        DataPropertyStatementImpl stmtA = new DataPropertyStatementImpl();
        DataPropertyStatementImpl stmtB = new DataPropertyStatementImpl();
        int expectedHash = 0;
        stmtA.setData("this is a test literal string");
        stmtA.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmtA.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        expectedHash = RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmtA);
        stmtB.setData("this is a test literal string");
        stmtB.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmtB.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        Assert.assertTrue((expectedHash == RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmtB) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)RdfLiteralHash.doesStmtMatchHash((DataPropertyStatement)stmtB, (int)expectedHash));
        stmtA = new DataPropertyStatementImpl();
        stmtA.setData("this is a test literal string");
        stmtA.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmtA.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        stmtA.setDatatypeURI("http://this.is.a.uri.com/TEST/DATA/TYPE#e8");
        expectedHash = RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmtA);
        stmtB = new DataPropertyStatementImpl();
        stmtB.setData("this is a test literal string");
        stmtB.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmtB.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        stmtB.setDatatypeURI("http://this.is.a.uri.com/TEST/DATA/TYPE#e8");
        Assert.assertTrue((expectedHash == RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmtB) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)RdfLiteralHash.doesStmtMatchHash((DataPropertyStatement)stmtB, (int)expectedHash));
        stmtA = new DataPropertyStatementImpl();
        stmtA.setData("this is a test literal string");
        stmtA.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmtA.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        stmtA.setLanguage("ENG");
        expectedHash = RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmtA);
        stmtB = new DataPropertyStatementImpl();
        stmtB.setData("this is a test literal string");
        stmtB.setDatapropURI("http://this.is.a.test.uri.com/1999/02/blec-ns#test2332");
        stmtB.setIndividualURI("http://this.is.a.testUri.com/1999/02/bleck-ns#INDIVIDUAL787878");
        stmtB.setLanguage("ENG");
        Assert.assertTrue((expectedHash == RdfLiteralHash.makeRdfLiteralHash((DataPropertyStatement)stmtB) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)RdfLiteralHash.doesStmtMatchHash((DataPropertyStatement)stmtB, (int)expectedHash));
        Assert.assertTrue((!RdfLiteralHash.doesStmtMatchHash(null, (int)expectedHash) ? 1 : 0) != 0);
    }
}

