/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vitro.webapp.filters.URLRewritingHttpServletResponse;
import edu.cornell.mannlib.vitro.webapp.utils.NamespaceMapper;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.junit.Assert;
import org.junit.Test;
import stubs.javax.servlet.http.HttpServletResponseStub;

public class URLRewritingHttpServletResponseTest {
    protected void urlEncodingStyleA(String urlToEncode, String expectedUrlResult) {
        URLRewritingHttpServletResponse urhsr = new URLRewritingHttpServletResponse((HttpServletResponse)new HttpServletResponseStub());
        ArrayList<String> externalNamespaces = new ArrayList<String>();
        externalNamespaces.add("http://vivo.med.cornell.edu/individual/");
        String actual = urhsr.encodeForVitro(urlToEncode, "UTF-8", Boolean.valueOf(true), 1, this.getMockNamespaceMapper(), "http://vivo.cornell.edu/individual/", externalNamespaces);
        Assert.assertEquals((Object)expectedUrlResult, (Object)actual);
    }

    protected void urlEncodingStyleB(String urlToEncode, String expectedUrlResult) {
        URLRewritingHttpServletResponse urhsr = new URLRewritingHttpServletResponse((HttpServletResponse)new HttpServletResponseStub());
        ArrayList<String> externalNamespaces = new ArrayList<String>();
        externalNamespaces.add("http://vivo.med.cornell.edu/individual/");
        String actual = urhsr.encodeForVitro(urlToEncode, "UTF-8", Boolean.valueOf(true), 0, this.getMockNamespaceMapper(), "http://vivo.cornell.edu/individual/", externalNamespaces);
        Assert.assertEquals((Object)expectedUrlResult, (Object)actual);
    }

    @Test
    public void test40984() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test40988() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/getURLParam.js", "/vivo/js/jquery_plugins/getURLParam.js");
    }

    @Test
    public void test40994() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/colorAnimations.js", "/vivo/js/jquery_plugins/colorAnimations.js");
    }

    @Test
    public void test40995() {
        this.urlEncodingStyleA("/vivo/js/propertyGroupSwitcher.js", "/vivo/js/propertyGroupSwitcher.js");
    }

    @Test
    public void test40996() {
        this.urlEncodingStyleA("/vivo/js/controls.js", "/vivo/js/controls.js");
    }

    @Test
    public void test40999() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.form.js", "/vivo/js/jquery_plugins/jquery.form.js");
    }

    @Test
    public void test41004() {
        this.urlEncodingStyleA("/vivo/js/tiny_mce/tiny_mce.js", "/vivo/js/tiny_mce/tiny_mce.js");
    }

    @Test
    public void test41133() {
        this.urlEncodingStyleA("/vivo/entityEdit?uri=http%3a%2f%2fbogus.com%2findividual%2fn3671", "/vivo/entityEdit?uri=http%3A%2F%2Fbogus.com%2Findividual%2Fn3671");
    }

    @Test
    public void test41464() {
        this.urlEncodingStyleA("/vivo/themes/vivo-basic/site_icons/visualization/ajax-loader.gif", "/vivo/themes/vivo-basic/site_icons/visualization/ajax-loader.gif");
    }

    @Test
    public void test41465() {
        this.urlEncodingStyleA("/vivo/visualization?render_mode=dynamic&container=vis_container&vis=person_pub_count&vis_mode=short&uri=http%3a%2f%2fbogus.com%2findividual%2fn3671", "/vivo/visualization?render_mode=dynamic&container=vis_container&vis=person_pub_count&vis_mode=short&uri=http%3A%2F%2Fbogus.com%2Findividual%2Fn3671");
    }

    @Test
    public void test42110() {
        this.urlEncodingStyleA("/vivo/js/imageUpload/imageUploadUtils.js", "/vivo/js/imageUpload/imageUploadUtils.js");
    }

    @Test
    public void test57982() {
        this.urlEncodingStyleA("entityEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fAgent", "entityEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FAgent");
    }

    @Test
    public void test57983() {
        this.urlEncodingStyleA("/vivo/vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fAgent", "/vivo/vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FAgent");
    }

    @Test
    public void test57986() {
        this.urlEncodingStyleA("entityEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fPerson", "entityEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FPerson");
    }

    @Test
    public void test57987() {
        this.urlEncodingStyleA("/vivo/vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fPerson", "/vivo/vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FPerson");
    }

    @Test
    public void test57988() {
        this.urlEncodingStyleA("entityEdit?uri=http%3a%2f%2fwww.w3.org%2f2002%2f07%2fowl%23Thing", "entityEdit?uri=http%3A%2F%2Fwww.w3.org%2F2002%2F07%2Fowl%23Thing");
    }

    @Test
    public void test57989() {
        this.urlEncodingStyleA("/vivo/vclassEdit?uri=http%3a%2f%2fwww.w3.org%2f2002%2f07%2fowl%23Thing", "/vivo/vclassEdit?uri=http%3A%2F%2Fwww.w3.org%2F2002%2F07%2Fowl%23Thing");
    }

    @Test
    public void test42083() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23Address", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23Address");
    }

    @Test
    public void test42084() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23DateTimeInterval", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23DateTimeInterval");
    }

    @Test
    public void test42085() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23URLLink", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23URLLink");
    }

    @Test
    public void test42086() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23AcademicDegree", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23AcademicDegree");
    }

    @Test
    public void test42087() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fpurl.org%2fontology%2fbibo%2fDocumentStatus", "vclassEdit?uri=http%3A%2F%2Fpurl.org%2Fontology%2Fbibo%2FDocumentStatus");
    }

    @Test
    public void test42088() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23DateTimeValuePrecision", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23DateTimeValuePrecision");
    }

    @Test
    public void test42089() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23DateTimeValue", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23DateTimeValue");
    }

    @Test
    public void test42090() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23Award", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23Award");
    }

    @Test
    public void test42091() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23Authorship", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23Authorship");
    }

    @Test
    public void test48256() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fPerson", "vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FPerson");
    }

    @Test
    public void test11309() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7df6", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7df6");
    }

    @Test
    public void test11310() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7e02", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7e02");
    }

    @Test
    public void test11311() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7e09", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7e09");
    }

    @Test
    public void test11312() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7df5", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7df5");
    }

    @Test
    public void test11313() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7df4", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7df4");
    }

    @Test
    public void test11314() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7df9", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7df9");
    }

    @Test
    public void test11315() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7df8", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7df8");
    }

    @Test
    public void test11317() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-43882498%3a12c1825c819%3a-7df7", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-43882498%3A12c1825c819%3A-7df7");
    }

    @Test
    public void test11318() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fAgent", "vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FAgent");
    }

    @Test
    public void test11319() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23Librarian", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23Librarian");
    }

    @Test
    public void test11320() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23Student", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23Student");
    }

    @Test
    public void test11321() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23NonAcademic", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23NonAcademic");
    }

    @Test
    public void test11322() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23NonFacultyAcademic", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23NonFacultyAcademic");
    }

    @Test
    public void test113222() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23FacultyMember", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23FacultyMember");
    }

    @Test
    public void test11323() {
        this.urlEncodingStyleA("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23EmeritusProfessor", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23EmeritusProfessor");
    }

    @Test
    public void test53543() {
        this.urlEncodingStyleA("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-2", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-2");
    }

    @Test
    public void test53549() {
        this.urlEncodingStyleA("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-inf", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-inf");
    }

    @Test
    public void test53555() {
        this.urlEncodingStyleA("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-userAccounts", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-userAccounts");
    }

    @Test
    public void test53557() {
        this.urlEncodingStyleA("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-displayMetadata", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-displayMetadata");
    }

    @Test
    public void test391499() {
        this.urlEncodingStyleA("/vivo/edit/forms/css/customForm.css", "/vivo/edit/forms/css/customForm.css");
    }

    @Test
    public void test39149() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox.css", "/vivo/js/jquery_plugins/thickbox/thickbox.css");
    }

    @Test
    public void test39153() {
        this.urlEncodingStyleA("/vivo/edit/processRdfForm2.jsp", "/vivo/edit/processRdfForm2.jsp");
    }

    @Test
    public void test39472() {
        this.urlEncodingStyleA("/vivo/js/extensions/String.js", "/vivo/js/extensions/String.js");
    }

    @Test
    public void test394730() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test39473() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.bgiframe.pack.js", "/vivo/js/jquery_plugins/jquery.bgiframe.pack.js");
    }

    @Test
    public void test39474() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js", "/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js");
    }

    @Test
    public void test39475() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/ui.datepicker.js", "/vivo/js/jquery_plugins/ui.datepicker.js");
    }

    @Test
    public void test14958() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test14968() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/getURLParam.js", "/vivo/js/jquery_plugins/getURLParam.js");
    }

    @Test
    public void test14972() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/colorAnimations.js", "/vivo/js/jquery_plugins/colorAnimations.js");
    }

    @Test
    public void test14979() {
        this.urlEncodingStyleA("/vivo/js/propertyGroupSwitcher.js", "/vivo/js/propertyGroupSwitcher.js");
    }

    @Test
    public void test14980() {
        this.urlEncodingStyleA("/vivo/js/controls.js", "/vivo/js/controls.js");
    }

    @Test
    public void test14982() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.form.js", "/vivo/js/jquery_plugins/jquery.form.js");
    }

    @Test
    public void test14986() {
        this.urlEncodingStyleA("/vivo/js/tiny_mce/tiny_mce.js", "/vivo/js/tiny_mce/tiny_mce.js");
    }

    @Test
    public void test14999() {
        this.urlEncodingStyleA("/vivo/entityEdit?uri=http%3a%2f%2fbogus.com%2findividual%2fn3671", "/vivo/entityEdit?uri=http%3A%2F%2Fbogus.com%2Findividual%2Fn3671");
    }

    @Test
    public void test15011() {
        this.urlEncodingStyleA("/vivo/themes/vivo-basic/site_icons/visualization/ajax-loader.gif", "/vivo/themes/vivo-basic/site_icons/visualization/ajax-loader.gif");
    }

    @Test
    public void test15014() {
        this.urlEncodingStyleA("/vivo/visualization?render_mode=dynamic&container=vis_container&vis=person_pub_count&vis_mode=short&uri=http%3a%2f%2fbogus.com%2findividual%2fn3671", "/vivo/visualization?render_mode=dynamic&container=vis_container&vis=person_pub_count&vis_mode=short&uri=http%3A%2F%2Fbogus.com%2Findividual%2Fn3671");
    }

    @Test
    public void test15143() {
        this.urlEncodingStyleA("/vivo/js/imageUpload/imageUploadUtils.js", "/vivo/js/imageUpload/imageUploadUtils.js");
    }

    @Test
    public void test184670() {
        this.urlEncodingStyleA("/vivo/js/jquery-ui/css/smoothness/jquery-ui-1.12.1.css", "/vivo/js/jquery-ui/css/smoothness/jquery-ui-1.12.1.css");
    }

    @Test
    public void test18467() {
        this.urlEncodingStyleA("/vivo/edit/forms/css/customForm.css", "/vivo/edit/forms/css/customForm.css");
    }

    @Test
    public void test184680() {
        this.urlEncodingStyleA("/vivo/edit/forms/css/customFormWithAutocomplete.css", "/vivo/edit/forms/css/customFormWithAutocomplete.css");
    }

    @Test
    public void test18468() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox.css", "/vivo/js/jquery_plugins/thickbox/thickbox.css");
    }

    @Test
    public void test18472() {
        this.urlEncodingStyleA("/vivo/edit/processRdfForm2.jsp", "/vivo/edit/processRdfForm2.jsp");
    }

    @Test
    public void test18506() {
        this.urlEncodingStyleA("/vivo/individual?uri=", "/vivo/individual?uri=");
    }

    @Test
    public void test18512() {
        this.urlEncodingStyleA("/vivo/autocomplete?tokenize=true&stem=true", "/vivo/autocomplete?tokenize=true&stem=true");
    }

    @Test
    public void test18516() {
        this.urlEncodingStyleA("/vivo/js/extensions/String.js", "/vivo/js/extensions/String.js");
    }

    @Test
    public void test18543() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test185440() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.bgiframe.pack.js", "/vivo/js/jquery_plugins/jquery.bgiframe.pack.js");
    }

    @Test
    public void test18544() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js", "/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js");
    }

    @Test
    public void test18545() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/ui.datepicker.js", "/vivo/js/jquery_plugins/ui.datepicker.js");
    }

    @Test
    public void test18546() {
        this.urlEncodingStyleA("/vivo/js/jquery-ui/js/jquery-ui-1.12.1.min.js", "/vivo/js/jquery-ui/js/jquery-ui-1.12.1.min.js");
    }

    @Test
    public void test185470() {
        this.urlEncodingStyleA("/vivo/js/customFormUtils.js", "/vivo/js/customFormUtils.js");
    }

    @Test
    public void test18547() {
        this.urlEncodingStyleA("/vivo/edit/forms/js/customFormWithAutocomplete.js", "/vivo/edit/forms/js/customFormWithAutocomplete.js");
    }

    @Test
    public void test27127() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox.css", "/vivo/js/jquery_plugins/thickbox/thickbox.css");
    }

    @Test
    public void test27130() {
        this.urlEncodingStyleA("/vivo/edit/processDatapropRdfForm.jsp", "/vivo/edit/processDatapropRdfForm.jsp");
    }

    @Test
    public void test271590() {
        this.urlEncodingStyleA("/vivo/js/extensions/String.js", "/vivo/js/extensions/String.js");
    }

    @Test
    public void test27159() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test27160() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.bgiframe.pack.js", "/vivo/js/jquery_plugins/jquery.bgiframe.pack.js");
    }

    @Test
    public void test27161() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js", "/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js");
    }

    @Test
    public void test27166() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/ui.datepicker.js", "/vivo/js/jquery_plugins/ui.datepicker.js");
    }

    @Test
    public void test14842() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox.css", "/vivo/js/jquery_plugins/thickbox/thickbox.css");
    }

    @Test
    public void test14846() {
        this.urlEncodingStyleA("/vivo/edit/processDatapropRdfForm.jsp", "/vivo/edit/processDatapropRdfForm.jsp");
    }

    @Test
    public void test148510() {
        this.urlEncodingStyleA("/vivo/js/extensions/String.js", "/vivo/js/extensions/String.js");
    }

    @Test
    public void test14851() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test14852() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.bgiframe.pack.js", "/vivo/js/jquery_plugins/jquery.bgiframe.pack.js");
    }

    @Test
    public void test148530() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js", "/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js");
    }

    @Test
    public void test14853() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/ui.datepicker.js", "/vivo/js/jquery_plugins/ui.datepicker.js");
    }

    @Test
    public void test43748() {
        this.urlEncodingStyleA("/vivo/js/jquery-ui/css/smoothness/jquery-ui-1.12.1.css", "/vivo/js/jquery-ui/css/smoothness/jquery-ui-1.12.1.css");
    }

    @Test
    public void test43749() {
        this.urlEncodingStyleA("/vivo/edit/forms/css/customForm.css", "/vivo/edit/forms/css/customForm.css");
    }

    @Test
    public void test437500() {
        this.urlEncodingStyleA("/vivo/edit/forms/css/customFormWithAutocomplete.css", "/vivo/edit/forms/css/customFormWithAutocomplete.css");
    }

    @Test
    public void test43750() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox.css", "/vivo/js/jquery_plugins/thickbox/thickbox.css");
    }

    @Test
    public void test437540() {
        this.urlEncodingStyleA("/vivo/edit/processRdfForm2.jsp", "/vivo/edit/processRdfForm2.jsp");
    }

    @Test
    public void test43754() {
        this.urlEncodingStyleA("/vivo/individual?uri=", "/vivo/individual?uri=");
    }

    @Test
    public void test43757() {
        this.urlEncodingStyleA("/vivo/autocomplete?tokenize=true&stem=true", "/vivo/autocomplete?tokenize=true&stem=true");
    }

    @Test
    public void test43760() {
        this.urlEncodingStyleA("/vivo/js/extensions/String.js", "/vivo/js/extensions/String.js");
    }

    @Test
    public void test437610() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test43761() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.bgiframe.pack.js", "/vivo/js/jquery_plugins/jquery.bgiframe.pack.js");
    }

    @Test
    public void test43762() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js", "/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js");
    }

    @Test
    public void test437630() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/ui.datepicker.js", "/vivo/js/jquery_plugins/ui.datepicker.js");
    }

    @Test
    public void test43763() {
        this.urlEncodingStyleA("/vivo/js/jquery-ui/js/jquery-ui-1.12.1.min.js", "/vivo/js/jquery-ui/js/jquery-ui-1.12.1.min.js");
    }

    @Test
    public void test437640() {
        this.urlEncodingStyleA("/vivo/js/customFormUtils.js", "/vivo/js/customFormUtils.js");
    }

    @Test
    public void test43764() {
        this.urlEncodingStyleA("/vivo/edit/forms/js/customFormWithAutocomplete.js", "/vivo/edit/forms/js/customFormWithAutocomplete.js");
    }

    @Test
    public void test14550() {
        this.urlEncodingStyleA("/vivo/js/jquery-ui/css/smoothness/jquery-ui-1.12.1.css", "/vivo/js/jquery-ui/css/smoothness/jquery-ui-1.12.1.css");
    }

    @Test
    public void test14551() {
        this.urlEncodingStyleA("/vivo/edit/forms/css/customForm.css", "/vivo/edit/forms/css/customForm.css");
    }

    @Test
    public void test1455200() {
        this.urlEncodingStyleA("/vivo/edit/forms/css/customFormWithAutocomplete.css", "/vivo/edit/forms/css/customFormWithAutocomplete.css");
    }

    @Test
    public void test14552() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox.css", "/vivo/js/jquery_plugins/thickbox/thickbox.css");
    }

    @Test
    public void test14556() {
        this.urlEncodingStyleA("/vivo/edit/processRdfForm2.jsp", "/vivo/edit/processRdfForm2.jsp");
    }

    @Test
    public void test14557() {
        this.urlEncodingStyleA("/vivo/individual?uri=", "/vivo/individual?uri=");
    }

    @Test
    public void test145610() {
        this.urlEncodingStyleA("/vivo/autocomplete?tokenize=true&stem=true", "/vivo/autocomplete?tokenize=true&stem=true");
    }

    @Test
    public void test14561() {
        this.urlEncodingStyleA("/vivo/admin/sparqlquery", "/vivo/admin/sparqlquery");
    }

    @Test
    public void test14565() {
        this.urlEncodingStyleA("/vivo/js/extensions/String.js", "/vivo/js/extensions/String.js");
    }

    @Test
    public void test145650() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test145660() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.bgiframe.pack.js", "/vivo/js/jquery_plugins/jquery.bgiframe.pack.js");
    }

    @Test
    public void test14566() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js", "/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js");
    }

    @Test
    public void test14567() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/ui.datepicker.js", "/vivo/js/jquery_plugins/ui.datepicker.js");
    }

    @Test
    public void test145680() {
        this.urlEncodingStyleA("/vivo/js/jquery-ui/js/jquery-ui-1.12.1.min.js", "/vivo/js/jquery-ui/js/jquery-ui-1.12.1.min.js");
    }

    @Test
    public void test14568() {
        this.urlEncodingStyleA("/vivo/js/customFormUtils.js", "/vivo/js/customFormUtils.js");
    }

    @Test
    public void test145690() {
        this.urlEncodingStyleA("/vivo/js/browserUtils.js", "/vivo/js/browserUtils.js");
    }

    @Test
    public void test14569() {
        this.urlEncodingStyleA("/vivo/edit/forms/js/customFormWithAutocomplete.js", "/vivo/edit/forms/js/customFormWithAutocomplete.js");
    }

    @Test
    public void test29078() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox.css", "/vivo/js/jquery_plugins/thickbox/thickbox.css");
    }

    @Test
    public void test29081() {
        this.urlEncodingStyleA("/vivo/edit/processDatapropRdfForm.jsp", "/vivo/edit/processDatapropRdfForm.jsp");
    }

    @Test
    public void test29084() {
        this.urlEncodingStyleA("/vivo/js/extensions/String.js", "/vivo/js/extensions/String.js");
    }

    @Test
    public void test29085() {
        this.urlEncodingStyleA("/vivo/js/jquery-1.12.4.min.js", "/vivo/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test290860() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/jquery.bgiframe.pack.js", "/vivo/js/jquery_plugins/jquery.bgiframe.pack.js");
    }

    @Test
    public void test29086() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js", "/vivo/js/jquery_plugins/thickbox/thickbox-compressed.js");
    }

    @Test
    public void test29087() {
        this.urlEncodingStyleA("/vivo/js/jquery_plugins/ui.datepicker.js", "/vivo/js/jquery_plugins/ui.datepicker.js");
    }

    @Test
    public void test35560() {
        this.urlEncodingStyleB("/js/jquery-1.12.4.min.js", "/js/jquery-1.12.4.min.js");
    }

    @Test
    public void test35562() {
        this.urlEncodingStyleB("/js/jquery_plugins/getURLParam.js", "/js/jquery_plugins/getURLParam.js");
    }

    @Test
    public void test35564() {
        this.urlEncodingStyleB("/js/jquery_plugins/colorAnimations.js", "/js/jquery_plugins/colorAnimations.js");
    }

    @Test
    public void test35568() {
        this.urlEncodingStyleB("/js/propertyGroupSwitcher.js", "/js/propertyGroupSwitcher.js");
    }

    @Test
    public void test35617() {
        this.urlEncodingStyleB("/js/controls.js", "/js/controls.js");
    }

    @Test
    public void test35618() {
        this.urlEncodingStyleB("/js/jquery_plugins/jquery.form.js", "/js/jquery_plugins/jquery.form.js");
    }

    @Test
    public void test356180() {
        this.urlEncodingStyleB("/js/tiny_mce/tiny_mce.js", "/js/tiny_mce/tiny_mce.js");
    }

    @Test
    public void test37150() {
        this.urlEncodingStyleB("/entityEdit?uri=http%3a%2f%2fbogus.com%2findividual%2fn3671", "/entityEdit?uri=http%3A%2F%2Fbogus.com%2Findividual%2Fn3671");
    }

    @Test
    public void test37402() {
        this.urlEncodingStyleB("/themes/vivo-basic/site_icons/visualization/ajax-loader.gif", "/themes/vivo-basic/site_icons/visualization/ajax-loader.gif");
    }

    @Test
    public void test37403() {
        this.urlEncodingStyleB("/visualization?render_mode=dynamic&container=vis_container&vis=person_pub_count&vis_mode=short&uri=http%3a%2f%2fbogus.com%2findividual%2fn3671", "/visualization?render_mode=dynamic&container=vis_container&vis=person_pub_count&vis_mode=short&uri=http%3A%2F%2Fbogus.com%2Findividual%2Fn3671");
    }

    @Test
    public void test38667() {
        this.urlEncodingStyleB("/js/imageUpload/imageUploadUtils.js", "/js/imageUpload/imageUploadUtils.js");
    }

    @Test
    public void test47087() {
        this.urlEncodingStyleB("entityEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fAgent", "entityEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FAgent");
    }

    @Test
    public void test47088() {
        this.urlEncodingStyleB("/vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fAgent", "/vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FAgent");
    }

    @Test
    public void test470910() {
        this.urlEncodingStyleB("entityEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fPerson", "entityEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FPerson");
    }

    @Test
    public void test47091() {
        this.urlEncodingStyleB("/vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fPerson", "/vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FPerson");
    }

    @Test
    public void test470930() {
        this.urlEncodingStyleB("entityEdit?uri=http%3a%2f%2fwww.w3.org%2f2002%2f07%2fowl%23Thing", "entityEdit?uri=http%3A%2F%2Fwww.w3.org%2F2002%2F07%2Fowl%23Thing");
    }

    @Test
    public void test47093() {
        this.urlEncodingStyleB("/vclassEdit?uri=http%3a%2f%2fwww.w3.org%2f2002%2f07%2fowl%23Thing", "/vclassEdit?uri=http%3A%2F%2Fwww.w3.org%2F2002%2F07%2Fowl%23Thing");
    }

    @Test
    public void test04993() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7d2e", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7d2e");
    }

    @Test
    public void test04994() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7dad", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7dad");
    }

    @Test
    public void test04995() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7d31", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7d31");
    }

    @Test
    public void test04996() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7db7", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7db7");
    }

    @Test
    public void test04997() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7df2", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7df2");
    }

    @Test
    public void test04999() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fOrganization", "vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FOrganization");
    }

    @Test
    public void test05000() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fPerson", "vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FPerson");
    }

    @Test
    public void test13898() {
        this.urlEncodingStyleB("entityEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fvitro%2fpublic%23File", "entityEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fvitro%2Fpublic%23File");
    }

    @Test
    public void test13899() {
        this.urlEncodingStyleB("/vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fvitro%2fpublic%23File", "/vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fvitro%2Fpublic%23File");
    }

    @Test
    public void test28454() {
        this.urlEncodingStyleB("entityEdit?uri=http%3a%2f%2fwww.w3.org%2f2002%2f07%2fowl%23Thing", "entityEdit?uri=http%3A%2F%2Fwww.w3.org%2F2002%2F07%2Fowl%23Thing");
    }

    @Test
    public void test28458() {
        this.urlEncodingStyleB("/vclassEdit?uri=http%3a%2f%2fwww.w3.org%2f2002%2f07%2fowl%23Thing", "/vclassEdit?uri=http%3A%2F%2Fwww.w3.org%2F2002%2F07%2Fowl%23Thing");
    }

    @Test
    public void test38687() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7d75", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7d75");
    }

    @Test
    public void test38693() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7d76", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7d76");
    }

    @Test
    public void test38694() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23AbstractInformation", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23AbstractInformation");
    }

    @Test
    public void test38695() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvitro.mannlib.cornell.edu%2fns%2fbnode%23-20981c46%3a12c18866689%3a-7d77", "vclassEdit?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fns%2Fbnode%23-20981c46%3A12c18866689%3A-7d77");
    }

    @Test
    public void test38696() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fpurl.org%2fontology%2fbibo%2fThesisDegree", "vclassEdit?uri=http%3A%2F%2Fpurl.org%2Fontology%2Fbibo%2FThesisDegree");
    }

    @Test
    public void test43123() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fxmlns.com%2ffoaf%2f0.1%2fPerson", "vclassEdit?uri=http%3A%2F%2Fxmlns.com%2Ffoaf%2F0.1%2FPerson");
    }

    @Test
    public void test43124() {
        this.urlEncodingStyleB("vclassEdit?uri=http%3a%2f%2fvivoweb.org%2fontology%2fcore%23Postdoc", "vclassEdit?uri=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23Postdoc");
    }

    @Test
    public void test59983() {
        this.urlEncodingStyleB("propertyEdit?uri=http%3a%2f%2fpurl.org%2fdc%2fterms%2fcontributor", "propertyEdit?uri=http%3A%2F%2Fpurl.org%2Fdc%2Fterms%2Fcontributor");
    }

    @Test
    public void test17004() {
        this.urlEncodingStyleB("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-2", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-2");
    }

    @Test
    public void test17017() {
        this.urlEncodingStyleB("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-inf", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-inf");
    }

    @Test
    public void test17021() {
        this.urlEncodingStyleB("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-userAccounts", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-userAccounts");
    }

    @Test
    public void test17033() {
        this.urlEncodingStyleB("ingest?action=outputModel&modelName=http%3a%2f%2fvitro.mannlib.cornell.edu%2fdefault%2fvitro-kb-displayMetadata", "ingest?action=outputModel&modelName=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fdefault%2Fvitro-kb-displayMetadata");
    }

    public NamespaceMapper getMockNamespaceMapper() {
        return new NamespaceMapper(){

            public void removedStatements(Model arg0) {
            }

            public void removedStatements(StmtIterator arg0) {
            }

            public void removedStatements(List<Statement> arg0) {
            }

            public void removedStatements(Statement[] arg0) {
            }

            public void removedStatement(Statement arg0) {
            }

            public void notifyEvent(Model arg0, Object arg1) {
            }

            public void addedStatements(Model arg0) {
            }

            public void addedStatements(StmtIterator arg0) {
            }

            public void addedStatements(List<Statement> arg0) {
            }

            public void addedStatements(Statement[] arg0) {
            }

            public void addedStatement(Statement arg0) {
            }

            public List<String> getPrefixesForNamespace(String namespace) {
                return null;
            }

            public String getPrefixForNamespace(String namespace) {
                return null;
            }

            public String getNamespaceForPrefix(String prefix) {
                return null;
            }
        };
    }
}

