/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderTestBase;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationBeanLoader_NamespacesTest
extends ConfigurationBeanLoaderTestBase {
    @Test
    public void possibleForJavaLangString() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("java:java.lang.String");
        expected.add("java:java#lang.String");
        expected.add("java:java.lang#String");
        Assert.assertEquals(expected, (Object)ConfigurationBeanLoader.toPossibleJavaUris(String.class));
    }

    @Test
    public void loadAllForJavaUtilRandom() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://noPound", "java:java.util.Random"));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://firstPound", "java:java#util.Random"));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://secondPound", "java:java.util#Random"));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://notARandom", "java:java.util.Set"));
        Set instances = this.loader.loadAll(Random.class);
        Assert.assertEquals((long)3L, (long)instances.size());
    }

    @Test
    public void loadAlForCustomInnerClass() throws ConfigurationBeanLoaderException {
        Set typeUris = ConfigurationBeanLoader.toPossibleJavaUris(ExampleClassForLoadAll.class);
        for (String typeUri : typeUris) {
            this.model.add(ModelUtilitiesTestHelper.typeStatement("http://testUri" + this.model.size(), typeUri));
        }
        Set instances = this.loader.loadAll(ExampleClassForLoadAll.class);
        Assert.assertEquals((long)typeUris.size(), (long)instances.size());
    }

    @Test
    public void loadInstanceVariationsForJavaUtilRandom() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://noPound", "java:java.util.Random"));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://firstPound", "java:java#util.Random"));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://secondPound", "java:java.util#Random"));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://notARandom", "java:java.util.Set"));
        Assert.assertNotNull((Object)this.loader.loadInstance("http://noPound", Random.class));
        Assert.assertNotNull((Object)this.loader.loadInstance("http://firstPound", Random.class));
        Assert.assertNotNull((Object)this.loader.loadInstance("http://secondPound", Random.class));
        try {
            this.loader.loadInstance("http://notARandom", Random.class);
            Assert.fail((String)"Should not be a Random");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void loadInstanceVariationsForCustomInnerClass() throws ConfigurationBeanLoaderException {
        Set typeUris = ConfigurationBeanLoader.toPossibleJavaUris(ExampleClassForLoadInstance.class);
        for (String typeUri : typeUris) {
            this.model.add(ModelUtilitiesTestHelper.typeStatement("http://testUri" + this.model.size(), typeUri));
        }
        int i = 0;
        while ((long)i < this.model.size()) {
            String instanceUri = "http://testUri" + i;
            Assert.assertNotNull((String)("No instance for " + instanceUri), (Object)this.loader.loadInstance(instanceUri, ExampleClassForLoadInstance.class));
            ++i;
        }
    }

    public static class ExampleClassForLoadInstance {
    }

    public static class ExampleClassForLoadAll {
    }
}

