/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ActiveIdentifierBundleFactories;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RequestIdentifiers {
    private static final String ATTRIBUTE_ID_BUNDLE = RequestIdentifiers.class.getName();

    public static IdentifierBundle getIdBundleForRequest(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return new ArrayIdentifierBundle(new Identifier[0]);
        }
        HttpServletRequest hreq = (HttpServletRequest)request;
        Object obj = hreq.getAttribute(ATTRIBUTE_ID_BUNDLE);
        if (obj == null) {
            obj = ActiveIdentifierBundleFactories.getIdentifierBundle(hreq);
            hreq.setAttribute(ATTRIBUTE_ID_BUNDLE, obj);
        }
        if (!(obj instanceof IdentifierBundle)) {
            throw new IllegalStateException("Expected to find an instance of " + IdentifierBundle.class.getName() + " in the request, but found an instance of " + obj.getClass().getName() + " instead.");
        }
        return (IdentifierBundle)obj;
    }

    public static void resetIdentifiers(ServletRequest request) {
        request.removeAttribute(ATTRIBUTE_ID_BUNDLE);
    }
}

