/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsAddPage;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;

public abstract class UserAccountsAddPageStrategy
extends UserAccountsPage {
    protected final UserAccountsAddPage page;

    public static UserAccountsAddPageStrategy getInstance(VitroRequest vreq, UserAccountsAddPage page, boolean emailEnabled) {
        if (emailEnabled) {
            return new EmailStrategy(vreq, page);
        }
        return new NoEmailStrategy(vreq, page);
    }

    public UserAccountsAddPageStrategy(VitroRequest vreq, UserAccountsAddPage page) {
        super(vreq);
        this.page = page;
    }

    protected abstract void parseAdditionalParameters();

    protected abstract String additionalValidations();

    protected abstract void addMoreBodyValues(Map<String, Object> var1);

    protected abstract void setAdditionalProperties(UserAccount var1);

    protected abstract void notifyUser();

    protected abstract boolean wasPasswordEmailSent();

    private static class NoEmailStrategy
    extends UserAccountsAddPageStrategy {
        private static final String PARAMETER_INITIAL_PASSWORD = "initialPassword";
        private static final String PARAMETER_CONFIRM_PASSWORD = "confirmPassword";
        private static final String ERROR_NO_PASSWORD = "errorPasswordIsEmpty";
        private static final String ERROR_WRONG_PASSWORD_LENGTH = "errorPasswordIsWrongLength";
        private static final String ERROR_PASSWORDS_DONT_MATCH = "errorPasswordsDontMatch";
        private String initialPassword;
        private String confirmPassword;

        public NoEmailStrategy(VitroRequest vreq, UserAccountsAddPage page) {
            super(vreq, page);
        }

        @Override
        protected void parseAdditionalParameters() {
            this.initialPassword = this.getStringParameter(PARAMETER_INITIAL_PASSWORD, "");
            this.confirmPassword = this.getStringParameter(PARAMETER_CONFIRM_PASSWORD, "");
        }

        @Override
        protected String additionalValidations() {
            if (this.page.isExternalAuthOnly()) {
                return "";
            }
            if (this.initialPassword.isEmpty()) {
                return ERROR_NO_PASSWORD;
            }
            if (!this.checkPasswordLength()) {
                return ERROR_WRONG_PASSWORD_LENGTH;
            }
            if (!this.initialPassword.equals(this.confirmPassword)) {
                return ERROR_PASSWORDS_DONT_MATCH;
            }
            return "";
        }

        private boolean checkPasswordLength() {
            return this.initialPassword.length() >= 6 && this.initialPassword.length() <= 12;
        }

        @Override
        protected void addMoreBodyValues(Map<String, Object> body) {
            body.put(PARAMETER_INITIAL_PASSWORD, this.initialPassword);
            body.put(PARAMETER_CONFIRM_PASSWORD, this.confirmPassword);
            body.put("minimumLength", 6);
            body.put("maximumLength", 12);
        }

        @Override
        protected void setAdditionalProperties(UserAccount u) {
            if (!this.page.isExternalAuthOnly()) {
                u.setArgon2Password(Authenticator.applyArgon2iEncoding(this.initialPassword));
                u.setMd5Password("");
                u.setPasswordChangeRequired(true);
            }
            u.setStatus(UserAccount.Status.ACTIVE);
        }

        @Override
        protected void notifyUser() {
        }

        @Override
        protected boolean wasPasswordEmailSent() {
            return false;
        }
    }

    private static class EmailStrategy
    extends UserAccountsAddPageStrategy {
        public static final String CREATE_PASSWORD_URL = "/accounts/createPassword";
        private static final String EMAIL_TEMPLATE_WITH_PASSWORD = "userAccounts-acctCreatedEmail.ftl";
        private static final String EMAIL_TEMPLATE_NO_PASSWORD = "userAccounts-acctCreatedExternalOnlyEmail.ftl";
        private boolean sentEmail;

        public EmailStrategy(VitroRequest vreq, UserAccountsAddPage page) {
            super(vreq, page);
        }

        @Override
        protected void parseAdditionalParameters() {
        }

        @Override
        protected String additionalValidations() {
            return "";
        }

        @Override
        protected void setAdditionalProperties(UserAccount u) {
            if (this.page.isExternalAuthOnly()) {
                u.setPasswordLinkExpires(0L);
                u.setStatus(UserAccount.Status.ACTIVE);
            } else {
                u.setPasswordLinkExpires(this.figureExpirationDate().getTime());
                u.generateEmailKey();
                u.setStatus(UserAccount.Status.INACTIVE);
            }
        }

        @Override
        protected void addMoreBodyValues(Map<String, Object> body) {
            body.put("emailIsEnabled", Boolean.TRUE);
        }

        @Override
        protected void notifyUser() {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("userAccount", this.page.getAddedAccount());
            body.put("passwordLink", this.buildCreatePasswordLink());
            body.put("siteName", this.getSiteName());
            FreemarkerEmailMessage email = FreemarkerEmailFactory.createNewMessage(this.vreq);
            email.addRecipient(Message.RecipientType.TO, this.page.getAddedAccount().getEmailAddress());
            email.setSubject(this.i18n.text("account_created_subject", this.getSiteName()));
            if (this.page.isExternalAuthOnly()) {
                email.setTemplate(EMAIL_TEMPLATE_NO_PASSWORD);
            } else {
                email.setTemplate(EMAIL_TEMPLATE_WITH_PASSWORD);
            }
            email.setBodyMap(body);
            email.processTemplate();
            email.send();
            this.sentEmail = true;
        }

        private String buildCreatePasswordLink() {
            try {
                String email = this.page.getAddedAccount().getEmailAddress();
                String key = this.page.getAddedAccount().getEmailKey();
                String relativeUrl = UrlBuilder.getUrl(CREATE_PASSWORD_URL, "user", email, "key", key);
                URL context = new URL(this.vreq.getRequestURL().toString());
                URL url = new URL(context, relativeUrl);
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                return "error_creating_password_link";
            }
        }

        @Override
        protected boolean wasPasswordEmailSent() {
            return this.sentEmail;
        }
    }
}

