/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering.filters;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFiltersImpl;
import net.sf.jga.fn.UnaryFunctor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HideFromDisplayByPolicyFilter
extends VitroFiltersImpl {
    private static final Log log = LogFactory.getLog(HideFromDisplayByPolicyFilter.class);
    private final IdentifierBundle idBundle;
    private final PolicyIface policy;

    public HideFromDisplayByPolicyFilter(IdentifierBundle idBundle, PolicyIface policy) {
        if (idBundle == null) {
            throw new NullPointerException("idBundle may not be null.");
        }
        if (policy == null) {
            throw new NullPointerException("policy may not be null.");
        }
        this.idBundle = idBundle;
        this.policy = policy;
        this.setDataPropertyFilter(new DataPropertyFilterByPolicy());
        this.setObjectPropertyFilter(new ObjectPropertyFilterByPolicy());
        this.setDataPropertyStatementFilter(new DataPropertyStatementFilterByPolicy());
        this.setObjectPropertyStatementFilter(new ObjectPropertyStatementFilterByPolicy());
    }

    boolean checkAuthorization(RequestedAction whatToAuth) {
        PolicyDecision decision = this.policy.isAuthorized(this.idBundle, whatToAuth);
        log.debug((Object)("decision is " + decision));
        return decision != null && decision.getAuthorized() == Authorization.AUTHORIZED;
    }

    private class ObjectPropertyStatementFilterByPolicy
    extends UnaryFunctor<ObjectPropertyStatement, Boolean> {
        private ObjectPropertyStatementFilterByPolicy() {
        }

        public Boolean fn(ObjectPropertyStatement ops) {
            String subjectUri = ops.getSubjectURI();
            ObjectProperty predicate = this.getOrCreateProperty(ops);
            String objectUri = ops.getObjectURI();
            return HideFromDisplayByPolicyFilter.this.checkAuthorization(new DisplayObjectPropertyStatement(subjectUri, predicate, objectUri));
        }

        private ObjectProperty getOrCreateProperty(ObjectPropertyStatement ops) {
            if (ops.getProperty() != null) {
                return ops.getProperty();
            }
            if (ops.getPropertyURI() == null) {
                return null;
            }
            ObjectProperty op = new ObjectProperty();
            op.setURI(ops.getPropertyURI());
            op.setDomainVClassURI(RequestedAction.SOME_URI);
            op.setRangeVClassURI(RequestedAction.SOME_URI);
            return op;
        }
    }

    private class DataPropertyStatementFilterByPolicy
    extends UnaryFunctor<DataPropertyStatement, Boolean> {
        private DataPropertyStatementFilterByPolicy() {
        }

        public Boolean fn(DataPropertyStatement dps) {
            return HideFromDisplayByPolicyFilter.this.checkAuthorization(new DisplayDataPropertyStatement(dps));
        }
    }

    private class ObjectPropertyFilterByPolicy
    extends UnaryFunctor<ObjectProperty, Boolean> {
        private ObjectPropertyFilterByPolicy() {
        }

        public Boolean fn(ObjectProperty op) {
            return HideFromDisplayByPolicyFilter.this.checkAuthorization(new DisplayObjectProperty(op));
        }
    }

    private class DataPropertyFilterByPolicy
    extends UnaryFunctor<DataProperty, Boolean> {
        private DataPropertyFilterByPolicy() {
        }

        public Boolean fn(DataProperty dp) {
            return HideFromDisplayByPolicyFilter.this.checkAuthorization(new DisplayDataProperty(dp));
        }
    }
}

