/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class RdfLiteralHash {
    private static final Log log = LogFactory.getLog((String)RdfLiteralHash.class.getName());

    public static int makeRdfLiteralHash(DataPropertyStatement stmt) {
        if (stmt.getIndividualURI() == null || stmt.getIndividualURI().trim().length() == 0) {
            throw new Error("Cannot make a hash for a statement with no subject URI");
        }
        if (stmt.getDatapropURI() == null || stmt.getDatapropURI().trim().length() == 0) {
            throw new Error("Cannot make a hash for a statement with no predicate URI");
        }
        String langOrDatatype = "9876NONE";
        if (stmt.getLanguage() != null && stmt.getLanguage().trim().length() > 0) {
            langOrDatatype = stmt.getLanguage();
        } else if (stmt.getDatatypeURI() != null && stmt.getDatatypeURI().trim().length() > 0) {
            langOrDatatype = stmt.getDatatypeURI();
        }
        String hashMe = langOrDatatype + "_" + stmt.getIndividualURI() + "_" + stmt.getDatapropURI() + "_" + stmt.getData();
        if (log.isDebugEnabled()) {
            log.debug((Object)("got hash " + hashMe.hashCode() + " for String '" + hashMe + "'"));
        }
        return hashMe.hashCode();
    }

    public static boolean doesStmtMatchHash(DataPropertyStatement stmt, int hash) {
        int stmtHash;
        if (stmt == null) {
            return false;
        }
        try {
            stmtHash = RdfLiteralHash.makeRdfLiteralHash(stmt);
            log.debug((Object)("incoming hash " + hash + " compared to calculated hash " + stmtHash));
        }
        catch (Throwable th) {
            return false;
        }
        return stmtHash == hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataPropertyStatement getPropertyStmtByHash(String subjectUri, String predicateUri, int hash, Model model) {
        if (subjectUri == null || predicateUri == null) {
            return null;
        }
        model.enterCriticalSection(false);
        StmtIterator stmts = model.listStatements(model.createResource(subjectUri), model.getProperty(predicateUri), (RDFNode)null);
        try {
            while (stmts.hasNext()) {
                DataPropertyStatement dps;
                Statement stmt = stmts.nextStatement();
                RDFNode node = stmt.getObject();
                if (!node.isLiteral() || !RdfLiteralHash.doesStmtMatchHash(dps = RdfLiteralHash.makeDataPropertyStatementFromStatement(stmt, node), hash)) continue;
                DataPropertyStatement dataPropertyStatement = dps;
                return dataPropertyStatement;
            }
            DataPropertyStatement dataPropertyStatement = null;
            return dataPropertyStatement;
        }
        finally {
            stmts.close();
            model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int makeRdfsLabelLiteralHash(Individual subject, String value, Model model) {
        String subjectUri = subject.getURI();
        String predicateUri = "http://www.w3.org/2000/01/rdf-schema#label";
        StmtIterator stmts = model.listStatements(model.createResource(subjectUri), model.getProperty(predicateUri), (RDFNode)null);
        DataPropertyStatement dps = null;
        int hash = 0;
        int count = 0;
        try {
            while (stmts.hasNext()) {
                Statement stmt = stmts.nextStatement();
                RDFNode node = stmt.getObject();
                if (!node.isLiteral()) continue;
                ++count;
                dps = RdfLiteralHash.makeDataPropertyStatementFromStatement(stmt, node);
                hash = RdfLiteralHash.makeRdfLiteralHash(dps);
            }
        }
        finally {
            stmts.close();
        }
        if (count == 1) {
            return hash;
        }
        if (count == 0) {
            log.debug((Object)("No data property statement for subject:" + subjectUri + "\npredicate:" + predicateUri + "\nvalue: " + value));
            throw new IllegalArgumentException("Could not create RdfLiteralHash because there was no data property statement with the given value.");
        }
        log.debug((Object)("Multiple data property statements for subject:" + subjectUri + "\npredicate:" + predicateUri + "\nvalue: " + value));
        throw new IllegalArgumentException("Could not create RdfLiteralHash because there were multiple data property statements with the given value.");
    }

    private static DataPropertyStatement makeDataPropertyStatementFromStatement(Statement statement, RDFNode node) {
        Literal lit = (Literal)node.as(Literal.class);
        String value = lit.getLexicalForm();
        String lang = lit.getLanguage();
        String datatypeUri = lit.getDatatypeURI();
        DataPropertyStatementImpl dps = new DataPropertyStatementImpl();
        dps.setDatatypeURI(datatypeUri);
        dps.setLanguage(lang);
        dps.setData(value);
        dps.setDatapropURI(statement.getPredicate().getURI());
        dps.setIndividualURI(statement.getSubject().getURI());
        return dps;
    }
}

