/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaVClassOptions;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.utils.fields.FieldUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualsViaSearchQueryOptions
extends IndividualsViaVClassOptions
implements FieldOptions {
    private Log log = LogFactory.getLog(IndividualsViaSearchQueryOptions.class);
    private String subjectUri;
    private String predicateUri;
    private String objectUri;

    public IndividualsViaSearchQueryOptions(String inputSubjectUri, String inputPredicateUri, String inputObjectUri, String ... vclassURIs) throws Exception {
        super(vclassURIs);
        this.subjectUri = inputSubjectUri;
        this.predicateUri = inputPredicateUri;
        this.objectUri = inputObjectUri;
    }

    @Override
    protected Map<String, Individual> getIndividualsForClass(String vclassURI, WebappDaoFactory wDaoFact) {
        HashMap<String, Individual> individualMap = new HashMap<String, Individual>();
        try {
            SearchEngine searchEngine = ApplicationUtils.instance().getSearchEngine();
            SearchQuery query = searchEngine.createQuery();
            if ("http://www.w3.org/2002/07/owl#Thing".equals(vclassURI)) {
                query.setQuery("*:*");
            } else {
                query.setQuery("mostSpecificTypeURIs:" + vclassURI);
            }
            query.setStart(0).setRows(1000);
            query.addFields("URI");
            SearchResponse rsp = searchEngine.query(query);
            SearchResultDocumentList docs = rsp.getResults();
            long found = docs.getNumFound();
            if (found > 0L) {
                for (SearchResultDocument doc : docs) {
                    try {
                        String uri = doc.getStringValue("URI");
                        Individual individual = wDaoFact.getIndividualDao().getIndividualByURI(uri);
                        if (individual == null) {
                            this.log.debug((Object)("No individual for search document with uri = " + uri));
                            continue;
                        }
                        individualMap.put(individual.getURI(), individual);
                        this.log.debug((Object)("Adding individual " + uri + " to individual list"));
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"An error occurred retrieving the individual search resutls", (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Error occurred in executing search query ", (Throwable)ex);
        }
        return individualMap;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact, I18nBundle i18n) throws Exception {
        HashMap<String, Individual> individualMap = new HashMap<String, Individual>();
        for (String vclassURI : this.vclassURIs) {
            individualMap.putAll(this.getIndividualsForClass(vclassURI, wDaoFact));
        }
        List<Individual> individuals = new ArrayList<Individual>();
        individuals.addAll(individualMap.values());
        Individual subject = wDaoFact.getIndividualDao().getIndividualByURI(this.subjectUri);
        List<ObjectPropertyStatement> stmts = subject.getObjectPropertyStatements();
        individuals = FieldUtils.removeIndividualsAlreadyInRange(individuals, stmts, this.predicateUri, this.objectUri);
        individuals = this.removeSubjectUri(individuals, this.subjectUri);
        Collections.sort(individuals);
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        if (this.defaultOptionLabel != null) {
            optionsMap.put("", this.defaultOptionLabel);
        }
        if (individuals.size() == 0) {
            return optionsMap;
        }
        for (Individual ind : individuals) {
            if (ind.getURI() == null) continue;
            optionsMap.put(ind.getURI(), ind.getName().trim());
        }
        return optionsMap;
    }

    private List<Individual> removeSubjectUri(List<Individual> individuals, String subjectUri) {
        ListIterator<Individual> it = individuals.listIterator();
        while (it.hasNext()) {
            Individual ind = it.next();
            if (!ind.getURI().equals(subjectUri)) continue;
            it.remove();
        }
        return individuals;
    }
}

