/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputField;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;

public class ESAdder {
    private static final Log log = LogFactory.getLog(ESAdder.class);
    private final String baseUrl;

    public ESAdder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void add(Collection<SearchInputDocument> docs) throws SearchEngineException {
        for (SearchInputDocument doc : docs) {
            this.addDocument(doc);
        }
    }

    private void addDocument(SearchInputDocument doc) throws SearchEngineException {
        try {
            Map<String, List<Object>> map = this.convertDocToMap(doc);
            String json = new ObjectMapper().writeValueAsString(map);
            log.debug((Object)("Adding document for '" + doc.getField("DocId") + "': " + json));
            this.putToElastic(json, (String)doc.getField("DocId").getFirstValue());
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to convert to JSON", e);
        }
    }

    private Map<String, List<Object>> convertDocToMap(SearchInputDocument doc) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (SearchInputField field : doc.getFieldMap().values()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object value : field.getValues()) {
                if (value instanceof Collection) {
                    Collection cValue = (Collection)value;
                    list.addAll(cValue);
                    continue;
                }
                list.add(value);
            }
            map.put(field.getName(), list);
        }
        return map;
    }

    private void putToElastic(String json, String docId) throws SearchEngineException {
        try {
            String url = this.baseUrl + "/_doc/" + URLEncoder.encode(docId, "UTF8");
            Response response = Request.Put((String)url).bodyString(json, ContentType.APPLICATION_JSON).execute();
            log.debug((Object)("Response from Elasticsearch: " + response.returnContent().asString()));
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to put to Elasticsearch", e);
        }
    }
}

