/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.jena;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class ExtendedLinkedDataUtils {
    private static final Log log = LogFactory.getLog((String)ExtendedLinkedDataUtils.class.getName());

    public static Model createModelFromQueries(ServletContext sc, String rootDir, OntModel sourceModel, String subject) {
        log.debug((Object)("Exploring queries in directory '" + rootDir + "'"));
        Model model = ModelFactory.createDefaultModel();
        Set pathSet = sc.getResourcePaths(rootDir);
        if (pathSet == null) {
            log.warn((Object)(rootDir + " not found."));
            return model;
        }
        for (String path : pathSet) {
            File file = new File(sc.getRealPath(path));
            if (file.isDirectory()) {
                model.add(ExtendedLinkedDataUtils.createModelFromQueries(sc, path, sourceModel, subject));
                continue;
            }
            if (file.isFile()) {
                if (!path.endsWith(".sparql")) {
                    log.warn((Object)("Ignoring file " + path + " because the file extension is not sparql."));
                    continue;
                }
                model.add(ExtendedLinkedDataUtils.createModelFromQuery(file, sourceModel, subject));
                log.debug((Object)("model size is " + model.size() + " after query in '" + path + "'"));
                continue;
            }
            log.warn((Object)("path is neither a directory nor a file " + path));
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model createModelFromQuery(File sparqlFile, OntModel sourceModel, String subject) {
        Model model = ModelFactory.createDefaultModel();
        BufferedReader reader = null;
        try {
            try {
                String ln;
                reader = new BufferedReader(new FileReader(sparqlFile));
                StringBuilder fileContents = new StringBuilder();
                while ((ln = reader.readLine()) != null) {
                    fileContents.append(ln).append('\n');
                }
                String query = fileContents.toString();
                String subjectString = "<" + subject + ">";
                query = query.replaceAll("PERSON_URI", subjectString);
                Query q = QueryFactory.create((String)query, (Syntax)Syntax.syntaxARQ);
                QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)sourceModel);
                qe.execConstruct(model);
            }
            catch (Exception e) {
                log.error((Object)("Unable to process file " + sparqlFile.getAbsolutePath()), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ioe) {
            log.warn((Object)("Exception while trying to close file: " + sparqlFile.getAbsolutePath()), (Throwable)ioe);
        }
        return model;
    }
}

