/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.menuManagement;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.ClassGroupPageData;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.menuManagement.ProcessDataGetter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public class ProcessClassGroup
implements ProcessDataGetter {
    private static final Log log = LogFactory.getLog(ProcessClassGroup.class);

    @Override
    public void populateTemplate(HttpServletRequest req, Map<String, Object> pageData, Map<String, Object> templateData) {
        templateData.put("isClassGroupPage", true);
        templateData.put("includeAllClasses", true);
        DataGetterUtils.getClassGroupForDataGetter(req, pageData, templateData);
    }

    @Override
    public Model processSubmission(VitroRequest vreq, Resource dataGetterResource) {
        Model dgModel = ModelFactory.createDefaultModel();
        String dataGetterTypeUri = DataGetterUtils.generateDataGetterTypeURI(ClassGroupPageData.class.getName());
        dgModel.add(dgModel.createStatement(dataGetterResource, RDF.type, (RDFNode)ResourceFactory.createResource((String)dataGetterTypeUri)));
        return dgModel;
    }
}

