/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.jsptags;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang3.StringEscapeUtils;

public class OptionsForClassTag
extends TagSupport {
    private String selectedUri;
    private String classUri;

    public String getClassUri() {
        return this.classUri;
    }

    public void setClassUri(String classUri) {
        this.classUri = classUri;
    }

    public String getSelectedUri() {
        return this.selectedUri;
    }

    public void setSelectedUri(String selectedUri) {
        this.selectedUri = selectedUri;
    }

    public int doStartTag() {
        try {
            VitroRequest vreq = new VitroRequest((HttpServletRequest)this.pageContext.getRequest());
            WebappDaoFactory wdf = vreq.getWebappDaoFactory();
            if (wdf == null) {
                throw new Exception("could not get WebappDaoFactory from request.");
            }
            VClass vclass = wdf.getVClassDao().getVClassByURI(this.getClassUri());
            if (vclass == null) {
                throw new Exception("could not get class for " + this.getClassUri());
            }
            List<Individual> individuals = wdf.getIndividualDao().getIndividualsByVClassURI(vclass.getURI(), -1, -1);
            JspWriter out = this.pageContext.getOut();
            for (Individual ind : individuals) {
                String uri = ind.getURI();
                if (uri == null) continue;
                out.print("<option value=\"" + StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)uri) + '\"');
                if (uri.equals(this.getSelectedUri())) {
                    out.print(" selected=\"selected\"");
                }
                out.print('>');
                out.print(StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)ind.getName()));
                out.println("</option>");
            }
        }
        catch (Exception ex) {
            throw new Error("Error in doStartTag: " + ex.getMessage());
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }
}

