/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListDatatypePropertiesController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.Collator;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.DatatypeDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ListDatatypePropertiesControllerTest
extends ListControllerTestBase {
    private static final String PATH = "datapropEdit";
    private static final String ONT1 = "http://ont1/";
    private static final String ONT2 = "http://ont2/";
    private static final String ONT3 = "http://ont3/";
    private static final String DP1 = "http://ont1/first";
    private static final String DP2 = "http://ont2/second";
    private static final String DP3 = "http://ont1/third";
    private static final String DP4 = "http://ont1/fourth";
    private static final String DP2_NAME = "TWO";
    private static final String DP3_NAME = "THREE";
    private static final String DP4_NAME = "FOUR";
    private static final String DP3_PICK_NAME = "The third one";
    private static final String DP4_PICK_NAME = "The fourth one";
    private static final String DOMAIN_NONE = "http://domain/noSuchDomain";
    private static final String DOMAIN_NO_NAME = "http://domain/domainWithNoName";
    private static final String DOMAIN_W_NAME = "http://domain/namedDomain";
    private static final String NAME_DOMAIN = "An excellent domain";
    private static final String RANGE_NONE = "http://domain/noSuchRange";
    private static final String RANGE_NO_NAME = "http://domain/rangeWithNoName";
    private static final String RANGE_W_NAME = "http://domain/namedRange";
    private static final String NAME_RANGE = "Home on the range";
    private static final String GROUP_NONE = "http://domain/noSuchGroup";
    private static final String GROUP_NO_NAME = "http://domain/groupWithNoName";
    private static final String GROUP_W_NAME = "http://domain/namedGroup";
    private static final String NAME_GROUP = "The Groupsters";
    private static final ArrayNode NO_DATA_RESPONSE = ListDatatypePropertiesControllerTest.arrayOf(new JsonNode[]{mapper.createObjectNode().put("name", "No data properties found")});
    private static final JsonNode RESPONSE_UNFILTERED = ListDatatypePropertiesControllerTest.arrayOf(new JsonNode[]{ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont1/first", "first", "first", "", "", "unspecified"), ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont2/second", "second", "second", "", "http://domain/noSuchRange", "unknown group"), ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont1/fourth", "The fourth one", "The fourth one", "An excellent domain", "Home on the range", "The Groupsters"), ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont1/third", "The third one", "The third one", "domainWithNoName", "", "")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT1 = ListDatatypePropertiesControllerTest.arrayOf(new JsonNode[]{ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont1/first", "first", "first", "", "", "unspecified"), ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont1/fourth", "The fourth one", "The fourth one", "An excellent domain", "Home on the range", "The Groupsters"), ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont1/third", "The third one", "The third one", "domainWithNoName", "", "")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT2 = ListDatatypePropertiesControllerTest.arrayOf(new JsonNode[]{ListDatatypePropertiesControllerTest.propertyListNode("datapropEdit", "http://ont2/second", "second", "second", "", "http://domain/noSuchRange", "unknown group")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT3 = ListDatatypePropertiesControllerTest.arrayOf(new JsonNode[]{mapper.createObjectNode().put("name", "No data properties found")});
    private ListDatatypePropertiesController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private WebappDaoFactoryStub wadf;
    private DataPropertyDaoStub dpdao;
    private DatatypeDaoStub dtdao;
    private VClassDaoStub vcdao;
    private PropertyGroupDaoStub pgdao;

    @Before
    public void setup() {
        this.controller = new ListDatatypePropertiesController();
        this.req = new HttpServletRequestStub();
        new VitroRequest((HttpServletRequest)this.req).setCollator(Collator.getInstance());
        this.dpdao = new DataPropertyDaoStub();
        this.dtdao = new DatatypeDaoStub();
        this.vcdao = new VClassDaoStub();
        this.pgdao = new PropertyGroupDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setDataPropertyDao(this.dpdao);
        this.wadf.setDatatypeDao(this.dtdao);
        this.wadf.setVClassDao(this.vcdao);
        this.wadf.setPropertyGroupDao(this.pgdao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.PolicyOption.POLICY_NEUTRAL});
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.LanguageOption.LANGUAGE_NEUTRAL, ModelAccess.PolicyOption.POLICY_NEUTRAL});
    }

    @Test
    public void noDataProperties() throws Exception {
        ListDatatypePropertiesControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)NO_DATA_RESPONSE);
    }

    @Test
    public void unfiltered() throws Exception {
        this.populate();
        ListDatatypePropertiesControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_UNFILTERED);
    }

    @Test
    public void filteredByOnt1() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT1);
        ListDatatypePropertiesControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT1);
    }

    @Test
    public void filteredByOnt2() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT2);
        ListDatatypePropertiesControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT2);
    }

    @Test
    public void filteredByOnt3() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT3);
        ListDatatypePropertiesControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT3);
    }

    private void populate() {
        this.vcdao.setVClass(this.vclass(DOMAIN_NO_NAME, null));
        this.vcdao.setVClass(this.vclass(DOMAIN_W_NAME, NAME_DOMAIN));
        this.dtdao.addDatatype(this.datatype(RANGE_NO_NAME, null));
        this.dtdao.addDatatype(this.datatype(RANGE_W_NAME, NAME_RANGE));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_NO_NAME, null));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_W_NAME, NAME_GROUP));
        this.dpdao.addDataProperty(this.dataProperty(DP1, null, null, null, null, null));
        this.dpdao.addDataProperty(this.dataProperty(DP2, DP2_NAME, null, DOMAIN_NONE, RANGE_NONE, GROUP_NONE));
        this.dpdao.addDataProperty(this.dataProperty(DP3, DP3_NAME, DP3_PICK_NAME, DOMAIN_NO_NAME, RANGE_NO_NAME, GROUP_NO_NAME));
        this.dpdao.addDataProperty(this.dataProperty(DP4, DP4_NAME, DP4_PICK_NAME, DOMAIN_W_NAME, RANGE_W_NAME, GROUP_W_NAME));
    }

    private DataProperty dataProperty(String uri, String name, String pickListName, String domainClassUri, String rangeDatatypeUri, String groupUri) {
        DataProperty dp = new DataProperty();
        dp.setURI(uri);
        dp.setName(name);
        dp.setPickListName(pickListName);
        dp.setDomainClassURI(domainClassUri);
        dp.setRangeDatatypeURI(rangeDatatypeUri);
        dp.setGroupURI(groupUri);
        return dp;
    }

    private Datatype datatype(String uri, String name) {
        Datatype dt = new Datatype();
        dt.setUri(uri);
        dt.setName(name);
        return dt;
    }

    private VClass vclass(String uri, String pickListName) {
        VClass vc = new VClass();
        vc.setURI(uri);
        vc.setPickListName(pickListName);
        return vc;
    }

    private PropertyGroup propertyGroup(String uri, String name) {
        PropertyGroup pg = new PropertyGroup();
        pg.setURI(uri);
        pg.setName(name);
        return pg;
    }
}

