/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import edu.cornell.mannlib.vitro.webapp.reasoner.ABoxRecomputer;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxHelper;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxListener;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.OutputStream;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.ApplicationStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineStub;
import stubs.javax.servlet.ServletContextStub;

public class SimpleReasonerInversePropertyTest
extends SimpleReasonerTBoxHelper {
    long delay = 50L;

    @Before
    public void suppressErrorOutput() {
        this.suppressSyserr();
        SimpleReasonerInversePropertyTest.setLoggerLevel(SimpleReasoner.class, Level.OFF);
        SimpleReasonerInversePropertyTest.setLoggerLevel(SimpleReasonerTBoxListener.class, Level.OFF);
        SimpleReasonerInversePropertyTest.setLoggerLevel(ABoxRecomputer.class, Level.OFF);
    }

    @Before
    public void setup() {
        ApplicationStub.setup(new ServletContextStub(), new SearchEngineStub());
    }

    @Test
    public void addABoxAssertion1Test() {
        this.addABoxAssertion1(true);
    }

    @Test
    public void addABoxAssertion1NoSameAsTest() {
        this.addABoxAssertion1(false);
    }

    public void addABoxAssertion1(boolean sameAs) {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)sr);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        aBox.add(c, (Property)Q, (RDFNode)d);
        Assert.assertTrue((boolean)inf.contains(d, (Property)P, (RDFNode)c));
        aBox.remove(c, (Property)Q, (RDFNode)d);
        Assert.assertFalse((boolean)inf.contains(d, (Property)P, (RDFNode)c));
        aBox.remove(a, (Property)P, (RDFNode)b);
        Assert.assertFalse((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
    }

    @Test
    public void addABoxAssertion2Test() {
        this.addABoxAssertion2(true);
    }

    @Test
    public void addABoxAssertion2NoSameAsTest() {
        this.addABoxAssertion2(false);
    }

    public void addABoxAssertion2(boolean sameAs) {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        aBox.add(b, (Property)Q, (RDFNode)a);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Assert.assertFalse((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        aBox.add(a, (Property)P, (RDFNode)b);
        Assert.assertFalse((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
    }

    @Test
    public void addABoxAssertion3Test() {
        this.addABoxAssertion3(true);
    }

    @Test
    public void addABoxAssertion3NoSameAsTest() {
        this.addABoxAssertion3(false);
    }

    public void addABoxAssertion3(boolean sameAs) {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)sr);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        aBox.add(a, (Property)P, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        aBox.add(b, (Property)Q, (RDFNode)a);
        Assert.assertFalse((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
    }

    @Test
    public void addABoxAssertion4Test() {
        this.addABoxAssertion4(true);
    }

    @Test
    public void addABoxAssertion4NoSameAsTest() {
        this.addABoxAssertion4(false);
    }

    public void addABoxAssertion4(boolean sameAs) {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty R = this.createObjectProperty(tBox, "http://test.vivo/R", "property R");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        this.setInverse((OntProperty)R, (OntProperty)Q);
        this.setEquivalent((OntProperty)R, (OntProperty)P);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)sr);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)R, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        aBox.add(c, (Property)Q, (RDFNode)d);
        Assert.assertTrue((boolean)inf.contains(d, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(d, (Property)R, (RDFNode)c));
    }

    @Test
    public void removedABoxAssertion1Test() {
        this.removedABoxAssertion1(true);
    }

    @Test
    public void removedABoxAssertion1NoSameAsTest() {
        this.removedABoxAssertion1(false);
    }

    public void removedABoxAssertion1(boolean sameAs) {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        this.setInverse((OntProperty)P, (OntProperty)T);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)sr);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        aBox.add(c, (Property)Q, (RDFNode)d);
        aBox.add(c, (Property)T, (RDFNode)d);
        Assert.assertTrue((boolean)inf.contains(d, (Property)P, (RDFNode)c));
        aBox.remove(a, (Property)P, (RDFNode)b);
        Assert.assertFalse((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        aBox.remove(c, (Property)Q, (RDFNode)d);
        Assert.assertTrue((boolean)inf.contains(d, (Property)P, (RDFNode)c));
    }

    @Test
    public void removedABoxAssertion2Test() {
        this.removedABoxAssertion2(true);
    }

    @Test
    public void removedABoxAssertion2NoSameAsTest() {
        this.removedABoxAssertion2(false);
    }

    public void removedABoxAssertion2(boolean sameAs) {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        this.setInverse((OntProperty)T, (OntProperty)Q);
        this.setEquivalent((OntProperty)P, (OntProperty)T);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)sr);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        aBox.add(a, (Property)P, (RDFNode)b);
        aBox.add(a, (Property)T, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(a, (Property)P, (RDFNode)b));
        Assert.assertFalse((boolean)inf.contains(a, (Property)T, (RDFNode)b));
        aBox.remove(a, (Property)P, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
    }

    @Test
    public void removedABoxAssertion3Test() {
        this.removedABoxAssertion3(true);
    }

    @Test
    public void removedABoxAssertion3NoSameAsTest() {
        this.removedABoxAssertion3(false);
    }

    public void removedABoxAssertion3(boolean sameAs) {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        aBox.add(a, (Property)P, (RDFNode)b);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)sr);
        aBox.add(b, (Property)Q, (RDFNode)a);
        Assert.assertFalse((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(a, (Property)P, (RDFNode)b));
        aBox.remove(a, (Property)P, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(a, (Property)P, (RDFNode)b));
    }

    @Test
    public void addTBoxInverseAssertion1Test() throws InterruptedException {
        this.addTBoxInverseAssertion1(true);
    }

    @Test
    public void addTBoxInverseAssertion1NoSameAsTest() throws InterruptedException {
        this.addTBoxInverseAssertion1(false);
    }

    public void addTBoxInverseAssertion1(boolean sameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        simpleReasoner.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        Individual a = aBox.createIndividual("http://test.vivo/a", OWL.Thing);
        Individual b = aBox.createIndividual("http://test.vivo/b", OWL.Thing);
        Individual c = aBox.createIndividual("http://test.vivo/c", OWL.Thing);
        Individual d = aBox.createIndividual("http://test.vivo/d", OWL.Thing);
        aBox.add((Resource)a, (Property)P, (RDFNode)b);
        aBox.add((Resource)c, (Property)P, (RDFNode)d);
        aBox.add((Resource)b, (Property)Q, (RDFNode)a);
        this.setInverse((OntProperty)P, (OntProperty)Q);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertTrue((boolean)inf.contains((Resource)d, (Property)Q, (RDFNode)c));
        Assert.assertFalse((boolean)inf.contains((Resource)b, (Property)Q, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains((Resource)a, (Property)P, (RDFNode)b));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void removeTBoxInverseAssertion1Test() throws InterruptedException {
        this.removeTBoxInverseAssertion1(true);
    }

    @Test
    public void removeTBoxInverseAssertion1NoSameAsTest() throws InterruptedException {
        this.removeTBoxInverseAssertion1(false);
    }

    public void removeTBoxInverseAssertion1(boolean sameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        simpleReasoner.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        Individual c = aBox.createIndividual("http://test.vivo/c", OWL.Thing);
        Individual d = aBox.createIndividual("http://test.vivo/d", OWL.Thing);
        aBox.add((Resource)c, (Property)P, (RDFNode)d);
        Assert.assertTrue((boolean)inf.contains((Resource)d, (Property)Q, (RDFNode)c));
        this.removeInverse((OntProperty)P, (OntProperty)Q);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertFalse((boolean)inf.contains((Resource)d, (Property)Q, (RDFNode)c));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void recomputeABox1Test() throws InterruptedException {
        this.recomputeABox1(true);
    }

    @Test
    public void recomputeABox1NoSameAsTest() throws InterruptedException {
        this.recomputeABox1(false);
    }

    public void recomputeABox1(boolean sameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        this.setInverse((OntProperty)P, (OntProperty)Q);
        ObjectProperty X = this.createObjectProperty(tBox, "http://test.vivo/X", "property X");
        ObjectProperty Y = this.createObjectProperty(tBox, "http://test.vivo/Y", "property Y");
        this.setInverse((OntProperty)X, (OntProperty)Y);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        simpleReasoner.setSameAsEnabled(sameAs);
        aBox.register((ModelChangedListener)simpleReasoner);
        Individual a = aBox.createIndividual("http://test.vivo/a", OWL.Thing);
        Individual b = aBox.createIndividual("http://test.vivo/b", OWL.Thing);
        Individual c = aBox.createIndividual("http://test.vivo/c", OWL.Thing);
        Individual d = aBox.createIndividual("http://test.vivo/d", OWL.Thing);
        aBox.add((Resource)a, (Property)P, (RDFNode)b);
        aBox.add((Resource)c, (Property)X, (RDFNode)d);
        Assert.assertTrue((boolean)inf.contains((Resource)b, (Property)Q, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains((Resource)d, (Property)Y, (RDFNode)c));
        inf.remove((Resource)b, (Property)Q, (RDFNode)a);
        inf.remove((Resource)d, (Property)Y, (RDFNode)c);
        simpleReasoner.recompute();
        while (simpleReasoner.isRecomputing()) {
            Thread.sleep(this.delay);
        }
        Assert.assertTrue((boolean)inf.contains((Resource)b, (Property)Q, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains((Resource)d, (Property)Y, (RDFNode)c));
    }

    SimpleReasonerTBoxListener getTBoxListener(SimpleReasoner simpleReasoner) {
        return new SimpleReasonerTBoxListener(simpleReasoner, new Exception().getStackTrace()[1].getMethodName());
    }

    void printModel(Model model, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + model.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        model.write((OutputStream)System.out);
    }

    void printModel(OntModel ontModel, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + ontModel.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        ontModel.writeAll((OutputStream)System.out, "N3", null);
    }
}

