/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.http;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.ContentTypeUtil;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ContentTypeUtilTest
extends AbstractTestClass {
    @Test
    public void mcEmptyName() {
        this.checkMatchCriteriaConstructor("MC empty name", "", "*", "*");
    }

    @Test
    public void mcNullName() {
        this.checkMatchCriteriaConstructor("MC null name", null, "*", "*");
    }

    @Test
    public void mcTypeOnly() {
        this.checkMatchCriteriaConstructor("MC type only", "image", "image", "*");
    }

    @Test
    public void mcTypeAndSubtype() {
        this.checkMatchCriteriaConstructor("MC type and subtype", "image/png", "image", "png");
    }

    @Test
    public void mcTypeAndEmptySubtype() {
        this.checkMatchCriteriaConstructor("MC type and empty subtype", "image/", "image", "*");
    }

    @Test
    public void mcWildcardType() {
        this.checkMatchCriteriaConstructor("MC wild card type", "*", "*", "*");
    }

    @Test
    public void mcWildcardSubtype() {
        this.checkMatchCriteriaConstructor("MC wild card subtype", "image/*", "image", "*");
    }

    @Test
    public void mcMatchWildcardType() {
        this.checkMatchQuality("MC match wild card type 1", "*", "text", 1);
        this.checkMatchQuality("MC match wild card type 2", "text", "*", 1);
        this.checkMatchQuality("MC match wild card type 3", "*", "text/plain", 1);
        this.checkMatchQuality("MC match wild card type 4", "text/*", "*", 1);
    }

    @Test
    public void mcTypesDontMatch() {
        this.checkMatchQuality("MC types don't match 1", "this", "that", 0);
        this.checkMatchQuality("MC types don't match 2", "this/match", "that/match", 0);
    }

    @Test
    public void mcMatchWildcardSubtype() {
        this.checkMatchQuality("MC match wild card subtype 1", "text", "text/xml", 2);
        this.checkMatchQuality("MC match wild card subtype 2", "image/jpeg", "image/*", 2);
    }

    @Test
    public void mcSubtypesDontMatch() {
        this.checkMatchQuality("MC match subtypes don't match", "text/xml", "text/plain", 0);
    }

    @Test
    public void mcFullMatch() {
        this.checkMatchQuality("MC full match", "text/plain", "text/plain", 3);
    }

    @Test
    public void atNullQ() throws AcceptHeaderParsingException {
        this.checkAcceptableTypeConstructor("AT null Q", null, 1.0f);
    }

    @Test
    public void atEmptyQ() throws AcceptHeaderParsingException {
        this.checkAcceptableTypeConstructor("AT empty Q", "", 1.0f);
    }

    @Test
    public void atBlankQ() throws AcceptHeaderParsingException {
        this.checkAcceptableTypeConstructor("AT blank Q", "  \t", 1.0f);
    }

    @Test(expected=AcceptHeaderParsingException.class)
    public void atInvalidQ() throws AcceptHeaderParsingException {
        this.checkAcceptableTypeConstructor("AT invalid Q", "99XX", 0.0f);
    }

    @Test(expected=AcceptHeaderParsingException.class)
    public void atQTooHigh() throws AcceptHeaderParsingException {
        this.checkAcceptableTypeConstructor("AT Q too high", "1.1", 0.0f);
    }

    @Test(expected=AcceptHeaderParsingException.class)
    public void atQTooLow() throws AcceptHeaderParsingException {
        this.checkAcceptableTypeConstructor("AT Q too low", "0", 0.0f);
    }

    @Test
    public void atGoodQ() throws AcceptHeaderParsingException {
        this.checkAcceptableTypeConstructor("AT good Q", "0.4", 0.4f);
    }

    @Test
    public void atWildcardMatchWorks() throws AcceptHeaderParsingException {
        this.checkMatchQuality("AT wild card match", "*", 0.5f, "text/plain", 2.5f);
    }

    @Test
    public void atPartialMatchIsBetter() throws AcceptHeaderParsingException {
        this.checkMatchQuality("AT partial match", "text", 0.5f, "text/plain", 3.5f);
    }

    @Test
    public void atFullMatchIsBest() throws AcceptHeaderParsingException {
        this.checkMatchQuality("AT full match", "text/plain", 0.5f, "text/plain", 4.5f);
    }

    @Test
    public void atNoMatchTotallyBites() throws AcceptHeaderParsingException {
        this.checkMatchQuality("AT full match", "text/xml", 0.5f, "text/plain", 0.0f);
    }

    @Test
    public void ctNullHeaderMatchesAnything() throws Exception {
        this.findBestMatch("CT null header matches anything", null, this.available("anything"), "anything");
    }

    @Test
    public void ctEmptyHeaderMatchesAnything() throws Exception {
        this.findBestMatch("CT empty header matches anything", "", this.available("anything"), "anything");
    }

    @Test
    public void ctBlankHeaderMatchesAnything() throws Exception {
        this.findBestMatch("CT blank header matches anything", "   \t  ", this.available("anything"), "anything");
    }

    @Test(expected=NotAcceptableException.class)
    public void ctNullCollectionMatchesNothing() throws Exception {
        this.findBestMatch("CT null collection matches nothing", "*/*", null, "nothing");
    }

    @Test(expected=NotAcceptableException.class)
    public void ctEmptyCollectionMatchesNothing() throws Exception {
        this.findBestMatch("CT empty collection matches nothing", "*/*", this.available(new String[0]), "nothing");
    }

    @Test
    public void ctWildcardIsOK() throws Exception {
        this.findBestMatch("CT wild card is OK", "text/*;q=0.3, text/html;q=0.1, */*;q=0.5", this.available("image/png"), "image/png");
    }

    @Test
    public void ctPartialMatchIsBetter() throws Exception {
        this.findBestMatch("CT partial match is better", "text/*;q=0.3, text/html;q=0.1, */*;q=0.5", this.available("image/png", "text/xml"), "text/xml");
    }

    @Test
    public void ctFullMatchIsBest() throws Exception {
        this.findBestMatch("CT full match is best", "text/*;q=0.3, text/html;q=0.1, */*;q=0.5", this.available("image/png", "text/xml", "text/html"), "text/html");
    }

    @Test(expected=NotAcceptableException.class)
    public void ctNoMatchTotalBites() throws Exception {
        this.findBestMatch("CT no match totally bites", "text/*;q=0.3, text/html;q=0.1", this.available("no/match"), "nothing");
    }

    private void checkMatchCriteriaConstructor(String message, String name, String expectedType, String expectedSubtype) {
        ContentTypeUtil.MatchCriteria mc = new ContentTypeUtil.MatchCriteria(name);
        Assert.assertEquals((String)(message + " - type"), (Object)expectedType, (Object)mc.getType());
        Assert.assertEquals((String)(message + " - subtype"), (Object)expectedSubtype, (Object)mc.getSubtype());
    }

    private void checkMatchQuality(String message, String name1, String name2, int expected) {
        ContentTypeUtil.MatchCriteria mc1 = new ContentTypeUtil.MatchCriteria(name1);
        ContentTypeUtil.MatchCriteria mc2 = new ContentTypeUtil.MatchCriteria(name2);
        int actual = mc1.matchQuality(mc2);
        Assert.assertEquals((String)message, (long)expected, (long)actual);
    }

    private void checkAcceptableTypeConstructor(String message, String qString, float expected) throws AcceptHeaderParsingException {
        ContentTypeUtil.AcceptableType at = new ContentTypeUtil.AcceptableType("irrelevant", qString);
        Assert.assertEquals((String)message, (float)expected, (float)at.getQ(), (float)1.0E-4f);
    }

    private void checkMatchQuality(String message, String name1, float qValue, String name2, float expected) throws AcceptHeaderParsingException {
        ContentTypeUtil.AcceptableType at = new ContentTypeUtil.AcceptableType(name1, Float.toString(qValue));
        ContentTypeUtil.MatchCriteria mc = new ContentTypeUtil.MatchCriteria(name2);
        float actual = at.fitQuality(mc);
        Assert.assertEquals((String)message, (float)expected, (float)actual, (float)1.0E-4f);
    }

    private List<String> available(String ... names) {
        return Arrays.asList(names);
    }

    private void findBestMatch(String message, String acceptHeader, List<String> availableTypeNames, String expected) throws AcceptHeaderParsingException, NotAcceptableException {
        String actual = ContentTypeUtil.bestContentType((String)acceptHeader, availableTypeNames);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }
}

