/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dwr;

import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;

public class PropertyDWR {
    private static final Log log = LogFactory.getLog((String)PropertyDWR.class.getName());
    public static boolean debug = true;

    public Object test() {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        Collection<PropertyInstance> c = wdf.getPropertyInstanceDao().getExistingProperties("http://example.org/property", null);
        return c.iterator().next();
    }

    public Collection getAllPropInstByVClass(String classURI) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        WebappDaoFactory wdf = vreq.getUnfilteredWebappDaoFactory();
        Collection<PropertyInstance> c = wdf.getPropertyInstanceDao().getAllPropInstByVClass(classURI);
        return c;
    }

    public Collection getAllPossiblePropInstForIndividual(String individualURI) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        WebappDaoFactory wdf = vreq.getUnfilteredWebappDaoFactory();
        Collection<PropertyInstance> c = wdf.getPropertyInstanceDao().getAllPossiblePropInstForIndividual(individualURI);
        return c;
    }

    public PropertyInstance getProperty(String subjectURI, String predicateURI, String objectURI) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        WebappDaoFactory wdf = vreq.getUnfilteredWebappDaoFactory();
        return wdf.getPropertyInstanceDao().getProperty(subjectURI, predicateURI, objectURI);
    }

    public int insertProp(PropertyInstance prop) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        return vreq.getUnfilteredWebappDaoFactory().getPropertyInstanceDao().insertProp(prop);
    }

    public int deleteProp(String subjectUri, String predicateUri, String objectUri) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        vreq.getUnfilteredWebappDaoFactory().getPropertyInstanceDao().deleteObjectPropertyStatement(subjectUri, predicateUri, objectUri);
        return 0;
    }

    @Deprecated
    public Collection getExistingQualifiers(String propertyURI) {
        ArrayList<String> c = new ArrayList<String>(1);
        c.add("qualifiers are no longer supporeted ");
        return c;
    }

    public Collection getExistingProperties(String entityURI) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        WebappDaoFactory wdf = vreq.getUnfilteredWebappDaoFactory();
        return wdf.getPropertyInstanceDao().getExistingProperties(entityURI, null);
    }
}

