/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.AcceptableLanguages;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.FilteredResultSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LangSort;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilterModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.RDFNode;

public class LanguageFilteringRDFService
implements RDFService {
    private static final Log log = LogFactory.getLog(LanguageFilteringRDFService.class);
    private RDFService s;
    private List<String> langs;
    private LanguageFilterModel filterModel = new LanguageFilterModel();
    private VitroRequest vitroRequest;

    public LanguageFilteringRDFService(RDFService service, List<String> langs) {
        this.s = service;
        this.langs = new AcceptableLanguages(langs);
    }

    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        return this.s.changeSetUpdate(changeSet);
    }

    @Override
    public void newIndividual(String individualURI, String individualTypeURI) throws RDFServiceException {
        this.s.newIndividual(individualURI, individualTypeURI);
    }

    @Override
    public void newIndividual(String individualURI, String individualTypeURI, String graphURI) throws RDFServiceException {
        this.s.newIndividual(individualURI, individualTypeURI, graphURI);
    }

    @Override
    public InputStream sparqlConstructQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model m = RDFServiceUtils.parseModel(this.s.sparqlConstructQuery(query, resultFormat), resultFormat);
        InputStream in = this.outputModel(this.filterModel.filterModel(m, this.langs), resultFormat);
        return in;
    }

    @Override
    public void sparqlConstructQuery(String query, Model model) throws RDFServiceException {
        this.s.sparqlConstructQuery(query, model);
    }

    @Override
    public InputStream sparqlDescribeQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model m = RDFServiceUtils.parseModel(this.s.sparqlDescribeQuery(query, resultFormat), resultFormat);
        return this.outputModel(this.filterModel.filterModel(m, this.langs), resultFormat);
    }

    private InputStream outputModel(Model m, RDFService.ModelSerializationFormat resultFormat) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.write((OutputStream)out, RDFServiceUtils.getSerializationFormatString(resultFormat));
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public InputStream sparqlSelectQuery(String query, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        log.debug((Object)("sparqlSelectQuery: " + query.replaceAll("\\s+", " ")));
        ResultSet resultSet = ResultSetFactory.fromJSON((InputStream)this.s.sparqlSelectQuery(query, RDFService.ResultFormat.JSON));
        List<QuerySolution> solnList = this.getSolutionList(resultSet);
        List vars = resultSet.getResultVars();
        for (Object var : vars) {
            HashMap nonVarToRowIndexedLiterals = new HashMap();
            for (int i = 0; i < solnList.size(); ++i) {
                RDFNode node;
                QuerySolution s = solnList.get(i);
                if (s == null || (node = s.get((String)var)) == null || !node.isLiteral()) continue;
                ArrayList<RDFNode> nonVarList = new ArrayList<RDFNode>(vars.size() - 1);
                for (String v : vars) {
                    if (v.equals(var)) continue;
                    nonVarList.add(s.get(v));
                }
                ArrayList<RowIndexedLiteral> rowIndexedLiterals = (ArrayList<RowIndexedLiteral>)nonVarToRowIndexedLiterals.get(nonVarList);
                if (rowIndexedLiterals == null) {
                    rowIndexedLiterals = new ArrayList<RowIndexedLiteral>();
                }
                rowIndexedLiterals.add(new RowIndexedLiteral(node.asLiteral(), i));
                nonVarToRowIndexedLiterals.put(nonVarList, rowIndexedLiterals);
            }
            for (List key : nonVarToRowIndexedLiterals.keySet()) {
                List candidatesForRemoval = (List)nonVarToRowIndexedLiterals.get(key);
                if (candidatesForRemoval.size() == 1) continue;
                candidatesForRemoval.sort(new RowIndexedLiteralSortByLang(this.langs));
                log.debug((Object)("sorted RowIndexedLiterals: " + this.showSortedRILs(candidatesForRemoval)));
                Iterator candIt = candidatesForRemoval.iterator();
                String langRegister = null;
                boolean chuckRemaining = false;
                while (candIt.hasNext()) {
                    RowIndexedLiteral rlit = (RowIndexedLiteral)candIt.next();
                    if (chuckRemaining) {
                        solnList.set(rlit.getIndex(), null);
                        continue;
                    }
                    if (langRegister == null) {
                        langRegister = rlit.getLiteral().getLanguage();
                        continue;
                    }
                    if (langRegister.equals(rlit.getLiteral().getLanguage())) continue;
                    chuckRemaining = true;
                    solnList.set(rlit.getIndex(), null);
                }
            }
        }
        ArrayList<QuerySolution> compactedList = new ArrayList<QuerySolution>();
        for (QuerySolution soln : solnList) {
            if (soln == null) continue;
            compactedList.add(soln);
        }
        FilteredResultSet filtered = new FilteredResultSet(compactedList, resultSet);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        switch (resultFormat) {
            case CSV: {
                ResultSetFormatter.outputAsCSV((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            case TEXT: {
                ResultSetFormatter.out((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            case JSON: {
                ResultSetFormatter.outputAsJSON((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            case XML: {
                ResultSetFormatter.outputAsXML((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            default: {
                throw new RDFServiceException("unrecognized result format");
            }
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    @Override
    public void sparqlSelectQuery(String query, ResultSetConsumer consumer) throws RDFServiceException {
        log.debug((Object)("sparqlSelectQuery: " + query.replaceAll("\\s+", " ")));
        this.s.sparqlSelectQuery(query, new ResultSetConsumer.Chaining(consumer){
            List<String> vars;
            List<QuerySolution> solnList;
            {
                this.solnList = new ArrayList<QuerySolution>();
            }

            @Override
            protected void processQuerySolution(QuerySolution qs) {
                this.solnList.add(qs);
            }

            @Override
            protected void startProcessing() {
                this.vars = this.getResultVars();
            }

            @Override
            protected void endProcessing() {
                this.chainStartProcessing();
                for (String var : this.vars) {
                    HashMap nonVarToRowIndexedLiterals = new HashMap();
                    for (int i = 0; i < this.solnList.size(); ++i) {
                        RDFNode node;
                        QuerySolution s = this.solnList.get(i);
                        if (s == null || (node = s.get(var)) == null || !node.isLiteral()) continue;
                        ArrayList<RDFNode> nonVarList = new ArrayList<RDFNode>(this.vars.size() - 1);
                        for (String v : this.vars) {
                            if (v.equals(var)) continue;
                            nonVarList.add(s.get(v));
                        }
                        ArrayList<RowIndexedLiteral> rowIndexedLiterals = (ArrayList<RowIndexedLiteral>)nonVarToRowIndexedLiterals.get(nonVarList);
                        if (rowIndexedLiterals == null) {
                            rowIndexedLiterals = new ArrayList<RowIndexedLiteral>();
                        }
                        rowIndexedLiterals.add(new RowIndexedLiteral(node.asLiteral(), i));
                        nonVarToRowIndexedLiterals.put(nonVarList, rowIndexedLiterals);
                    }
                    for (List key : nonVarToRowIndexedLiterals.keySet()) {
                        List candidatesForRemoval = (List)nonVarToRowIndexedLiterals.get(key);
                        if (candidatesForRemoval.size() == 1) continue;
                        candidatesForRemoval.sort(new RowIndexedLiteralSortByLang(LanguageFilteringRDFService.this.langs));
                        log.debug((Object)("sorted RowIndexedLiterals: " + LanguageFilteringRDFService.this.showSortedRILs(candidatesForRemoval)));
                        Iterator candIt = candidatesForRemoval.iterator();
                        String langRegister = null;
                        boolean chuckRemaining = false;
                        while (candIt.hasNext()) {
                            RowIndexedLiteral rlit = (RowIndexedLiteral)candIt.next();
                            if (chuckRemaining) {
                                this.solnList.set(rlit.getIndex(), null);
                                continue;
                            }
                            if (langRegister == null) {
                                langRegister = rlit.getLiteral().getLanguage();
                                continue;
                            }
                            if (langRegister.equals(rlit.getLiteral().getLanguage())) continue;
                            chuckRemaining = true;
                            this.solnList.set(rlit.getIndex(), null);
                        }
                    }
                }
                for (QuerySolution soln : this.solnList) {
                    if (soln == null) continue;
                    this.chainProcessQuerySolution(soln);
                }
                this.chainEndProcessing();
            }
        });
    }

    private String showSortedRILs(List<RowIndexedLiteral> candidatesForRemoval) {
        ArrayList<String> langstrings = new ArrayList<String>();
        for (RowIndexedLiteral ril : candidatesForRemoval) {
            langstrings.add(ril.getLiteral().getLanguage());
        }
        return ((Object)langstrings).toString();
    }

    private List<QuerySolution> getSolutionList(ResultSet resultSet) {
        ArrayList<QuerySolution> solnList = new ArrayList<QuerySolution>();
        while (resultSet.hasNext()) {
            QuerySolution soln = resultSet.nextSolution();
            solnList.add(soln);
        }
        return solnList;
    }

    @Override
    public boolean sparqlAskQuery(String query) throws RDFServiceException {
        return this.s.sparqlAskQuery(query);
    }

    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        return this.s.getGraphURIs();
    }

    @Override
    public void getGraphMetadata() throws RDFServiceException {
        this.s.getGraphMetadata();
    }

    @Override
    public String getDefaultWriteGraphURI() throws RDFServiceException {
        return this.s.getDefaultWriteGraphURI();
    }

    @Override
    public void serializeAll(OutputStream outputStream) throws RDFServiceException {
        this.s.serializeAll(outputStream);
    }

    @Override
    public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
        this.s.serializeGraph(graphURI, outputStream);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        return this.s.isEquivalentGraph(graphURI, serializedGraph, serializationFormat);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        return this.s.isEquivalentGraph(graphURI, graph);
    }

    @Override
    public void registerListener(ChangeListener changeListener) throws RDFServiceException {
        this.s.registerListener(changeListener);
    }

    @Override
    public void unregisterListener(ChangeListener changeListener) throws RDFServiceException {
        this.s.unregisterListener(changeListener);
    }

    @Override
    public void registerJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.s.registerJenaModelChangedListener(changeListener);
    }

    @Override
    public void unregisterJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.s.unregisterJenaModelChangedListener(changeListener);
    }

    @Override
    public ChangeSet manufactureChangeSet() {
        return this.s.manufactureChangeSet();
    }

    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        return this.s.countTriples(subject, predicate, object);
    }

    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        return this.s.getTriples(subject, predicate, object, limit, offset);
    }

    @Override
    public boolean preferPreciseOptionals() {
        return this.s.preferPreciseOptionals();
    }

    @Override
    public void close() {
        this.s.close();
    }

    @Override
    public void setVitroRequest(VitroRequest vitroRequest) {
        this.vitroRequest = vitroRequest;
    }

    @Override
    public VitroRequest getVitroRequest() {
        return this.vitroRequest;
    }

    private class RowIndexedLiteralSortByLang
    extends LangSort
    implements Comparator<RowIndexedLiteral> {
        public RowIndexedLiteralSortByLang(List<String> langs) {
            super(langs);
        }

        @Override
        public int compare(RowIndexedLiteral rilit1, RowIndexedLiteral rilit2) {
            if (rilit1 == null || rilit2 == null) {
                return 0;
            }
            String t1lang = rilit1.getLiteral().getLanguage();
            String t2lang = rilit2.getLiteral().getLanguage();
            return this.compareLangs(t1lang, t2lang);
        }
    }

    private class RowIndexedLiteral {
        private Literal literal;
        private int index;

        public RowIndexedLiteral(Literal literal, int index) {
            this.literal = literal;
            this.index = index;
        }

        public Literal getLiteral() {
            return this.literal;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

