/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.sdb;

import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.StaticDatasetFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.RDFServiceJena;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sdb.SDBFactory;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.layout2.NodeLayout2;
import org.apache.jena.sdb.layout2.ValueType;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.DatabaseType;
import org.apache.jena.sdb.store.LayoutType;

public class RDFServiceSDB
extends RDFServiceJena
implements RDFService {
    private static final Log log = LogFactory.getLog(RDFServiceSDB.class);
    private DataSource ds;
    private StoreDesc storeDesc;
    private Connection conn;
    private StaticDatasetFactory staticDatasetFactory;

    public RDFServiceSDB(DataSource dataSource, StoreDesc storeDesc) {
        this.ds = dataSource;
        this.storeDesc = storeDesc;
    }

    public RDFServiceSDB(Connection conn, StoreDesc storeDesc) {
        this.conn = conn;
        this.storeDesc = storeDesc;
        this.staticDatasetFactory = new StaticDatasetFactory(this.getDataset(new SDBConnection(conn)));
    }

    @Override
    protected DatasetWrapper getDatasetWrapper() {
        try {
            if (this.staticDatasetFactory != null) {
                return this.staticDatasetFactory.getDatasetWrapper();
            }
            SDBConnection sdbConn = new SDBConnection(this.ds.getConnection());
            return new DatasetWrapper(this.getDataset(sdbConn), sdbConn);
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
    }

    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        if (changeSet.getPreconditionQuery() != null && !this.isPreconditionSatisfied(changeSet.getPreconditionQuery(), changeSet.getPreconditionQueryType())) {
            return false;
        }
        SDBConnection sdbConn = this.getSDBConnection();
        Dataset dataset = this.getDataset(sdbConn);
        try {
            this.insureThatInputStreamsAreResettable(changeSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.beginTransaction(sdbConn);
            this.notifyListenersOfPreChangeEvents(changeSet);
            this.applyChangeSetToModel(changeSet, dataset);
            this.commitTransaction(sdbConn);
            this.notifyListenersOfChanges(changeSet);
            this.notifyListenersOfPostChangeEvents(changeSet);
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.abortTransaction(sdbConn);
            throw new RDFServiceException(e);
        }
        finally {
            this.rebuildGraphURICache = true;
            this.close(sdbConn);
        }
    }

    private SDBConnection getSDBConnection() throws RDFServiceException {
        try {
            Connection c = this.conn != null ? this.conn : this.ds.getConnection();
            return new SDBConnection(c);
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw new RDFServiceException(sqle);
        }
    }

    private void close(SDBConnection sdbConn) {
        if (!sdbConn.getSqlConnection().equals(this.conn)) {
            sdbConn.close();
        }
    }

    private Dataset getDataset(SDBConnection sdbConn) {
        Store store = SDBFactory.connectStore((SDBConnection)sdbConn, (StoreDesc)this.storeDesc);
        store.getLoader().setUseThreading(false);
        return SDBFactory.connectDataset((Store)store);
    }

    private void beginTransaction(SDBConnection sdbConn) {
        if (sdbConn.getTransactionHandler().transactionsSupported()) {
            sdbConn.getTransactionHandler().begin();
        }
    }

    private void commitTransaction(SDBConnection sdbConn) {
        if (sdbConn.getTransactionHandler().transactionsSupported()) {
            sdbConn.getTransactionHandler().commit();
        }
    }

    private void abortTransaction(SDBConnection sdbConn) {
        if (sdbConn.getTransactionHandler().transactionsSupported()) {
            sdbConn.getTransactionHandler().abort();
        }
    }

    @Override
    protected QueryExecution createQueryExecution(String queryString, Query q, Dataset d) {
        return QueryExecutionFactory.create((Query)q, (Dataset)d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        if (LayoutType.LayoutTripleNodesHash.equals((Object)this.storeDesc.getLayout())) {
            if (DatabaseType.MySQL.equals((Object)this.storeDesc.getDbType()) || DatabaseType.PostgreSQL.equals((Object)this.storeDesc.getDbType())) {
                SDBConnection sdbConn = this.getSDBConnection();
                try {
                    String whereClause = this.makeWhereClause(subject, predicate, object);
                    Statement stmt = sdbConn.getSqlConnection().createStatement();
                    try (ResultSet rs = stmt.executeQuery("SELECT count(DISTINCT s,p,o) AS tcount FROM Quads" + (StringUtils.isEmpty((CharSequence)whereClause) ? "" : " WHERE " + whereClause));){
                        if (rs.next()) {
                            long l = rs.getLong("tcount");
                            return l;
                        }
                    }
                }
                catch (SQLException sqle) {
                    throw new RDFServiceException("Unable to retrieve triples", sqle);
                }
                finally {
                    this.close(sdbConn);
                }
            }
        } else {
            return super.countTriples(subject, predicate, object);
        }
        return super.countTriples(subject, predicate, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        if (LayoutType.LayoutTripleNodesHash.equals((Object)this.storeDesc.getLayout()) && (DatabaseType.MySQL.equals((Object)this.storeDesc.getDbType()) || DatabaseType.PostgreSQL.equals((Object)this.storeDesc.getDbType()))) {
            Model triples = ModelFactory.createDefaultModel();
            SDBConnection sdbConn = this.getSDBConnection();
            try {
                String whereClause = this.makeWhereClause(subject, predicate, object);
                Statement stmt = sdbConn.getSqlConnection().createStatement();
                try (ResultSet rs = stmt.executeQuery("SELECT \nN1.lex      AS s_lex,\nN1.lang     AS s_lang,\nN1.datatype AS s_datatype,\nN1.type     AS s_type,\nN2.lex      AS p_lex,\nN2.lang     AS p_lang,\nN2.datatype AS p_datatype,\nN2.type     AS p_type,\nN3.lex      AS o_lex,\nN3.lang     AS o_lang,\nN3.datatype AS o_datatype,\nN3.type     AS o_type\nFROM\n(SELECT DISTINCT s,p,o FROM Quads" + (StringUtils.isEmpty((CharSequence)whereClause) ? "" : " WHERE " + whereClause) + " ORDER BY s,p,o " + (limit > 0L ? "LIMIT " + limit : "") + (offset > 0L ? " OFFSET " + offset : "") + ") Q\nLEFT OUTER JOIN\n\tNodes AS N1\nON ( Q.s = N1.hash )\nLEFT OUTER JOIN\n\tNodes AS N2\nON ( Q.p = N2.hash )\nLEFT OUTER JOIN\n\tNodes AS N3\nON ( Q.o = N3.hash )");){
                    while (rs.next()) {
                        Node subjectNode = RDFServiceSDB.makeNode(rs.getString("s_lex"), rs.getString("s_datatype"), rs.getString("s_lang"), ValueType.lookup((int)rs.getInt("s_type")));
                        Node predicateNode = RDFServiceSDB.makeNode(rs.getString("p_lex"), rs.getString("p_datatype"), rs.getString("p_lang"), ValueType.lookup((int)rs.getInt("p_type")));
                        Node objectNode = RDFServiceSDB.makeNode(rs.getString("o_lex"), rs.getString("o_datatype"), rs.getString("o_lang"), ValueType.lookup((int)rs.getInt("o_type")));
                        triples.add(triples.asStatement(Triple.create((Node)subjectNode, (Node)predicateNode, (Node)objectNode)));
                    }
                }
            }
            catch (SQLException sqle) {
                throw new RDFServiceException("Unable to retrieve triples", sqle);
            }
            finally {
                this.close(sdbConn);
            }
            return triples;
        }
        return super.getTriples(subject, predicate, object, limit, offset);
    }

    @Override
    public boolean preferPreciseOptionals() {
        return true;
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private static Node makeNode(String lex, String datatype, String lang, ValueType vType) {
        switch (vType) {
            case BNODE: {
                return NodeFactory.createBlankNode((String)lex);
            }
            case URI: {
                return NodeFactory.createURI((String)lex);
            }
            case STRING: {
                return NodeFactory.createLiteral((String)lex, (String)lang);
            }
            case XSDSTRING: {
                return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDstring);
            }
            case INTEGER: {
                return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDinteger);
            }
            case DOUBLE: {
                return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdouble);
            }
            case DATETIME: {
                return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdateTime);
            }
            case OTHER: {
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(datatype);
                return NodeFactory.createLiteral((String)lex, (RDFDatatype)dt);
            }
        }
        log.warn((Object)("Unrecognized: (" + lex + ", " + lang + ", " + vType + ")"));
        return NodeFactory.createLiteral((String)"UNRECOGNIZED");
    }

    private String makeWhereClause(RDFNode subject, RDFNode predicate, RDFNode object) {
        StringBuilder whereClause = new StringBuilder();
        if (subject != null) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("s=").append(NodeLayout2.hash((Node)subject.asNode()));
        }
        if (predicate != null) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("p=").append(NodeLayout2.hash((Node)predicate.asNode()));
        }
        if (object != null) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("o=").append(NodeLayout2.hash((Node)object.asNode()));
        }
        return whereClause.length() > 0 ? whereClause.toString() : null;
    }
}

