/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchFacetField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.LinkTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.searchresult.IndividualSearchResult;
import edu.ucsf.vitro.opensocial.OpenSocialManager;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="SearchController", urlPatterns={"/search", "/search.jsp", "/fedsearch", "/searchcontroller"})
public class PagedSearchController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PagedSearchController.class);
    protected static final int DEFAULT_HITS_PER_PAGE = 25;
    protected static final int DEFAULT_MAX_HIT_COUNT = 1000;
    private static final String PARAM_XML_REQUEST = "xml";
    private static final String PARAM_CSV_REQUEST = "csv";
    private static final String PARAM_START_INDEX = "startIndex";
    private static final String PARAM_HITS_PER_PAGE = "hitsPerPage";
    private static final String PARAM_CLASSGROUP = "classgroup";
    private static final String PARAM_RDFTYPE = "type";
    private static final String PARAM_QUERY_TEXT = "querytext";
    protected static final Map<Format, Map<Result, String>> templateTable = PagedSearchController.setupTemplateTable();
    public static final int MAX_QUERY_LENGTH = 500;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VitroRequest vreq = new VitroRequest(request);
        boolean wasXmlRequested = this.isRequestedFormatXml(vreq);
        boolean wasCSVRequested = this.isRequestedFormatCSV(vreq);
        if (!wasXmlRequested && !wasCSVRequested) {
            super.doGet((HttpServletRequest)vreq, response);
        } else if (wasXmlRequested) {
            try {
                ResponseValues rvalues = this.processRequest(vreq);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/xml;charset=UTF-8");
                response.setHeader("Content-Disposition", "attachment; filename=search.xml");
                this.writeTemplate(rvalues.getTemplateName(), rvalues.getMap(), request, response);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        } else if (wasCSVRequested) {
            try {
                ResponseValues rvalues = this.processRequest(vreq);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/csv;charset=UTF-8");
                response.setHeader("Content-Disposition", "attachment; filename=search.csv");
                this.writeTemplate(rvalues.getTemplateName(), rvalues.getMap(), request, response);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        Format format = this.getFormat(vreq);
        boolean wasXmlRequested = Format.XML == format;
        boolean wasCSVRequested = Format.CSV == format;
        log.debug((Object)("Requested format was " + (wasXmlRequested ? PARAM_XML_REQUEST : "html")));
        boolean wasHtmlRequested = !wasXmlRequested && !wasCSVRequested;
        try {
            if (vreq.getWebappDaoFactory() == null || vreq.getWebappDaoFactory().getIndividualDao() == null) {
                log.error((Object)"Could not get webappDaoFactory or IndividualDao");
                throw new Exception("Could not access model.");
            }
            IndividualDao iDao = vreq.getWebappDaoFactory().getIndividualDao();
            VClassGroupDao grpDao = vreq.getWebappDaoFactory().getVClassGroupDao();
            VClassDao vclassDao = vreq.getWebappDaoFactory().getVClassDao();
            ApplicationBean appBean = vreq.getAppBean();
            log.debug((Object)("IndividualDao is " + iDao.toString() + " Public classes in the classgroup are " + grpDao.getPublicGroupsWithVClasses().toString()));
            log.debug((Object)("VClassDao is " + vclassDao.toString()));
            int startIndex = this.getStartIndex(vreq);
            int hitsPerPage = this.getHitsPerPage(vreq);
            String queryText = vreq.getParameter(PARAM_QUERY_TEXT);
            log.debug((Object)("Query text is \"" + queryText + "\""));
            String badQueryMsg = this.badQueryText(queryText, vreq);
            if (badQueryMsg != null) {
                return this.doFailedSearch(badQueryMsg, queryText, format, vreq);
            }
            SearchQuery query = this.getQuery(queryText, hitsPerPage, startIndex, vreq);
            SearchEngine search = ApplicationUtils.instance().getSearchEngine();
            SearchResponse response = null;
            try {
                response = search.query(query);
            }
            catch (Exception ex) {
                String msg = this.makeBadSearchMessage(queryText, ex.getMessage(), vreq);
                log.error((Object)"could not run search query", (Throwable)ex);
                return this.doFailedSearch(msg, queryText, format, vreq);
            }
            if (response == null) {
                log.error((Object)"Search response was null");
                return this.doFailedSearch(I18n.text((HttpServletRequest)vreq, "error_in_search_request", new Object[0]), queryText, format, vreq);
            }
            SearchResultDocumentList docs = response.getResults();
            if (docs == null) {
                log.error((Object)"Document list for a search was null");
                return this.doFailedSearch(I18n.text((HttpServletRequest)vreq, "error_in_search_request", new Object[0]), queryText, format, vreq);
            }
            long hitCount = docs.getNumFound();
            log.debug((Object)("Number of hits = " + hitCount));
            if (hitCount < 1L) {
                return this.doNoHits(queryText, format, vreq);
            }
            ArrayList<Individual> individuals = new ArrayList<Individual>(docs.size());
            for (SearchResultDocument doc : docs) {
                try {
                    String uri = doc.getStringValue("URI");
                    Individual ind = iDao.getIndividualByURI(uri);
                    if (ind == null) continue;
                    ind.setSearchSnippet(this.getSnippet(doc, response));
                    individuals.add(ind);
                }
                catch (Exception e) {
                    log.error((Object)"Problem getting usable individuals from search hits. ", (Throwable)e);
                }
            }
            UrlBuilder.ParamMap pagingLinkParams = new UrlBuilder.ParamMap();
            pagingLinkParams.put(PARAM_QUERY_TEXT, queryText);
            pagingLinkParams.put(PARAM_HITS_PER_PAGE, String.valueOf(hitsPerPage));
            if (wasXmlRequested) {
                pagingLinkParams.put(PARAM_XML_REQUEST, "1");
            }
            HashMap<String, Object> body = new HashMap<String, Object>();
            String classGroupParam = vreq.getParameter(PARAM_CLASSGROUP);
            log.debug((Object)("ClassGroupParam is \"" + classGroupParam + "\""));
            boolean classGroupFilterRequested = false;
            if (!StringUtils.isEmpty((CharSequence)classGroupParam)) {
                VClassGroup grp = grpDao.getGroupByURI(classGroupParam);
                classGroupFilterRequested = true;
                if (grp != null && grp.getPublicName() != null) {
                    body.put("classGroupName", grp.getPublicName());
                }
            }
            String typeParam = vreq.getParameter(PARAM_RDFTYPE);
            boolean typeFilterRequested = false;
            if (!StringUtils.isEmpty((CharSequence)typeParam)) {
                VClass type = vclassDao.getVClassByURI(typeParam);
                typeFilterRequested = true;
                if (type != null && type.getName() != null) {
                    body.put("typeName", type.getName());
                }
            }
            if (wasHtmlRequested) {
                if (!classGroupFilterRequested && !typeFilterRequested) {
                    body.put("classGroupLinks", this.getClassGroupsLinks(vreq, grpDao, docs, response, queryText));
                } else if (classGroupFilterRequested && !typeFilterRequested) {
                    body.put("classLinks", this.getVClassLinks(vclassDao, docs, response, queryText));
                    pagingLinkParams.put(PARAM_CLASSGROUP, classGroupParam);
                } else {
                    pagingLinkParams.put(PARAM_RDFTYPE, typeParam);
                }
            }
            body.put("individuals", IndividualSearchResult.getIndividualTemplateModels(individuals, vreq));
            body.put(PARAM_QUERY_TEXT, queryText);
            body.put("title", appBean.getApplicationName() + " - " + I18n.text((HttpServletRequest)vreq, "search_results_for", new Object[0]) + " '" + queryText + "'");
            body.put("hitCount", hitCount);
            body.put(PARAM_START_INDEX, startIndex);
            body.put("pagingLinks", PagedSearchController.getPagingLinks(startIndex, hitsPerPage, hitCount, vreq.getServletPath(), pagingLinkParams, vreq));
            if (startIndex != 0) {
                body.put("prevPage", this.getPreviousPageLink(startIndex, hitsPerPage, vreq.getServletPath(), pagingLinkParams));
            }
            if ((long)startIndex < hitCount - (long)hitsPerPage) {
                body.put("nextPage", this.getNextPageLink(startIndex, hitsPerPage, vreq.getServletPath(), pagingLinkParams));
            }
            try {
                OpenSocialManager openSocialManager = new OpenSocialManager(vreq, "search");
                if ("http://vivoweb.org/ontology#vitroClassGrouppeople".equals(vreq.getParameter(PARAM_CLASSGROUP))) {
                    List<String> ids = OpenSocialManager.getOpenSocialId(individuals);
                    openSocialManager.setPubsubData("JSONPersonIds", OpenSocialManager.buildJSONPersonIds(ids, "" + ids.size() + " people found"));
                }
                openSocialManager.removePubsubGadgetsWithoutData();
                body.put("openSocial", openSocialManager);
                if (openSocialManager.isVisible()) {
                    body.put("bodyOnload", "my.init();");
                }
            }
            catch (IOException e) {
                log.error((Object)"IOException in doTemplate()", (Throwable)e);
            }
            catch (SQLException e) {
                log.error((Object)"SQLException in doTemplate()", (Throwable)e);
            }
            String template = templateTable.get((Object)format).get((Object)Result.PAGED);
            return new TemplateResponseValues(template, body);
        }
        catch (Throwable e) {
            return this.doSearchError(e, format);
        }
    }

    private int getHitsPerPage(VitroRequest vreq) {
        int hitsPerPage = 25;
        try {
            hitsPerPage = Integer.parseInt(vreq.getParameter(PARAM_HITS_PER_PAGE));
        }
        catch (Throwable e) {
            hitsPerPage = 25;
        }
        log.debug((Object)("hitsPerPage is " + hitsPerPage));
        return hitsPerPage;
    }

    private int getStartIndex(VitroRequest vreq) {
        int startIndex = 0;
        try {
            startIndex = Integer.parseInt(vreq.getParameter(PARAM_START_INDEX));
        }
        catch (Throwable e) {
            startIndex = 0;
        }
        log.debug((Object)("startIndex is " + startIndex));
        return startIndex;
    }

    private String badQueryText(String qtxt, VitroRequest vreq) {
        if (qtxt == null || "".equals(qtxt.trim())) {
            return I18n.text((HttpServletRequest)vreq, "enter_search_term", new Object[0]);
        }
        if (qtxt.equals("*:*")) {
            return I18n.text((HttpServletRequest)vreq, "invalid_search_term", new Object[0]);
        }
        return null;
    }

    private List<VClassGroupSearchLink> getClassGroupsLinks(VitroRequest vreq, VClassGroupDao grpDao, SearchResultDocumentList docs, SearchResponse rsp, String qtxt) {
        HashMap<String, Long> cgURItoCount = new HashMap<String, Long>();
        ArrayList<VClassGroup> classgroups = new ArrayList<VClassGroup>();
        List<SearchFacetField> ffs = rsp.getFacetFields();
        for (SearchFacetField ff : ffs) {
            if (!PARAM_CLASSGROUP.equals(ff.getName())) continue;
            List<SearchFacetField.Count> counts = ff.getValues();
            for (SearchFacetField.Count ct : counts) {
                VClassGroup vcg = grpDao.getGroupByURI(ct.getName());
                if (vcg == null) {
                    log.debug((Object)("could not get classgroup for URI " + ct.getName()));
                    continue;
                }
                classgroups.add(vcg);
                cgURItoCount.put(vcg.getURI(), ct.getCount());
            }
        }
        grpDao.sortGroupList(classgroups);
        VClassGroupsForRequest vcgfr = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
        ArrayList<VClassGroupSearchLink> classGroupLinks = new ArrayList<VClassGroupSearchLink>(classgroups.size());
        for (VClassGroup vcg : classgroups) {
            String groupURI = vcg.getURI();
            VClassGroup localizedVcg = vcgfr.getGroup(groupURI);
            long count = (Long)cgURItoCount.get(groupURI);
            if (localizedVcg.getPublicName() == null || count <= 0L) continue;
            classGroupLinks.add(new VClassGroupSearchLink(qtxt, localizedVcg, count));
        }
        return classGroupLinks;
    }

    private List<VClassSearchLink> getVClassLinks(VClassDao vclassDao, SearchResultDocumentList docs, SearchResponse rsp, String qtxt) {
        HashSet<String> typesInHits = this.getVClassUrisForHits(docs);
        ArrayList<VClass> classes = new ArrayList<VClass>(typesInHits.size());
        HashMap<String, Long> typeURItoCount = new HashMap<String, Long>();
        List<SearchFacetField> ffs = rsp.getFacetFields();
        for (SearchFacetField ff : ffs) {
            if (!PARAM_RDFTYPE.equals(ff.getName())) continue;
            List<SearchFacetField.Count> counts = ff.getValues();
            for (SearchFacetField.Count ct : counts) {
                String typeUri = ct.getName();
                long count = ct.getCount();
                try {
                    VClass type;
                    if ("http://www.w3.org/2002/07/owl#Thing".equals(typeUri) || count == 0L || (type = vclassDao.getVClassByURI(typeUri)) == null || type.isAnonymous() || type.getName() == null || "".equals(type.getName()) || type.getGroupURI() == null) continue;
                    typeURItoCount.put(typeUri, count);
                    classes.add(type);
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("could not add type " + typeUri), (Throwable)ex);
                }
            }
        }
        classes.sort(new Comparator<VClass>(){

            @Override
            public int compare(VClass o1, VClass o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<VClassSearchLink> vClassLinks = new ArrayList<VClassSearchLink>(classes.size());
        for (VClass vc : classes) {
            long count = (Long)typeURItoCount.get(vc.getURI());
            vClassLinks.add(new VClassSearchLink(qtxt, vc, count));
        }
        return vClassLinks;
    }

    private HashSet<String> getVClassUrisForHits(SearchResultDocumentList docs) {
        HashSet<String> typesInHits = new HashSet<String>();
        for (SearchResultDocument doc : docs) {
            try {
                Collection<Object> types = doc.getFieldValues(PARAM_RDFTYPE);
                if (types == null) continue;
                for (Object o : types) {
                    String typeUri = o.toString();
                    typesInHits.add(typeUri);
                }
            }
            catch (Exception e) {
                log.error((Object)"problems getting rdf:type for search hits", (Throwable)e);
            }
        }
        return typesInHits;
    }

    private String getSnippet(SearchResultDocument doc, SearchResponse response) {
        List<String> snippets;
        String docId = doc.getStringValue("DocId");
        StringBuilder text = new StringBuilder();
        Map<String, Map<String, List<String>>> highlights = response.getHighlighting();
        if (highlights != null && highlights.get(docId) != null && (snippets = highlights.get(docId).get("ALLTEXT")) != null && snippets.size() > 0) {
            text.append("... ").append(snippets.get(0)).append(" ...");
        }
        return text.toString();
    }

    private SearchQuery getQuery(String queryText, int hitsPerPage, int startIndex, VitroRequest vreq) {
        SearchQuery query = ApplicationUtils.instance().getSearchEngine().createQuery(queryText);
        query.setStart(startIndex).setRows(hitsPerPage);
        String classgroupParam = vreq.getParameter(PARAM_CLASSGROUP);
        String typeParam = vreq.getParameter(PARAM_RDFTYPE);
        if (!StringUtils.isBlank((CharSequence)classgroupParam)) {
            log.debug((Object)"Firing classgroup query ");
            log.debug((Object)("request.getParameter(classgroup) is " + classgroupParam));
            query.addFilterQuery("classgroup:\"" + classgroupParam + "\"");
            query.addFacetFields(PARAM_RDFTYPE).setFacetLimit(-1);
        } else if (!StringUtils.isBlank((CharSequence)typeParam)) {
            log.debug((Object)"Firing type query ");
            log.debug((Object)("request.getParameter(type) is " + typeParam));
            query.addFilterQuery("type:\"" + typeParam + "\"");
        } else {
            query.addFacetFields(PARAM_CLASSGROUP).setFacetLimit(-1);
        }
        log.debug((Object)("Query = " + query.toString()));
        return query;
    }

    protected static List<PagingLink> getPagingLinks(int startIndex, int hitsPerPage, long hitCount, String baseUrl, UrlBuilder.ParamMap params, VitroRequest vreq) {
        ArrayList<PagingLink> pagingLinks = new ArrayList<PagingLink>();
        if (hitCount <= (long)hitsPerPage) {
            return pagingLinks;
        }
        int maxHitCount = 1000;
        if (startIndex >= 1000 - hitsPerPage) {
            maxHitCount = startIndex + 1000;
        }
        int i = 0;
        while ((long)i < hitCount) {
            params.put(PARAM_START_INDEX, String.valueOf(i));
            if (i < maxHitCount - hitsPerPage) {
                boolean iIsCurrentPage;
                int pageNumber = i / hitsPerPage + 1;
                boolean bl = iIsCurrentPage = i >= startIndex && i < startIndex + hitsPerPage;
                if (iIsCurrentPage) {
                    pagingLinks.add(new PagingLink(pageNumber));
                } else {
                    pagingLinks.add(new PagingLink(pageNumber, baseUrl, params));
                }
            } else {
                pagingLinks.add(new PagingLink(I18n.text((HttpServletRequest)vreq, "paging_link_more", new Object[0]), baseUrl, params));
                break;
            }
            i += hitsPerPage;
        }
        return pagingLinks;
    }

    private String getPreviousPageLink(int startIndex, int hitsPerPage, String baseUrl, UrlBuilder.ParamMap params) {
        params.put(PARAM_START_INDEX, String.valueOf(startIndex - hitsPerPage));
        return UrlBuilder.getUrl(baseUrl, params);
    }

    private String getNextPageLink(int startIndex, int hitsPerPage, String baseUrl, UrlBuilder.ParamMap params) {
        params.put(PARAM_START_INDEX, String.valueOf(startIndex + hitsPerPage));
        return UrlBuilder.getUrl(baseUrl, params);
    }

    private ExceptionResponseValues doSearchError(Throwable e, Format f) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("message", "Search failed: " + e.getMessage());
        return new ExceptionResponseValues(PagedSearchController.getTemplate(f, Result.ERROR), body, e);
    }

    private TemplateResponseValues doFailedSearch(String message, String querytext, Format f, VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "search_for", querytext));
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = I18n.text((HttpServletRequest)vreq, "search_failed", new Object[0]);
        }
        body.put("message", message);
        return new TemplateResponseValues(PagedSearchController.getTemplate(f, Result.ERROR), body);
    }

    private TemplateResponseValues doNoHits(String querytext, Format f, VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "search_for", querytext));
        body.put("message", I18n.text((HttpServletRequest)vreq, "no_matching_results", new Object[0]));
        return new TemplateResponseValues(PagedSearchController.getTemplate(f, Result.ERROR), body);
    }

    private String makeBadSearchMessage(String querytext, String exceptionMsg, VitroRequest vreq) {
        String rv = "";
        try {
            int post;
            int errorWindow;
            int coli = exceptionMsg.indexOf("column");
            if (coli == -1) {
                return "";
            }
            int numi = exceptionMsg.indexOf(".", coli + 7);
            if (numi == -1) {
                return "";
            }
            String part = exceptionMsg.substring(coli + 7, numi);
            int i = Integer.parseInt(part) - 1;
            int pre = i - (errorWindow = 5);
            if (pre < 0) {
                pre = 0;
            }
            if ((post = i + errorWindow) > querytext.length()) {
                post = querytext.length();
            }
            String before = querytext.substring(pre, i);
            String after = "";
            if (post > i) {
                after = querytext.substring(i + 1, post);
            }
            rv = I18n.text((HttpServletRequest)vreq, "search_term_error_near", new Object[0]) + " <span class='searchQuote'>" + before + "<span class='searchError'>" + querytext.charAt(i) + "</span>" + after + "</span>";
        }
        catch (Throwable ex) {
            return "";
        }
        return rv;
    }

    protected boolean isRequestedFormatXml(VitroRequest req) {
        if (req != null) {
            String param = req.getParameter(PARAM_XML_REQUEST);
            return param != null && "1".equals(param);
        }
        return false;
    }

    protected boolean isRequestedFormatCSV(VitroRequest req) {
        if (req != null) {
            String param = req.getParameter(PARAM_CSV_REQUEST);
            return param != null && "1".equals(param);
        }
        return false;
    }

    protected Format getFormat(VitroRequest req) {
        if (req != null && req.getParameter(PARAM_XML_REQUEST) != null && "1".equals(req.getParameter(PARAM_XML_REQUEST))) {
            return Format.XML;
        }
        if (req != null && req.getParameter(PARAM_CSV_REQUEST) != null && "1".equals(req.getParameter(PARAM_CSV_REQUEST))) {
            return Format.CSV;
        }
        return Format.HTML;
    }

    protected static String getTemplate(Format format, Result result) {
        if (format != null && result != null) {
            return templateTable.get((Object)format).get((Object)result);
        }
        log.error((Object)"getTemplate() must not have a null format or result.");
        return templateTable.get((Object)Format.HTML).get((Object)Result.ERROR);
    }

    protected static Map<Format, Map<Result, String>> setupTemplateTable() {
        HashMap table = new HashMap();
        HashMap<Result, String> resultsToTemplates = new HashMap<Result, String>();
        resultsToTemplates.put(Result.PAGED, "search-pagedResults.ftl");
        resultsToTemplates.put(Result.ERROR, "search-error.ftl");
        table.put(Format.HTML, Collections.unmodifiableMap(resultsToTemplates));
        resultsToTemplates = new HashMap();
        resultsToTemplates.put(Result.PAGED, "search-xmlResults.ftl");
        resultsToTemplates.put(Result.ERROR, "search-xmlError.ftl");
        table.put(Format.XML, Collections.unmodifiableMap(resultsToTemplates));
        resultsToTemplates = new HashMap();
        resultsToTemplates.put(Result.PAGED, "search-csvResults.ftl");
        resultsToTemplates.put(Result.ERROR, "search-csvError.ftl");
        table.put(Format.CSV, Collections.unmodifiableMap(resultsToTemplates));
        return Collections.unmodifiableMap(table);
    }

    protected static class PagingLink
    extends LinkTemplateModel {
        PagingLink(int pageNumber, String baseUrl, UrlBuilder.ParamMap params) {
            super(String.valueOf(pageNumber), baseUrl, params);
        }

        PagingLink(int pageNumber) {
            this.setText(String.valueOf(pageNumber));
        }

        PagingLink(String text, String baseUrl, UrlBuilder.ParamMap params) {
            super(text, baseUrl, params);
        }
    }

    public static class VClassSearchLink
    extends LinkTemplateModel {
        long count = 0L;

        VClassSearchLink(String querytext, VClass type, long count) {
            super(type.getName(), "/search", PagedSearchController.PARAM_QUERY_TEXT, querytext, PagedSearchController.PARAM_RDFTYPE, type.getURI());
            this.count = count;
        }

        public String getCount() {
            return Long.toString(this.count);
        }
    }

    public static class VClassGroupSearchLink
    extends LinkTemplateModel {
        long count = 0L;

        VClassGroupSearchLink(String querytext, VClassGroup classgroup, long count) {
            super(classgroup.getPublicName(), "/search", PagedSearchController.PARAM_QUERY_TEXT, querytext, PagedSearchController.PARAM_CLASSGROUP, classgroup.getURI());
            this.count = count;
        }

        public String getCount() {
            return Long.toString(this.count);
        }
    }

    protected static enum Result {
        PAGED,
        ERROR,
        BAD_QUERY;

    }

    protected static enum Format {
        HTML,
        XML,
        CSV;

    }
}

