/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class RDFFilesLoader {
    private static final Log log = LogFactory.getLog(RDFFilesLoader.class);
    private static final String DEFAULT_RDF_FORMAT = "RDF/XML";
    private static final String RDF = "rdf";
    private static final String I18N = "i18n";
    private static final String FIRST_TIME = "firsttime";
    private static final String EVERY_TIME = "everytime";
    private static final DirectoryStream.Filter<Path> RDF_FILE_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path p) throws IOException {
            if (Files.isHidden(p)) {
                return false;
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                log.warn((Object)("RDF files in subdirectories are not loaded. Directory '" + p + "' ignored."));
                return false;
            }
            return !p.toString().endsWith(".md");
        }
    };

    public static void loadFirstTimeFiles(ServletContext ctx, String modelPath, Model model, boolean firstTime) {
        if (firstTime) {
            String home = RDFFilesLoader.locateHomeDirectory();
            Set<Path> paths = RDFFilesLoader.getPaths(home, RDF, modelPath, FIRST_TIME);
            Set<String> enabledLocales = RDFFilesLoader.getEnabledLocales(ctx);
            for (String locale : enabledLocales) {
                paths.addAll(RDFFilesLoader.getPaths(home, RDF, I18N, locale, modelPath, FIRST_TIME));
            }
            for (Path p : paths) {
                log.info((Object)("Loading " + RDFFilesLoader.relativePath(p, home)));
                RDFFilesLoader.readOntologyFileIntoModel(p, model);
            }
        } else {
            log.debug((Object)("Not loading first time files on '" + modelPath + "', firstTime=false"));
        }
    }

    public static void loadEveryTimeFiles(ServletContext ctx, String modelPath, OntModel model) {
        OntModel everytimeModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        String home = RDFFilesLoader.locateHomeDirectory();
        Set<Path> paths = RDFFilesLoader.getPaths(home, RDF, modelPath, EVERY_TIME);
        Set<String> enabledLocales = RDFFilesLoader.getEnabledLocales(ctx);
        for (String locale : enabledLocales) {
            paths.addAll(RDFFilesLoader.getPaths(home, RDF, I18N, locale, modelPath, EVERY_TIME));
        }
        for (Path p : paths) {
            log.info((Object)("Loading " + RDFFilesLoader.relativePath(p, home)));
            RDFFilesLoader.readOntologyFileIntoModel(p, (Model)everytimeModel);
        }
        model.addSubModel((Model)everytimeModel);
    }

    public static Set<String> getEnabledLocales(ServletContext ctx) {
        HashSet<String> enabledLocales = new HashSet<String>();
        List<Locale> locales = SelectedLocale.getSelectableLocales(ctx);
        for (Locale locale : locales) {
            enabledLocales.add(locale.toLanguageTag().replace('-', '_'));
        }
        if (enabledLocales.isEmpty()) {
            enabledLocales.add(SelectedLocale.getFallbackLocale().toString());
        }
        return enabledLocales;
    }

    private static Path relativePath(Path p, String home) {
        try {
            return Paths.get(home, new String[0]).relativize(p);
        }
        catch (Exception e) {
            return p;
        }
    }

    private static Set<Path> getPaths(String parentDir, String ... strings) {
        Path dir = Paths.get(parentDir, strings);
        TreeSet<Path> paths = new TreeSet<Path>();
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, RDF_FILE_FILTER);){
                for (Path p : stream) {
                    paths.add(p);
                }
            }
            catch (IOException e) {
                log.warn((Object)("Failed to read directory '" + dir + "'"), (Throwable)e);
            }
        } else {
            log.debug((Object)("Directory '" + dir + "' doesn't exist."));
        }
        log.debug((Object)("Paths from '" + dir + "': " + paths));
        return paths;
    }

    private static void readOntologyFileIntoModel(Path p, Model model) {
        String format = RDFFilesLoader.getRdfFormat(p);
        log.debug((Object)("Loading " + p));
        try (FileInputStream stream = new FileInputStream(p.toFile());){
            model.read((InputStream)stream, null, format);
            log.debug((Object)"...successful");
        }
        catch (Exception e) {
            log.warn((Object)("Could not load file '" + p + "' as " + format + ". Check that it contains valid data."), (Throwable)e);
        }
    }

    private static String getRdfFormat(Path p) {
        String filename = p.getFileName().toString().toLowerCase();
        if (filename.endsWith("n3")) {
            return "N3";
        }
        if (filename.endsWith("nt")) {
            return "N-TRIPLES";
        }
        if (filename.endsWith("ttl")) {
            return "TURTLE";
        }
        return DEFAULT_RDF_FORMAT;
    }

    private static String locateHomeDirectory() {
        return ApplicationUtils.instance().getHomeDirectory().getPath().toString();
    }

    private RDFFilesLoader() {
    }
}

