/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.reasoner.ReasonerPlugin;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxListener;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.RDFNode;

public class SimpleReasonerSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog((String)SimpleReasonerSetup.class.getName());
    public static final String FILE_OF_PLUGINS = "/WEB-INF/resources/reasoner_plugins.txt";
    public static final String JENA_INF_MODEL_REBUILD = "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf-rebuild";
    public static final String JENA_INF_MODEL_SCRATCHPAD = "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf-scratchpad";
    private static final String RECOMPUTE_REQUIRED_ATTR = SimpleReasonerSetup.class.getName() + ".recomputeRequired";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        SearchIndexer searchIndexer = ApplicationUtils.instance().getSearchIndexer();
        try {
            Model scratchModel;
            OntModel tboxAssertionsModel = ModelAccess.on(ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
            OntModel tboxInferencesModel = ModelAccess.on(ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/inferred-tbox");
            OntModel tboxUnionModel = ModelAccess.on(ctx).getOntModel("vitro:tboxOntModel");
            RDFService rdfService = ModelAccess.on(ctx).getRDFService();
            Dataset dataset = ModelAccess.on(ctx).getDataset();
            Model rebuildModel = dataset.getNamedModel(JENA_INF_MODEL_REBUILD);
            if (rebuildModel.contains(null, null, (RDFNode)null)) {
                log.info((Object)"Clearing obsolete data from inference rebuild model");
                rebuildModel.removeAll();
            }
            if ((scratchModel = dataset.getNamedModel(JENA_INF_MODEL_SCRATCHPAD)).contains(null, null, (RDFNode)null)) {
                log.info((Object)"Clearing obsolete data from inference scratchpad model");
                scratchModel.removeAll();
            }
            Model inferenceModel = dataset.getNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf");
            SimpleReasoner simpleReasoner = new SimpleReasoner(tboxUnionModel, rdfService, inferenceModel, rebuildModel, scratchModel, searchIndexer);
            sce.getServletContext().setAttribute(SimpleReasoner.class.getName(), (Object)simpleReasoner);
            StartupStatus ss = StartupStatus.getBean(ctx);
            ArrayList<ReasonerPlugin> pluginList = new ArrayList<ReasonerPlugin>();
            List<String> pluginClassnameList = this.readFileOfListeners(ctx);
            for (String classname : pluginClassnameList) {
                try {
                    ReasonerPlugin plugin = (ReasonerPlugin)Class.forName(classname).getConstructors()[0].newInstance(new Object[0]);
                    plugin.setSimpleReasoner(simpleReasoner);
                    if (plugin.isConfigurationOnlyPlugin()) continue;
                    pluginList.add(plugin);
                    log.info((Object)("adding reasoner plugin " + plugin.getClass().getName()));
                }
                catch (Throwable t) {
                    ss.info(this, "Could not instantiate reasoner plugin " + classname);
                }
            }
            simpleReasoner.setPluginList(pluginList);
            SimpleReasonerTBoxListener simpleReasonerTBoxListener = new SimpleReasonerTBoxListener(simpleReasoner);
            sce.getServletContext().setAttribute(SimpleReasonerTBoxListener.class.getName(), (Object)simpleReasonerTBoxListener);
            tboxAssertionsModel.register((ModelChangedListener)simpleReasonerTBoxListener);
            tboxInferencesModel.register((ModelChangedListener)simpleReasonerTBoxListener);
            RecomputeMode mode = SimpleReasonerSetup.getRecomputeRequired(ctx);
            if (RecomputeMode.FOREGROUND.equals((Object)mode)) {
                log.info((Object)"ABox inference recompute required.");
                simpleReasoner.recompute();
            } else if (RecomputeMode.BACKGROUND.equals((Object)mode)) {
                log.info((Object)"starting ABox inference recompute in a separate thread.");
                new VitroBackgroundThread(new ABoxRecomputer(simpleReasoner), "ABoxRecomputer").start();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        SimpleReasonerTBoxListener simpleReasonerTBoxListener;
        log.info((Object)"received contextDestroyed notification");
        SimpleReasoner simpleReasoner = SimpleReasonerSetup.getSimpleReasonerFromServletContext(sce.getServletContext());
        if (simpleReasoner != null) {
            log.info((Object)"sending stop request to SimpleReasoner");
            simpleReasoner.setStopRequested();
        }
        if ((simpleReasonerTBoxListener = SimpleReasonerSetup.getSimpleReasonerTBoxListenerFromContext(sce.getServletContext())) != null) {
            log.info((Object)"sending stop request to simpleReasonerTBoxListener");
            simpleReasonerTBoxListener.setStopRequested();
        }
    }

    public static SimpleReasoner getSimpleReasonerFromServletContext(ServletContext ctx) {
        Object simpleReasoner = ctx.getAttribute(SimpleReasoner.class.getName());
        if (simpleReasoner instanceof SimpleReasoner) {
            return (SimpleReasoner)simpleReasoner;
        }
        return null;
    }

    public static SimpleReasonerTBoxListener getSimpleReasonerTBoxListenerFromContext(ServletContext ctx) {
        Object simpleReasonerTBoxListener = ctx.getAttribute(SimpleReasonerTBoxListener.class.getName());
        if (simpleReasonerTBoxListener instanceof SimpleReasonerTBoxListener) {
            return (SimpleReasonerTBoxListener)((Object)simpleReasonerTBoxListener);
        }
        return null;
    }

    public static void setRecomputeRequired(ServletContext ctx, RecomputeMode mode) {
        ctx.setAttribute(RECOMPUTE_REQUIRED_ATTR, (Object)mode);
    }

    public static RecomputeMode getRecomputeRequired(ServletContext ctx) {
        return (RecomputeMode)((Object)ctx.getAttribute(RECOMPUTE_REQUIRED_ATTR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFileOfListeners(ServletContext ctx) {
        ArrayList<String> list = new ArrayList<String>();
        StartupStatus ss = StartupStatus.getBean(ctx);
        InputStream is = null;
        BufferedReader br = null;
        try {
            String line;
            is = ctx.getResourceAsStream(FILE_OF_PLUGINS);
            br = new BufferedReader(new InputStreamReader(is));
            while (null != (line = br.readLine())) {
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
                list.add(trimmed);
            }
        }
        catch (NullPointerException e) {
        }
        catch (IOException e) {
            ss.fatal(this, "Failed while processing the list of startup listeners:  /WEB-INF/resources/reasoner_plugins.txt", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        log.debug((Object)("Classnames of reasoner plugins = " + list));
        return list;
    }

    private class ABoxRecomputer
    implements Runnable {
        private SimpleReasoner simpleReasoner;

        public ABoxRecomputer(SimpleReasoner simpleReasoner) {
            this.simpleReasoner = simpleReasoner;
        }

        @Override
        public void run() {
            this.simpleReasoner.recompute();
        }
    }

    public static enum RecomputeMode {
        FOREGROUND,
        BACKGROUND;

    }
}

