/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.jfact;

import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerStatementPattern;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxChanges;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxReasoner;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.TBoxInferencesAccumulator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.jfact.JFactFactory;

public class JFactTBoxReasoner
implements TBoxReasoner {
    private static final Log log = LogFactory.getLog(JFactTBoxReasoner.class);
    private final OWLReasonerFactory reasonerFactory;
    private final TBoxInferencesAccumulator accumulator;
    private final Model filteredAssertionsModel = ModelFactory.createDefaultModel();
    private final OntModel combinedInferencedModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);

    public JFactTBoxReasoner() {
        this.reasonerFactory = new JFactFactory();
        this.accumulator = new TBoxInferencesAccumulator();
    }

    @Override
    public void updateReasonerModel(TBoxChanges changes) {
        log.debug((Object)("Adding " + changes.getAddedStatements().size() + ", removing " + changes.getRemovedStatements().size()));
        this.filteredAssertionsModel.add(changes.getAddedStatements());
        this.filteredAssertionsModel.remove(changes.getRemovedStatements());
        this.clearEmptyAxiomStatements();
    }

    private void clearEmptyAxiomStatements() {
        StmtIterator axiomStatements = this.filteredAssertionsModel.listStatements(null, RDF.type, (RDFNode)ResourceFactory.createResource((String)OWLRDFVocabulary.OWL_AXIOM.toString()));
        ArrayList<Statement> removeStatements = new ArrayList<Statement>();
        while (axiomStatements.hasNext()) {
            Statement axiomStatement = axiomStatements.nextStatement();
            List axiomSubjectStatements = this.filteredAssertionsModel.listStatements(axiomStatement.getSubject(), null, (RDFNode)null).toList();
            if (axiomSubjectStatements.size() != 1) continue;
            removeStatements.add(axiomStatement);
        }
        if (removeStatements.size() > 0) {
            log.warn((Object)("The following statements are empty axiom statements and have been removed" + ((Object)removeStatements).toString()));
            this.filteredAssertionsModel.remove(removeStatements);
        } else {
            log.debug((Object)"No empty axiom statements were found");
        }
    }

    @Override
    public TBoxReasoner.Status performReasoning() {
        try {
            OWLOntology ont = this.copyModelToOntology(this.filteredAssertionsModel);
            OWLReasoner reasoner = this.createReasoner(ont);
            reasoner.precomputeInferences(InferenceType.values());
            try {
                if (!reasoner.isConsistent()) {
                    return TBoxReasoner.Status.inconsistent("Reasoner axioms are not consistent");
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                return TBoxReasoner.Status.ERROR;
            }
            Model inferences = this.accumulator.populateModelFromReasonerQueries(reasoner);
            this.mergeModels(this.filteredAssertionsModel, inferences);
            return TBoxReasoner.Status.SUCCESS;
        }
        catch (Exception e) {
            log.error((Object)e);
            return TBoxReasoner.Status.ERROR;
        }
    }

    private OWLOntology copyModelToOntology(Model m) throws OWLOntologyCreationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.write((OutputStream)out, "RDF/XML");
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return OWLManager.createOWLOntologyManager().loadOntologyFromOntologyDocument((InputStream)in);
    }

    private OWLReasoner createReasoner(OWLOntology ont) {
        SimpleConfiguration config = new SimpleConfiguration(50000L);
        OWLReasoner reasoner = this.reasonerFactory.createReasoner(ont, (OWLReasonerConfiguration)config);
        return reasoner;
    }

    private void mergeModels(Model assertions, Model inferences) {
        this.combinedInferencedModel.removeAll();
        this.combinedInferencedModel.add(assertions);
        this.combinedInferencedModel.add(inferences);
        log.debug((Object)("Assertions: " + assertions.size() + ", inferences: " + inferences.size() + ", combined:  " + this.combinedInferencedModel.size()));
    }

    @Override
    public List<ObjectProperty> listObjectProperties() {
        return this.combinedInferencedModel.listObjectProperties().toList();
    }

    @Override
    public List<DatatypeProperty> listDatatypeProperties() {
        return this.combinedInferencedModel.listDatatypeProperties().toList();
    }

    @Override
    public List<Restriction> listRestrictions() {
        return this.combinedInferencedModel.listRestrictions().toList();
    }

    @Override
    public List<Statement> filterResults(List<ReasonerStatementPattern> patternList) {
        ArrayList<Statement> filtered = new ArrayList<Statement>();
        for (ReasonerStatementPattern pattern : patternList) {
            filtered.addAll(pattern.matchStatementsFromModel((Model)this.combinedInferencedModel));
        }
        return filtered;
    }
}

