/* $This file is distributed under the terms of the license in LICENSE$ */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import java.util.Map;

/**
 * A class to get data based on configurations in RDF. These are useful for pages bug not specific to pages.
 * Consider using this interface when you need data based on RDF configuration.
 *
 * Instances should be short-lived, and only used on a single HTTP request. The getData method accepts only
 * a value map, so if stat is required from the request (or the servlet context), the request should be
 * passed to the constructor.
 *
 * Constructors:  Objects that implement this interface will be constructed by reflection with the following
 * constructor signatures in the following order:
 *  DataGetter( VitroRequest vreq, Model displayModel, String dataGetterURI )
 *  DataGetter( Model displayModel, String dataGetterURI )
 *  DataGetter( VitroRequest vreq )
 *  DataGetter()
 *
 * The main difference between this and PageDataGetter is that these are configured not based on page URI
 * but on DataGetter URI.  This allows a configuration of a DataGetter to be used in multiple situations.
 * The DataGetter is not passed information about what page it might be associated with.
 *
 * Using this interface is preferred over PageDataGetter because then the DataGetter can be associated with
 * things other than pages.
 *
 */
public interface DataGetter {

	/**
	 * Get data. Throwing an Exception is acceptable.
	 *
	 * @param valueMap
	 *            any values already generated by data getters or the controller.
	 *            Might be immutable, and should not be modified within the method.
	 *
	 * @return data to add to valueMap. Might be empty, but should not be null.
	 */
    Map<String,Object> getData( Map<String, Object> valueMap );

}
