/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.auth.policy.SelfEditingPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBeanStub;
import stubs.javax.servlet.ServletContextStub;

public class SelfEditingPolicy_2_Test
extends AbstractTestClass {
    private static final Log log = LogFactory.getLog(SelfEditingPolicy_2_Test.class);
    private static final String SAFE_NS = "http://test.mannlib.cornell.edu/ns/01#";
    private static final String ADMIN_NS = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#";
    private static final String SELFEDITOR_URI = "http://test.mannlib.cornell.edu/ns/01#individual000";
    private static final String SAFE_RESOURCE = "http://test.mannlib.cornell.edu/ns/01#individual123";
    private static final String SAFE_PREDICATE = "http://test.mannlib.cornell.edu/ns/01#hasHairStyle";
    private static final String ADMIN_RESOURCE = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#individual666";
    private static final String ADMIN_PREDICATE_1 = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hasSuperPowers";
    private static final String ADMIN_PREDICATE_2 = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mayPrintMoney";
    private static final String ADMIN_PREDICATE_3 = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#getsOutOfJailFree";
    private static final String ADMIN_PREDICATE_4 = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#canDeleteModel";
    SelfEditingPolicy policy;
    Individual seIndividual;
    IdentifierBundle ids;
    private OntModel ontModel;

    @Override
    @Before
    public void setUp() {
        ServletContextStub ctx = new ServletContextStub();
        PropertyRestrictionBeanStub.getInstance(new String[]{ADMIN_NS});
        this.policy = new SelfEditingPolicy((ServletContext)ctx);
        Assert.assertNotNull((Object)this.policy);
        this.seIndividual = new IndividualImpl();
        this.seIndividual.setURI(SELFEDITOR_URI);
        this.ids = new ArrayIdentifierBundle(new Identifier[]{new HasProfile(SELFEDITOR_URI)});
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    @Test
    public void nullRequestedAction() {
        PolicyDecision dec = this.policy.isAuthorized(this.ids, null);
        Assert.assertNotNull((Object)dec);
        Assert.assertEquals((Object)Authorization.INCONCLUSIVE, (Object)dec.getAuthorized());
    }

    @Test
    public void nullIdentifierBundle() {
        AddObjectPropertyStatement whatToAuth = new AddObjectPropertyStatement(this.ontModel, SELFEDITOR_URI, new Property(SAFE_PREDICATE), SAFE_RESOURCE);
        PolicyDecision dec = this.policy.isAuthorized(null, (RequestedAction)whatToAuth);
        Assert.assertNotNull((Object)dec);
        Assert.assertEquals((Object)Authorization.INCONCLUSIVE, (Object)dec.getAuthorized());
    }

    @Test
    public void noSelfEditorIdentifier() {
        this.ids.clear();
        this.ids.add((Object)new Identifier(){});
        this.assertAddObjectPropStmt(SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void addObjectPropStmtSuccess1() {
        this.assertAddObjectPropStmt(SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE, Authorization.AUTHORIZED);
    }

    @Test
    public void addObjectPropStmtSuccess2() {
        this.assertAddObjectPropStmt(SAFE_RESOURCE, SAFE_PREDICATE, SELFEDITOR_URI, Authorization.AUTHORIZED);
    }

    @Test
    public void addObjectPropStmtUnsafePredicate1() {
        this.assertAddObjectPropStmt(SELFEDITOR_URI, ADMIN_PREDICATE_1, SAFE_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void addObjectPropStmtUnsafePredicate2() {
        this.assertAddObjectPropStmt(SAFE_RESOURCE, ADMIN_PREDICATE_1, SELFEDITOR_URI, Authorization.INCONCLUSIVE);
    }

    @Test
    public void addObjectPropStmtUnsafePredicate3() {
        this.assertAddObjectPropStmt(SELFEDITOR_URI, ADMIN_PREDICATE_2, SAFE_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void addObjectPropStmtUnsafePredicate4() {
        this.assertAddObjectPropStmt(SELFEDITOR_URI, ADMIN_PREDICATE_3, SAFE_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void addObjectPropStmtUnsafePredicate5() {
        this.assertAddObjectPropStmt(SELFEDITOR_URI, ADMIN_PREDICATE_4, SAFE_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editObjectPropStmtSuccess1() {
        this.assertEditObjPropStmt(SELFEDITOR_URI, SAFE_PREDICATE, SAFE_RESOURCE, Authorization.AUTHORIZED);
    }

    @Test
    public void editObjectPropStmtSuccess2() {
        this.assertEditObjPropStmt(SAFE_RESOURCE, SAFE_PREDICATE, SELFEDITOR_URI, Authorization.AUTHORIZED);
    }

    @Test
    public void editObjectPropStmtEditorNotInvolved() {
        this.assertEditObjPropStmt(SAFE_RESOURCE, SAFE_PREDICATE, SAFE_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editObjectPropStmtUnsafeResource() {
        this.assertEditObjPropStmt(SELFEDITOR_URI, SAFE_PREDICATE, ADMIN_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editObjectPropStmtUnsafePredicate1() {
        this.assertEditObjPropStmt(SELFEDITOR_URI, ADMIN_PREDICATE_4, SAFE_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editObjectPropStmtUnsafePredicate2() {
        this.assertEditObjPropStmt(SAFE_RESOURCE, ADMIN_PREDICATE_4, SELFEDITOR_URI, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editObjectPropStmtUnsafeBoth() {
        this.assertEditObjPropStmt(SELFEDITOR_URI, ADMIN_PREDICATE_4, ADMIN_RESOURCE, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editDataPropSuccess() {
        this.assertEditDataPropStmt(SELFEDITOR_URI, SAFE_PREDICATE, "junk", Authorization.AUTHORIZED);
    }

    @Test
    public void editDataPropUnsafePredicate() {
        this.assertEditDataPropStmt(SELFEDITOR_URI, ADMIN_PREDICATE_1, "junk", Authorization.INCONCLUSIVE);
    }

    @Test
    public void editDataPropUnsafeResource() {
        this.assertEditDataPropStmt(ADMIN_RESOURCE, SAFE_PREDICATE, null, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editDataPropNoCloseRelation() {
        this.assertEditDataPropStmt(SAFE_RESOURCE, SAFE_PREDICATE, null, Authorization.INCONCLUSIVE);
    }

    @Test
    public void editDataPropModelProhibited() {
        this.assertEditDataPropStmt(SAFE_RESOURCE, ADMIN_PREDICATE_1, null, Authorization.INCONCLUSIVE);
    }

    private void assertAddObjectPropStmt(String uriOfSub, String uriOfPred, String uriOfObj, Authorization expectedAuthorization) {
        AddObjectPropertyStatement whatToAuth = new AddObjectPropertyStatement(this.ontModel, uriOfSub, new Property(uriOfPred), uriOfObj);
        PolicyDecision dec = this.policy.isAuthorized(this.ids, (RequestedAction)whatToAuth);
        log.debug((Object)dec);
        Assert.assertNotNull((Object)dec);
        Assert.assertEquals((Object)expectedAuthorization, (Object)dec.getAuthorized());
    }

    private void assertEditObjPropStmt(String uriOfSub, String uriOfPred, String uriOfObj, Authorization expectedAuthorization) {
        EditObjectPropertyStatement whatToAuth = new EditObjectPropertyStatement(this.ontModel, uriOfSub, new Property(uriOfPred), uriOfObj);
        PolicyDecision dec = this.policy.isAuthorized(this.ids, (RequestedAction)whatToAuth);
        log.debug((Object)dec);
        Assert.assertNotNull((Object)dec);
        Assert.assertEquals((Object)expectedAuthorization, (Object)dec.getAuthorized());
    }

    private void assertEditDataPropStmt(String individualURI, String datapropURI, String data, Authorization expectedAuthorization) {
        EditDataPropertyStatement whatToAuth = new EditDataPropertyStatement(this.ontModel, individualURI, datapropURI, RequestedAction.SOME_LITERAL);
        PolicyDecision dec = this.policy.isAuthorized(this.ids, (RequestedAction)whatToAuth);
        log.debug((Object)dec);
        Assert.assertNotNull((Object)dec);
        Assert.assertEquals((Object)expectedAuthorization, (Object)dec.getAuthorized());
    }
}

